/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.RefreshAccessException;
import org.exoplatform.services.cms.clouddrives.onedrive.DeltaDriveFiles;
import org.exoplatform.services.cms.clouddrives.onedrive.ExoGraphClientLogger;
import org.exoplatform.services.cms.clouddrives.onedrive.FileSendResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.HashSetCompatibleDriveItem;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveException;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveStoredToken;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveTokenResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.google.gson.Gson;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.google.gson.JsonObject;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.google.gson.JsonParser;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.Drive;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DriveItem;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DriveItemUploadableProperties;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.FileSystemInfo;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.Folder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.IGraphServiceClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ItemReference;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.SharingLink;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.Subscription;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.User;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.GraphServiceClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDriveItemCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDriveItemCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDriveItemDeltaCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDriveItemDeltaCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.utils.ChunkIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class OneDriveAPI {
    private final String redirectUrl;
    private String rootId;
    private String userId;
    private static final Log LOG = ExoLogger.getLogger(OneDriveAPI.class);
    private static final Log GRAPH_CLIENT_LOG = ExoLogger.getLogger((String)(OneDriveAPI.class.getSimpleName() + "_GraphClient"));
    private final OneDriveStoredToken storedToken;
    private final String clientId;
    private final String clientSecret;
    private final OneDriveToken oneDriveToken;
    private final HttpClient httpclient = HttpClients.createDefault();
    private final OneDriveSubscription oneDriveSubscription = new OneDriveSubscription();
    public static final String SCOPES = OneDriveAPI.scopes();
    private final Gson gson = new Gson();
    private IGraphServiceClient graphClient;

    private OneDriveTokenResponse retrieveAccessToken(String clientId, String clientSecret, String code, String refreshToken, String grantType, String redirectUrl) throws IOException, OneDriveException {
        HttpPost httppost = new HttpPost("https://login.microsoftonline.com/common/oauth2/v2.0/token");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(5);
        if (grantType.equals("refresh_token")) {
            params.add(new BasicNameValuePair("refresh_token", refreshToken));
        } else if (grantType.equals("authorization_code")) {
            params.add(new BasicNameValuePair("redirect_uri", redirectUrl));
            params.add(new BasicNameValuePair("code", code));
        } else {
            throw new OneDriveException("Error getting access token  due to unknown grandtype " + grantType);
        }
        params.add(new BasicNameValuePair("grant_type", grantType));
        params.add(new BasicNameValuePair("client_secret", clientSecret));
        params.add(new BasicNameValuePair("client_id", clientId));
        params.add(new BasicNameValuePair("scope", SCOPES));
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
        httppost.setEntity((HttpEntity)urlEncodedFormEntity);
        HttpResponse response = this.httpclient.execute((HttpUriRequest)httppost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (InputStream inputStream2 = entity.getContent();){
                OneDriveTokenResponse oneDriveTokenResponse;
                String responseBody = IOUtils.toString((InputStream)inputStream2, (Charset)Charset.forName("UTF-8"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("getToken ResponseBody := " + responseBody));
                }
                if ((oneDriveTokenResponse = this.gson.fromJson(responseBody, OneDriveTokenResponse.class)).getToken() != null && !oneDriveTokenResponse.getToken().isEmpty()) {
                    OneDriveTokenResponse oneDriveTokenResponse2 = oneDriveTokenResponse;
                    return oneDriveTokenResponse2;
                }
                LOG.error("Cannot read access token for clientId: {}, token: {}, refresh token: {}, scope: {}, redirect uri: {}, code: {}, grant type: {}, response body: {}", new Object[]{clientId, oneDriveTokenResponse.getToken(), oneDriveTokenResponse.getRefreshToken(), oneDriveTokenResponse.getScope(), redirectUrl, code, grantType, responseBody});
            }
        } else {
            LOG.error("Cannot get access token: empty response for client: {}, grant_type: {}", new Object[]{clientId, grantType});
        }
        throw new OneDriveException("Error getting access token for clientId " + clientId + ", refresh token " + refreshToken);
    }

    private OneDriveTokenResponse aquireAccessToken(String code, String redirectUrl) throws IOException, OneDriveException {
        return this.retrieveAccessToken(this.clientId, this.clientSecret, code, null, "authorization_code", redirectUrl);
    }

    private OneDriveTokenResponse renewAccessToken(String refreshToken, String redirectUrl) throws IOException, OneDriveException {
        return this.retrieveAccessToken(this.clientId, this.clientSecret, null, refreshToken, "refresh_token", redirectUrl);
    }

    public SharingLink createLink(String itemId, String type) throws OneDriveException {
        if (type.equalsIgnoreCase("embed")) {
            return this.graphClient.me().drive().items((String)itemId).createLink((String)"embed", (String)"anonymous").buildRequest().post().link;
        }
        if (type.equalsIgnoreCase("view")) {
            return this.graphClient.me().drive().items((String)itemId).createLink((String)"view", (String)"anonymous").buildRequest().post().link;
        }
        throw new OneDriveException("Link type must be either view or embed");
    }

    private static String scopes() {
        StringJoiner scopes = new StringJoiner(" ");
        scopes.add("https://graph.microsoft.com/User.Read").add("https://graph.microsoft.com/Files.ReadWrite.All").add("https://graph.microsoft.com/Sites.ReadWrite.All").add("offline_access");
        return scopes.toString();
    }

    private void initGraphClient() {
        this.graphClient = GraphServiceClient.builder().authenticationProvider(iHttpRequest -> {
            String accessToken = null;
            try {
                accessToken = this.getAccessToken();
            }
            catch (RefreshAccessException | OneDriveException e) {
                LOG.error((Object)"during initialization of graphClient an error occurred", (Throwable)e);
            }
            iHttpRequest.addHeader("Authorization", "Bearer " + accessToken);
        }).logger(new ExoGraphClientLogger(GRAPH_CLIENT_LOG)).buildClient();
    }

    OneDriveAPI(String clientId, String clientSecret, String authCode, String redirectUrl) throws IOException, CloudDriveException {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUrl = redirectUrl;
        OneDriveTokenResponse oneDriveTokenResponse = this.aquireAccessToken(authCode, redirectUrl);
        if (oneDriveTokenResponse == null) {
            throw new OneDriveException("Unable to retrieve access token, when onedriveApi initializes: clientId " + clientId);
        }
        this.storedToken = new OneDriveStoredToken();
        this.storedToken.store(oneDriveTokenResponse.getToken(), oneDriveTokenResponse.getRefreshToken(), Integer.valueOf(oneDriveTokenResponse.getExpires()).longValue());
        this.oneDriveToken = new OneDriveToken(oneDriveTokenResponse.getToken(), oneDriveTokenResponse.getRefreshToken());
        this.initGraphClient();
    }

    OneDriveAPI(String clientId, String clientSecret, String accessToken, String refreshToken, long expirationTime, String redirectUrl) throws CloudDriveException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> Creating OneDrive API by refresh token for client {}", new Object[]{clientId});
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUrl = redirectUrl;
        OneDriveTokenResponse oneDriveTokenResponse = null;
        oneDriveTokenResponse = this.renewAccessToken(refreshToken, redirectUrl);
        if (oneDriveTokenResponse == null) {
            throw new OneDriveException("Unable to retrieve access token, when onedriveApi initializes: clientId " + clientId);
        }
        this.storedToken = new OneDriveStoredToken();
        this.storedToken.store(oneDriveTokenResponse.getRefreshToken());
        this.oneDriveToken = new OneDriveToken(oneDriveTokenResponse.getToken(), oneDriveTokenResponse.getRefreshToken());
        this.initGraphClient();
    }

    private String getAccessToken() throws RefreshAccessException, OneDriveException {
        return this.oneDriveToken.getAccessToken();
    }

    public void updateToken(OneDriveStoredToken newToken) throws CloudDriveException {
        this.oneDriveToken.updateToken(newToken.getAccessToken(), newToken.getRefreshToken());
        this.storedToken.merge(newToken);
    }

    public void removeFolder(String fileId) {
        this.graphClient.me().drive().items(fileId).buildRequest().delete();
    }

    public void removeFile(String fileId) {
        this.graphClient.me().drive().items(fileId).buildRequest().delete();
    }

    public User getUser() {
        return this.graphClient.me().buildRequest().get();
    }

    public synchronized String getRootId() {
        if (this.rootId == null) {
            this.rootId = this.getRoot().id;
        }
        return this.rootId;
    }

    public synchronized String getUserId() {
        if (this.userId == null) {
            this.userId = this.getUser().id;
        }
        return this.userId;
    }

    private DriveItem getRoot() {
        return this.graphClient.me().drive().root().buildRequest().get();
    }

    private DriveItem createFolderRequestWrapper(String parentId, DriveItem folder) {
        JsonObject obj = new JsonParser().parse("{\n  \"name\": \"" + folder.name + "\",\n  \"folder\": { },\n  \"@microsoft.graph.conflictBehavior\": \"rename\"\n}").getAsJsonObject();
        String id = this.graphClient.customRequest("/me/drive/items/" + parentId + "/children").buildRequest().post(obj).get("id").getAsString();
        return this.getItem(id);
    }

    public DriveItem createFolder(String parentId, String name, Calendar created) {
        if (parentId == null || parentId.isEmpty()) {
            parentId = this.getRootId();
        }
        DriveItem folder = new DriveItem();
        folder.name = name;
        folder.parentReference = new ItemReference();
        folder.fileSystemInfo = new FileSystemInfo();
        folder.fileSystemInfo.createdDateTime = created;
        folder.parentReference.id = parentId;
        folder.folder = new Folder();
        return this.createFolderRequestWrapper(parentId, folder);
    }

    public DriveItem copyFile(String parentId, String fileName, String fileId) throws IOException, CloudDriveException {
        return this.copy(parentId, fileName, fileId, true);
    }

    public DriveItem copyFolder(String parentId, String name, String folderId) throws CloudDriveException, IOException {
        return this.copy(parentId, name, folderId, false);
    }

    public OneDriveStoredToken getStoredToken() {
        return this.storedToken;
    }

    @Deprecated
    public String getNotificationUrl() {
        return this.oneDriveSubscription.getNotificationUrl();
    }

    public Subscription getSubscription() {
        return this.graphClient.drives().byId(this.getUserId()).root().subscriptions("socketIO").buildRequest().get();
    }

    public DriveItem copy(String parentId, String fileName, String fileId, boolean isFile) throws RefreshAccessException, OneDriveException {
        String responseBody;
        String status;
        String location;
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> copy {}->{}/{}", new Object[]{fileName, parentId, fileName});
        }
        String request = "{\n      \"parentReference\" : {\n        \"id\" : \"" + parentId + "\"\n    },\n      \"name\" : \"" + fileName + "\"\n    }";
        HttpPost httppost = new HttpPost("https://graph.microsoft.com/v1.0/me/drive/items/" + fileId + "/copy");
        StringEntity stringEntity = new StringEntity(request, "UTF-8");
        httppost.setEntity((HttpEntity)stringEntity);
        httppost.addHeader("Authorization", "Bearer " + this.getAccessToken());
        httppost.addHeader("Content-type", "application/json");
        try (CloseableHttpResponse response = (CloseableHttpResponse)this.httpclient.execute((HttpUriRequest)httppost);){
            location = response.getHeaders("Location")[0].getValue();
        }
        catch (IOException e) {
            throw new OneDriveException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Location:= " + location));
        }
        JsonParser parser = new JsonParser();
        do {
            try {
                responseBody = this.getCopyResponseBody(location);
            }
            catch (IOException e) {
                throw new OneDriveException("Unable to retrieve copy response body for " + fileName, e);
            }
            status = parser.parse(responseBody.trim()).getAsJsonObject().get("status").getAsString();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Thread interrupted while sleeping on copy of " + fileName), (Throwable)e);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(">> Copy status: {} for {}", new Object[]{status, fileName});
        } while (!status.equalsIgnoreCase("failed") && !status.equalsIgnoreCase("completed"));
        if (status.equalsIgnoreCase("failed")) {
            Set fileNames = this.getFiles(parentId, isFile ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName).stream().filter(item -> isFile == (item.file != null)).map(item -> item.name).collect(Collectors.toSet());
            if (!fileNames.contains(fileName)) {
                throw new OneDriveException("Error copying file " + fileName + "[" + fileId + "] to parent " + parentId);
            }
            String newItemName = this.generateItemName(fileName, 1, isFile);
            for (int i = 2; i <= fileNames.size() && fileNames.contains(newItemName); ++i) {
                newItemName = this.generateItemName(fileName, i, isFile);
            }
            return this.copy(parentId, newItemName, fileId, isFile);
        }
        String resourceId = parser.parse(responseBody).getAsJsonObject().get("resourceId").getAsString();
        return this.getItem(resourceId);
    }

    private String generateItemName(String name, int number, boolean isFile) {
        if (name != null) {
            int lastDotPosition = name.lastIndexOf(".");
            if (!isFile || lastDotPosition == -1) {
                return name + " " + number;
            }
            String baseName = name.substring(0, lastDotPosition);
            String ext = name.substring(lastDotPosition);
            return baseName + " " + number + ext;
        }
        throw new IllegalArgumentException("Name should not be null");
    }

    private String getCopyResponseBody(String location) throws IOException {
        HttpGet httpGet = new HttpGet(location);
        try (CloseableHttpResponse response = (CloseableHttpResponse)this.httpclient.execute((HttpUriRequest)httpGet);){
            String responseBody;
            String string = responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            return string;
        }
    }

    public IDriveItemCollectionPage getDriveItemCollectionPage(String folderId) {
        IDriveItemCollectionPage collectionPage = folderId == null ? this.graphClient.me().drive().root().children().buildRequest().get() : this.graphClient.me().drive().items(folderId).children().buildRequest().get();
        return collectionPage;
    }

    private List<DriveItem> getFiles(String folderId, String startsWith) {
        QueryOption deltaTokenQuery = new QueryOption("filter", "startswith(name,'" + startsWith + "')");
        IDriveItemCollectionPage collectionPage = folderId == null ? this.graphClient.me().drive().root().children().buildRequest(Collections.singletonList(deltaTokenQuery)).get() : this.graphClient.me().drive().items(folderId).children().buildRequest(Collections.singletonList(deltaTokenQuery)).get();
        ArrayList<DriveItem> driveItems = new ArrayList<DriveItem>(collectionPage.getCurrentPage());
        IDriveItemCollectionRequestBuilder nextPage = (IDriveItemCollectionRequestBuilder)collectionPage.getNextPage();
        while (nextPage != null) {
            IDriveItemCollectionPage nextPageCollection = nextPage.buildRequest().get();
            driveItems.addAll(nextPageCollection.getCurrentPage());
            nextPage = (IDriveItemCollectionRequestBuilder)nextPageCollection.getNextPage();
        }
        return driveItems;
    }

    @Deprecated
    public List<DriveItem> getFiles(String folderId) {
        IDriveItemCollectionPage collectionPage = folderId == null ? this.graphClient.me().drive().root().children().buildRequest().get() : this.graphClient.me().drive().items(folderId).children().buildRequest().get();
        ArrayList<DriveItem> driveItems = new ArrayList<DriveItem>(collectionPage.getCurrentPage());
        IDriveItemCollectionRequestBuilder nextPage = (IDriveItemCollectionRequestBuilder)collectionPage.getNextPage();
        while (nextPage != null) {
            IDriveItemCollectionPage nextPageCollection = nextPage.buildRequest().get();
            driveItems.addAll(nextPageCollection.getCurrentPage());
            nextPage = (IDriveItemCollectionRequestBuilder)nextPageCollection.getNextPage();
            if (nextPage != null) continue;
        }
        return driveItems;
    }

    private FileSendResponse sendFile(String url, int startPosition, int contentLength, int size, byte[] data) throws IOException {
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.setRequestMethod("PUT");
        con.setRequestProperty("Content-Length", String.valueOf(contentLength));
        con.setRequestProperty("Content-Range", "bytes " + startPosition + "-" + (startPosition + contentLength - 1) + "/" + size);
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        try (OutputStream outputStream2 = con.getOutputStream();){
            outputStream2.write(data);
        }
        FileSendResponse fileSendResponse = new FileSendResponse();
        fileSendResponse.responseMessage = con.getResponseMessage();
        fileSendResponse.responseCode = con.getResponseCode();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String inputLine;
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            fileSendResponse.data = response.toString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> sendFile response \nmessage: {} \ncode: {} \ndata: {}", new Object[]{fileSendResponse.responseMessage, fileSendResponse.responseCode, fileSendResponse.data});
        }
        return fileSendResponse;
    }

    private DriveItem getDriveItemIfCreated(FileSendResponse fileSendResponse) {
        if (fileSendResponse.responseCode == 201) {
            JsonObject jsonDriveItem = new JsonParser().parse(fileSendResponse.data).getAsJsonObject();
            DriveItem createdFile = this.graphClient.me().drive().items(jsonDriveItem.get("id").getAsString()).buildRequest().get();
            return createdFile;
        }
        return null;
    }

    private String uploadUrlConflictRenameWrapper(String path, DriveItemUploadableProperties driveItemUploadableProperties) throws UnsupportedEncodingException {
        JsonObject uploadFileRequestBody = new JsonParser().parse("{\"item\": {\n    \"@odata.type\": \"microsoft.graph.driveItemUploadableProperties\",\n    \"@microsoft.graph.conflictBehavior\": \"rename\",\n    \"name\": \"" + driveItemUploadableProperties.name + "\"\n" + "  }}".trim()).getAsJsonObject();
        return this.graphClient.customRequest("/me/drive/root:/" + URLEncoder.encode(path, "UTF-8") + ":/createUploadSession").buildRequest().post(uploadFileRequestBody).get("uploadUrl").getAsString();
    }

    @Deprecated
    private String getUploadUrl(String path, DriveItemUploadableProperties driveItemUploadableProperties) throws UnsupportedEncodingException {
        return this.uploadUrlConflictRenameWrapper(path, driveItemUploadableProperties);
    }

    public ChangesIterator changes(String deltaToken) {
        return new ChangesIterator(deltaToken);
    }

    private String decodeUrlPath(String value) {
        try {
            value = URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)"UnsupportedEncodingException when decoding the url path");
        }
        return value;
    }

    private String encodeUrlPath(String value) throws URISyntaxException {
        URI uri = new URI(null, null, null, value = this.decodeUrlPath(value), null);
        String request = uri.toASCIIString();
        return request.startsWith("?") ? request.substring(1) : request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getInsertUploadUrl(String parentId, String name, String conflictBehavior) throws RefreshAccessException, OneDriveException {
        if (conflictBehavior.equals("fail") || !conflictBehavior.equals("rename")) {
            // empty if block
        }
        String request = "{\n  \"item\": {\n    \"@microsoft.graph.conflictBehavior\": \"" + conflictBehavior + "\"\n  }\n}";
        HttpPost httppost = null;
        try {
            httppost = new HttpPost("https://graph.microsoft.com/v1.0/me/drive/items/" + parentId + ":/" + this.encodeUrlPath(name) + ":/createUploadSession");
        }
        catch (URISyntaxException e) {
            throw new OneDriveException(e);
        }
        StringEntity stringEntity = new StringEntity(request, "UTF-8");
        httppost.setEntity((HttpEntity)stringEntity);
        httppost.addHeader("Authorization", "Bearer " + this.getAccessToken());
        httppost.addHeader("Content-type", "application/json");
        try (CloseableHttpResponse response = (CloseableHttpResponse)this.httpclient.execute((HttpUriRequest)httppost);){
            String responseBody;
            JsonObject responseAsJson;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)response);
            }
            if ((responseAsJson = new JsonParser().parse(responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8")).getAsJsonObject()).has("uploadUrl")) {
                String uploadUrl;
                String string = uploadUrl = responseAsJson.get("uploadUrl").getAsString();
                return string;
            }
            if (!responseAsJson.has("error")) throw new OneDriveException("Unable to retrieve url to upload file: parentId " + parentId + ", name " + name);
            JsonObject errorResponse = responseAsJson.get("error").getAsJsonObject();
            if (!errorResponse.has("code")) throw new OneDriveException("Unable to retrieve url to upload file: parentId " + parentId + ", name " + name);
            if (!StringUtils.equalsIgnoreCase((CharSequence)errorResponse.get("code").getAsString(), (CharSequence)"nameAlreadyExists")) throw new OneDriveException("Unable to retrieve url to upload file: parentId " + parentId + ", name " + name);
            if (!LOG.isDebugEnabled()) throw new OneDriveException("File with the same name remotely already exists: parentId " + parentId + ", name " + name);
            LOG.debug((Object)"Name Already Exists");
            throw new OneDriveException("File with the same name remotely already exists: parentId " + parentId + ", name " + name);
        }
        catch (IOException e) {
            throw new OneDriveException(e.getMessage(), e);
        }
    }

    String updateUploadUrl(String itemId) throws IOException, RefreshAccessException, OneDriveException {
        HttpPost httppost = new HttpPost("https://graph.microsoft.com/v1.0/me/drive/items/" + itemId + "/createUploadSession");
        httppost.addHeader("Authorization", "Bearer " + this.getAccessToken());
        httppost.addHeader("Content-type", "application/json");
        try (CloseableHttpResponse response = (CloseableHttpResponse)this.httpclient.execute((HttpUriRequest)httppost);){
            String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            String uploadUrl = new JsonParser().parse(responseBody).getAsJsonObject().get("uploadUrl").getAsString();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)uploadUrl);
            }
            String string = uploadUrl;
            return string;
        }
    }

    DriveItem insertUpdate(String uploadUrl, InputStream inputStream2) throws OneDriveException, IOException {
        int fileLength = inputStream2.available();
        FileSendResponse fileSendResponse = null;
        int bufferSize = 32768000;
        for (int i = 0; i < fileLength / bufferSize + 1; ++i) {
            int from = bufferSize * i;
            int to = bufferSize * (i + 1);
            if (to > fileLength) {
                to = fileLength;
            }
            int fileSliceSize = to - from;
            byte[] fileSlice = new byte[fileSliceSize];
            inputStream2.read(fileSlice, 0, fileSliceSize);
            fileSendResponse = this.sendFile(uploadUrl, from, fileSlice.length, fileLength, fileSlice);
            DriveItem driveItem = this.getDriveItemIfCreated(fileSendResponse);
            if (driveItem == null) continue;
            return driveItem;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> insertUpdate response \nmessage: {} \ncode: {} \ndata: {}", new Object[]{fileSendResponse.responseMessage, fileSendResponse.responseCode, fileSendResponse.data});
        }
        throw new OneDriveException("Failed to upload file to url " + uploadUrl);
    }

    public DriveItem insert(String parentId, String fileName, Calendar created, Calendar modified, InputStream inputStream2, String conflictBehavior) throws OneDriveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"insert file");
        }
        String updateUploadUrl = null;
        try {
            updateUploadUrl = this.getInsertUploadUrl(parentId, fileName, conflictBehavior);
            return this.insertUpdate(updateUploadUrl, inputStream2);
        }
        catch (IOException | RefreshAccessException | OneDriveException e) {
            throw new OneDriveException("Error insert file parentId " + parentId + ", fileName " + fileName + ": " + ((Throwable)e).getMessage(), (Throwable)e);
        }
    }

    public DriveItem updateFileContent(String itemId, Calendar created, Calendar modified, InputStream inputStream2) throws OneDriveException {
        try {
            String updateUploadUrl = this.updateUploadUrl(itemId);
            return this.insertUpdate(updateUploadUrl, inputStream2);
        }
        catch (Exception ex) {
            throw new OneDriveException("Error  update file content for itemId " + itemId + ": " + ex.getMessage(), ex);
        }
    }

    private DriveItem updateFileWrapper(DriveItem item) {
        JsonObject updateFileRequestBody = new JsonParser().parse("  {\n            \"parentReference\": {\n            \"id\": \"" + item.parentReference.id + "\"\n        },\n            \"name\": \"" + item.name + "\",\n            \"@microsoft.graph.conflictBehavior\" : \"rename\"\n        }").getAsJsonObject();
        String updatedFileId = this.graphClient.customRequest("/me/drive/items/" + item.id).buildRequest().patch(updateFileRequestBody).get("id").getAsString();
        return this.getItem(updatedFileId);
    }

    public DeltaDriveFiles getAllFiles() {
        String deltaToken = null;
        ArrayList<DriveItem> changes = new ArrayList<DriveItem>();
        IDriveItemDeltaCollectionPage deltaCollectionPage = this.delta(null);
        while (true) {
            changes.addAll(deltaCollectionPage.getCurrentPage());
            IDriveItemDeltaCollectionRequestBuilder nextPage = (IDriveItemDeltaCollectionRequestBuilder)deltaCollectionPage.getNextPage();
            if (nextPage == null) break;
            deltaCollectionPage = nextPage.buildRequest().get();
        }
        deltaToken = this.extractDeltaToken(deltaCollectionPage.deltaLink());
        return new DeltaDriveFiles(deltaToken, changes);
    }

    public DriveItem updateFile(DriveItem driveItem) {
        return this.updateFileWrapper(driveItem);
    }

    public DriveItem getItem(String itemId) {
        return this.graphClient.me().drive().items(itemId).buildRequest().get();
    }

    public Drive getDrive() {
        return this.graphClient.me().drive().buildRequest().get();
    }

    public String getBusinessPreviewLink(String itemId) {
        return this.graphClient.me().drive().items((String)itemId).preview((String)"1", (Double)Double.valueOf((double)1.0)).buildRequest().post().getUrl;
    }

    private boolean isDeltaTokenExpired(String deltaToken) {
        return false;
    }

    private IDriveItemDeltaCollectionPage delta(String deltaToken) {
        IDriveItemDeltaCollectionPage collectionPage;
        if (this.isDeltaTokenExpired(deltaToken)) {
            deltaToken = null;
        }
        if (deltaToken == null || deltaToken.isEmpty() || deltaToken.toUpperCase().trim().equals("ALL")) {
            collectionPage = this.graphClient.me().drive().root().delta().buildRequest().get();
        } else {
            QueryOption deltaTokenQuery = new QueryOption("token", deltaToken);
            collectionPage = this.graphClient.me().drive().root().delta().buildRequest(Collections.singletonList(deltaTokenQuery)).get();
        }
        return collectionPage;
    }

    public SimpleChildIterator getSimpleChildIterator(Collection<HashSetCompatibleDriveItem> items) throws CloudDriveException {
        return new SimpleChildIterator(this, items);
    }

    public ChildIterator getChildIterator(String folderId) {
        return new ChildIterator(this, folderId);
    }

    private String extractDeltaToken(String deltaLink) {
        return deltaLink.substring(deltaLink.indexOf("=") + 1);
    }

    class Scopes {
        static final String FilesReadAll = "https://graph.microsoft.com/Files.Read.All";
        static final String FilesRead = "https://graph.microsoft.com/Files.Read";
        static final String FilesReadSelected = "https://graph.microsoft.com/Files.Read.Selected";
        static final String FilesReadWriteSelected = "https://graph.microsoft.com/Files.ReadWrite.Selected";
        static final String FilesReadWrite = "https://graph.microsoft.com/Files.ReadWrite";
        static final String FilesReadWriteAll = "https://graph.microsoft.com/Files.ReadWrite.All";
        static final String FilesReadWriteAppFolder = "https://graph.microsoft.com/Files.ReadWrite.AppFolder";
        static final String UserRead = "https://graph.microsoft.com/User.Read";
        static final String UserReadWrite = "https://graph.microsoft.com/User.ReadWrite";
        static final String OfflineAccess = "offline_access";
        static final String Profile = "profile";
        static final String UserReadWriteAll = "https://graph.microsoft.com/User.ReadWrite.All";
        static final String SitesReadWriteAll = "https://graph.microsoft.com/Sites.ReadWrite.All";

        Scopes(OneDriveAPI this$0) {
        }
    }

    @Deprecated
    private class OneDriveSubscription {
        private long expirationDateTime;
        private String notificationUrl;

        private OneDriveSubscription() {
        }

        public synchronized String getNotificationUrl() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("subscription left: " + (this.expirationDateTime - Calendar.getInstance().getTimeInMillis())));
            }
            if (Calendar.getInstance().getTimeInMillis() >= this.expirationDateTime) {
                Subscription subscription = OneDriveAPI.this.getSubscription();
                this.notificationUrl = subscription.notificationUrl;
                this.expirationDateTime = subscription.expirationDateTime.getTimeInMillis();
            }
            return this.notificationUrl;
        }
    }

    private class OneDriveToken {
        private static final int LIFETIME = 2000000;
        private String refreshToken;
        private String accessToken;
        private long lastModifiedTime;

        public OneDriveToken(String accessToken, String refreshToken) {
            this.updateToken(accessToken, refreshToken);
        }

        public synchronized String getAccessToken() throws RefreshAccessException, OneDriveException {
            long currentTime = System.currentTimeMillis();
            if (currentTime >= this.lastModifiedTime + 2000000L) {
                try {
                    String refreshToken;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("refreshToken = " + this.refreshToken));
                    }
                    OneDriveTokenResponse oneDriveTokenResponse = OneDriveAPI.this.renewAccessToken(this.refreshToken, OneDriveAPI.this.redirectUrl);
                    this.accessToken = oneDriveTokenResponse.getToken();
                    this.lastModifiedTime = System.currentTimeMillis();
                    this.refreshToken = refreshToken = oneDriveTokenResponse.getRefreshToken();
                }
                catch (IOException e) {
                    throw new RefreshAccessException("Error during token update", (Throwable)e);
                }
            }
            return this.accessToken;
        }

        public final synchronized void updateToken(String accessToken, String refreshToken) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OneDriveToken.updateToken() : accessToken = " + accessToken + " refreshToken = " + refreshToken));
            }
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.lastModifiedTime = System.currentTimeMillis();
        }
    }

    class ChangesIterator
    extends ChunkIterator<DriveItem> {
        private IDriveItemDeltaCollectionPage deltaCollectionPage;
        private String deltaToken;

        ChangesIterator(String deltaToken) {
            this.deltaToken = deltaToken;
            this.deltaCollectionPage = OneDriveAPI.this.delta(deltaToken);
            this.iter = this.nextChunk();
        }

        protected Iterator<DriveItem> nextChunk() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)">> ChangesIterator nextChunk");
            }
            ArrayList changes = new ArrayList();
            changes.addAll(this.deltaCollectionPage.getCurrentPage());
            IDriveItemDeltaCollectionRequestBuilder nextPage = (IDriveItemDeltaCollectionRequestBuilder)this.deltaCollectionPage.getNextPage();
            if (nextPage == null) {
                this.deltaToken = OneDriveAPI.this.extractDeltaToken(this.deltaCollectionPage.deltaLink());
                this.deltaCollectionPage = null;
            } else {
                this.deltaCollectionPage = nextPage.buildRequest().get();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("ChangesIterator nextChunk available {}", new Object[]{changes.size()});
            }
            this.available(changes.size());
            return changes.iterator();
        }

        protected boolean hasNextChunk() {
            return this.deltaCollectionPage != null;
        }

        String getDeltaToken() {
            return this.deltaToken;
        }
    }

    class SimpleChildIterator
    extends ChunkIterator<HashSetCompatibleDriveItem> {
        private final Collection<HashSetCompatibleDriveItem> items;

        public SimpleChildIterator(OneDriveAPI this$0, Collection<HashSetCompatibleDriveItem> items) throws CloudDriveException {
            this.items = items;
            this.iter = this.nextChunk();
        }

        protected Iterator<HashSetCompatibleDriveItem> nextChunk() {
            this.available(this.items.size());
            return this.items.iterator();
        }

        protected boolean hasNextChunk() {
            return false;
        }
    }

    class ChildIterator
    extends ChunkIterator<DriveItem> {
        IDriveItemCollectionPage collectionPage;

        ChildIterator(OneDriveAPI this$0, String folderId) {
            this.collectionPage = this$0.getDriveItemCollectionPage(folderId);
            this.iter = this.nextChunk();
        }

        protected Iterator<DriveItem> nextChunk() {
            ArrayList driveItems = new ArrayList(this.collectionPage.getCurrentPage());
            this.available(driveItems.size());
            IDriveItemCollectionRequestBuilder nextPage = (IDriveItemCollectionRequestBuilder)this.collectionPage.getNextPage();
            this.collectionPage = nextPage != null ? nextPage.buildRequest().get() : null;
            return driveItems.iterator();
        }

        protected boolean hasNextChunk() {
            return this.collectionPage != null;
        }
    }
}

