/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.logger;

import java.util.logging.Logger;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.logger.ILogger;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.logger.LoggerLevel;

public class DefaultLogger
implements ILogger {
    private LoggerLevel level = LoggerLevel.ERROR;
    private static final Logger LOGGER = Logger.getLogger("global");

    @Override
    public void setLoggingLevel(LoggerLevel level) {
        LOGGER.info("Setting logging level to " + (Object)((Object)level));
        this.level = level;
    }

    @Override
    public LoggerLevel getLoggingLevel() {
        return this.level;
    }

    private String getTag() {
        try {
            StringBuilder sb = new StringBuilder();
            int callerStackDepth = 4;
            String className = Thread.currentThread().getStackTrace()[4].getClassName();
            sb.append(className.substring(className.lastIndexOf(46) + 1));
            sb.append("[");
            sb.append(Thread.currentThread().getStackTrace()[4].getMethodName());
            sb.append("] - ");
            sb.append(Thread.currentThread().getStackTrace()[4].getLineNumber());
            return sb.toString();
        }
        catch (Exception ex) {
            LOGGER.warning(ex.getMessage());
            return null;
        }
    }

    @Override
    public void logDebug(String message) {
        if (this.level == LoggerLevel.DEBUG) {
            for (String line : message.split("\n")) {
                LOGGER.info(line);
            }
        }
    }

    @Override
    public void logError(String message, Throwable throwable) {
        switch (this.level) {
            default: 
        }
        for (String line : message.split("\n")) {
            LOGGER.severe(this.getTag() + line);
        }
        LOGGER.severe("Throwable detail: " + throwable);
    }
}

