/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ColumnDefinition;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ColumnDefinitionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ColumnDefinitionCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ColumnDefinitionCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ColumnDefinitionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IColumnDefinitionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IColumnDefinitionCollectionRequest;

public class ColumnDefinitionCollectionRequest
extends BaseCollectionRequest<ColumnDefinitionCollectionResponse, IColumnDefinitionCollectionPage>
implements IColumnDefinitionCollectionRequest {
    public ColumnDefinitionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ColumnDefinitionCollectionResponse.class, IColumnDefinitionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IColumnDefinitionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ColumnDefinitionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IColumnDefinitionCollectionPage get() throws ClientException {
        ColumnDefinitionCollectionResponse response = (ColumnDefinitionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ColumnDefinition newColumnDefinition, ICallback<ColumnDefinition> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ColumnDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newColumnDefinition, callback);
    }

    @Override
    public ColumnDefinition post(ColumnDefinition newColumnDefinition) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ColumnDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newColumnDefinition);
    }

    @Override
    public IColumnDefinitionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IColumnDefinitionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IColumnDefinitionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IColumnDefinitionCollectionPage buildFromResponse(ColumnDefinitionCollectionResponse response) {
        ColumnDefinitionCollectionRequestBuilder builder = response.nextLink != null ? new ColumnDefinitionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ColumnDefinitionCollectionPage page = new ColumnDefinitionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

