/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.InferenceClassificationOverride;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IInferenceClassificationOverrideCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IInferenceClassificationOverrideCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.InferenceClassificationOverrideCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.InferenceClassificationOverrideCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.InferenceClassificationOverrideCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.InferenceClassificationOverrideRequestBuilder;

public class InferenceClassificationOverrideCollectionRequest
extends BaseCollectionRequest<InferenceClassificationOverrideCollectionResponse, IInferenceClassificationOverrideCollectionPage>
implements IInferenceClassificationOverrideCollectionRequest {
    public InferenceClassificationOverrideCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, InferenceClassificationOverrideCollectionResponse.class, IInferenceClassificationOverrideCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IInferenceClassificationOverrideCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(InferenceClassificationOverrideCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IInferenceClassificationOverrideCollectionPage get() throws ClientException {
        InferenceClassificationOverrideCollectionResponse response = (InferenceClassificationOverrideCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(InferenceClassificationOverride newInferenceClassificationOverride, ICallback<InferenceClassificationOverride> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new InferenceClassificationOverrideRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newInferenceClassificationOverride, callback);
    }

    @Override
    public InferenceClassificationOverride post(InferenceClassificationOverride newInferenceClassificationOverride) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new InferenceClassificationOverrideRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newInferenceClassificationOverride);
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IInferenceClassificationOverrideCollectionPage buildFromResponse(InferenceClassificationOverrideCollectionResponse response) {
        InferenceClassificationOverrideCollectionRequestBuilder builder = response.nextLink != null ? new InferenceClassificationOverrideCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        InferenceClassificationOverrideCollectionPage page = new InferenceClassificationOverrideCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

