/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ItemActivity;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IItemActivityCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IItemActivityCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ItemActivityCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ItemActivityCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ItemActivityCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ItemActivityRequestBuilder;

public class ItemActivityCollectionRequest
extends BaseCollectionRequest<ItemActivityCollectionResponse, IItemActivityCollectionPage>
implements IItemActivityCollectionRequest {
    public ItemActivityCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemActivityCollectionResponse.class, IItemActivityCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IItemActivityCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ItemActivityCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IItemActivityCollectionPage get() throws ClientException {
        ItemActivityCollectionResponse response = (ItemActivityCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ItemActivity newItemActivity, ICallback<ItemActivity> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ItemActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newItemActivity, callback);
    }

    @Override
    public ItemActivity post(ItemActivity newItemActivity) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ItemActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newItemActivity);
    }

    @Override
    public IItemActivityCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IItemActivityCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IItemActivityCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IItemActivityCollectionPage buildFromResponse(ItemActivityCollectionResponse response) {
        ItemActivityCollectionRequestBuilder builder = response.nextLink != null ? new ItemActivityCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ItemActivityCollectionPage page = new ItemActivityCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

