/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.WorkbookTable;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IWorkbookTableCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IWorkbookTableCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.WorkbookTableCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.WorkbookTableCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.WorkbookTableCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.WorkbookTableRequestBuilder;

public class WorkbookTableCollectionRequest
extends BaseCollectionRequest<WorkbookTableCollectionResponse, IWorkbookTableCollectionPage>
implements IWorkbookTableCollectionRequest {
    public WorkbookTableCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookTableCollectionResponse.class, IWorkbookTableCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookTableCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkbookTableCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookTableCollectionPage get() throws ClientException {
        WorkbookTableCollectionResponse response = (WorkbookTableCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookTable newWorkbookTable, ICallback<WorkbookTable> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookTableRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookTable, callback);
    }

    @Override
    public WorkbookTable post(WorkbookTable newWorkbookTable) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookTableRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookTable);
    }

    @Override
    public IWorkbookTableCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkbookTableCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkbookTableCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IWorkbookTableCollectionPage buildFromResponse(WorkbookTableCollectionResponse response) {
        WorkbookTableCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookTableCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookTableCollectionPage page = new WorkbookTableCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

