/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.GroupSetting;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.GroupSettingCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.GroupSettingCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.GroupSettingCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.GroupSettingRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IGroupSettingCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IGroupSettingCollectionRequest;

public class GroupSettingCollectionRequest
extends BaseCollectionRequest<GroupSettingCollectionResponse, IGroupSettingCollectionPage>
implements IGroupSettingCollectionRequest {
    public GroupSettingCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupSettingCollectionResponse.class, IGroupSettingCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IGroupSettingCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(GroupSettingCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupSettingCollectionPage get() throws ClientException {
        GroupSettingCollectionResponse response = (GroupSettingCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(GroupSetting newGroupSetting, ICallback<GroupSetting> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new GroupSettingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroupSetting, callback);
    }

    @Override
    public GroupSetting post(GroupSetting newGroupSetting) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupSettingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroupSetting);
    }

    @Override
    public IGroupSettingCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IGroupSettingCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IGroupSettingCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IGroupSettingCollectionPage buildFromResponse(GroupSettingCollectionResponse response) {
        GroupSettingCollectionRequestBuilder builder = response.nextLink != null ? new GroupSettingCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupSettingCollectionPage page = new GroupSettingCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

