/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveTokenResponse;

public class TestUtil {
    private static final String clientId;
    private static final String clientSecret;
    private static final HttpClient httpclient;
    private static final Gson gson;
    public static final String SCOPES;

    private static OneDriveTokenResponse retrieveAccessTokenByRefreshToken(String refreshToken) throws IOException {
        return TestUtil.retrieveAccessToken(clientId, clientSecret, null, refreshToken, "refresh_token");
    }

    public static String getRefreshToken() {
        String string;
        block8: {
            InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream("refresh.token");
            try {
                string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8").trim();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String retrieveAccessToken() {
        String string;
        block8: {
            InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream("refresh.token");
            try {
                String refreshToken = IOUtils.toString((InputStream)inputStream, (String)"UTF-8").trim();
                OneDriveTokenResponse oneDriveTokenResponse = TestUtil.retrieveAccessTokenByRefreshToken(refreshToken);
                string = oneDriveTokenResponse.getToken();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static String scopes() {
        StringJoiner scopes = new StringJoiner(" ");
        scopes.add("https://graph.microsoft.com/Files.ReadWrite.All").add("https://graph.microsoft.com/Files.Read").add("https://graph.microsoft.com/Files.ReadWrite").add("https://graph.microsoft.com/Files.Read.All").add("https://graph.microsoft.com/User.Read").add("offline_access");
        return scopes.toString();
    }

    private static OneDriveTokenResponse retrieveAccessToken(String clientId, String clientSecret, String code, String refreshToken, String grantType) throws IOException {
        HttpPost httppost = new HttpPost("https://login.microsoftonline.com/common/oauth2/v2.0/token");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(5);
        if (grantType.equals("refresh_token")) {
            params.add(new BasicNameValuePair("refresh_token", refreshToken));
        } else if (grantType.equals("authorization_code")) {
            params.add(new BasicNameValuePair("code", code));
        } else {
            return null;
        }
        params.add(new BasicNameValuePair("grant_type", grantType));
        params.add(new BasicNameValuePair("client_secret", clientSecret));
        params.add(new BasicNameValuePair("client_id", clientId));
        params.add(new BasicNameValuePair("scope", SCOPES));
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (InputStream inputStream = entity.getContent();){
                String responseBody = IOUtils.toString((InputStream)inputStream, (Charset)Charset.forName("UTF-8"));
                OneDriveTokenResponse oneDriveTokenResponse = (OneDriveTokenResponse)gson.fromJson(responseBody, OneDriveTokenResponse.class);
                return oneDriveTokenResponse;
            }
        }
        return null;
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(ClassLoader.getSystemClassLoader().getResourceAsStream("onedrive.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        clientId = properties.getProperty("clientId");
        clientSecret = properties.getProperty("clientSecret");
        httpclient = HttpClients.createDefault();
        gson = new Gson();
        SCOPES = TestUtil.scopes();
    }

    class Scopes {
        static final String FilesReadAll = "https://graph.microsoft.com/Files.Read.All";
        static final String FilesRead = "https://graph.microsoft.com/Files.Read";
        static final String FilesReadSelected = "https://graph.microsoft.com/Files.Read.Selected";
        static final String FilesReadWriteSelected = "https://graph.microsoft.com/Files.ReadWrite.Selected";
        static final String FilesReadWrite = "https://graph.microsoft.com/Files.ReadWrite";
        static final String FilesReadWriteAll = "https://graph.microsoft.com/Files.ReadWrite.All";
        static final String FilesReadWriteAppFolder = "https://graph.microsoft.com/Files.ReadWrite.AppFolder";
        static final String UserRead = "https://graph.microsoft.com/User.Read";
        static final String UserReadWrite = "https://graph.microsoft.com/User.ReadWrite";
        static final String offlineAccess = "offline_access";
        static final String UserReadWriteAll = "https://graph.microsoft.com/User.ReadWrite.All";

        Scopes(TestUtil this$0) {
        }
    }
}

