/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.CloudProviderException;
import org.exoplatform.services.cms.clouddrives.CloudUser;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.NotCloudDriveException;
import org.exoplatform.services.cms.clouddrives.NotCloudFileException;
import org.exoplatform.services.cms.clouddrives.NotYetCloudFileException;
import org.exoplatform.services.cms.clouddrives.RefreshAccessException;
import org.exoplatform.services.cms.clouddrives.SkipChangeException;
import org.exoplatform.services.cms.clouddrives.SkipSyncException;
import org.exoplatform.services.cms.clouddrives.SyncNotSupportedException;
import org.exoplatform.services.cms.clouddrives.jcr.JCRLocalCloudDrive;
import org.exoplatform.services.cms.clouddrives.jcr.JCRLocalCloudFile;
import org.exoplatform.services.cms.clouddrives.jcr.NodeFinder;
import org.exoplatform.services.cms.clouddrives.oauth2.UserToken;
import org.exoplatform.services.cms.clouddrives.oauth2.UserTokenRefreshListener;
import org.exoplatform.services.cms.clouddrives.onedrive.DeltaDriveFiles;
import org.exoplatform.services.cms.clouddrives.onedrive.HashSetCompatibleDriveItem;
import org.exoplatform.services.cms.clouddrives.onedrive.JCRLocalOneDriveFile;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveAPI;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveConnector;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveException;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveProvider;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveUser;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.GraphError;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.GraphServiceException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DriveItem;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.FileSystemInfo;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ItemReference;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.SharingLink;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.Subscription;
import org.exoplatform.services.cms.clouddrives.utils.ExtendedMimeTypeResolver;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JCRLocalOneDrive
extends JCRLocalCloudDrive
implements UserTokenRefreshListener {
    private static final Log LOG = ExoLogger.getLogger(JCRLocalOneDrive.class);
    private String accountType;
    private static final String PERSONAL = "personal";
    private static final String BUSINESS = "business";

    protected JCRLocalOneDrive(CloudUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws CloudDriveException, RepositoryException {
        super(user, driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getStoredToken().addListener(this);
    }

    protected JCRLocalOneDrive(OneDriveConnector.API apiBuilder, OneDriveProvider provider, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws RepositoryException, CloudDriveException, IOException {
        super((CloudUser)JCRLocalOneDrive.loadUser(apiBuilder, provider, driveNode), driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getStoredToken().addListener(this);
    }

    protected static OneDriveUser loadUser(OneDriveConnector.API apiBuilder, OneDriveProvider provider, Node driveNode) throws RepositoryException, CloudDriveException, IOException {
        String refreshToken;
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> loadUser from {}", new Object[]{driveNode.getPath()});
        }
        String username = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessToken = driveNode.getProperty("onedrive:oauth2AccessToken").getString();
        try {
            refreshToken = driveNode.getProperty("onedrive:oauth2RefreshToken").getString();
        }
        catch (PathNotFoundException e) {
            LOG.warn("Refresh token not found for {}[{}]", new Object[]{userId, email});
            refreshToken = null;
        }
        long expirationTime = driveNode.getProperty("onedrive:oauth2TokenExpirationTime").getLong();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<< loadUser from {}, refreshToken={}", new Object[]{driveNode.getPath(), refreshToken});
        }
        OneDriveAPI driveAPI = apiBuilder.load(refreshToken, accessToken, expirationTime).build();
        return new OneDriveUser(userId, username, email, provider, driveAPI);
    }

    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new OneDriveConnectCommand();
    }

    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() {
        return new OneDriveSyncCommand();
    }

    public OneDriveState getState() throws DriveRemovedException, RefreshAccessException, CloudProviderException, RepositoryException {
        return new OneDriveState(this.getUser().api().getSubscription(), this.getUser().api().getRootId());
    }

    protected OneDriveFileAPI createFileAPI() {
        return new OneDriveFileAPI();
    }

    protected Long readChangeId() {
        return System.currentTimeMillis();
    }

    protected void saveChangeId(Long id) {
    }

    public OneDriveUser getUser() {
        return (OneDriveUser)this.user;
    }

    protected void refreshAccess() throws CloudDriveException {
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        driveNode.setProperty("ecd:id", this.getUser().api().getRootId());
    }

    protected void updateAccess(CloudUser newUser) throws CloudDriveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> updateAccess for {}[{}]", new Object[]{newUser.getId(), newUser.getUsername()});
        }
        this.getUser().api().updateToken(((OneDriveUser)newUser).api().getStoredToken());
    }

    public void onUserTokenRefresh(UserToken token) throws CloudDriveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> onUserTokenRefresh {}", new Object[]{token.getAccessToken()});
        }
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                driveNode.setProperty("onedrive:oauth2AccessToken", token.getAccessToken());
                driveNode.setProperty("onedrive:oauth2RefreshToken", token.getRefreshToken());
                driveNode.setProperty("onedrive:oauth2TokenExpirationTime", token.getExpirationTime().longValue());
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error updating access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    public void onUserTokenRemove() throws CloudDriveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)">> onUserTokenRemove");
        }
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                if (driveNode.hasProperty("onedrive:oauth2AccessToken")) {
                    driveNode.getProperty("onedrive:oauth2AccessToken").remove();
                }
                if (driveNode.hasProperty("onedrive:oauth2RefreshToken")) {
                    driveNode.getProperty("onedrive:oauth2RefreshToken").remove();
                }
                if (driveNode.hasProperty("onedrive:oauth2TokenExpirationTime")) {
                    driveNode.getProperty("onedrive:oauth2TokenExpirationTime").remove();
                }
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error removing access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    void initFolderByDriveItem(Node fileNode, DriveItem item) throws RepositoryException {
        String lastModifiedUserName = "";
        String createdUserName = "";
        if (item.lastModifiedBy != null && item.lastModifiedBy.user != null) {
            lastModifiedUserName = item.lastModifiedBy.user.displayName;
        }
        if (item.createdBy != null && item.createdBy.user != null) {
            createdUserName = item.createdBy.user.displayName;
        }
        this.initFolder(fileNode, item.id, item.name, "folder", item.webUrl, createdUserName, lastModifiedUserName, item.createdDateTime, item.lastModifiedDateTime);
    }

    private void initWebUrlForImage(SharingLink link) {
        String base64Url = Base64.getEncoder().encodeToString(link.webUrl.getBytes(StandardCharsets.UTF_8));
        String preparedBase64Url = "u!" + StringUtils.stripEnd((String)base64Url, (String)"=").replace("/", "_").replace("+", "-");
        link.webUrl = "https://api.onedrive.com/v1.0/shares/" + preparedBase64Url + "/root/content";
    }

    private SharingLink createViewLink(DriveItem item) throws OneDriveException {
        return this.getUser().api().createLink(item.id, "view");
    }

    private SharingLink createEmbedLink(DriveItem item) throws OneDriveException {
        SharingLink link = this.getUser().api().createLink(item.id, "embed");
        if (item.file != null && item.file.mimeType.startsWith("image")) {
            this.initWebUrlForImage(link);
        }
        return link;
    }

    synchronized SharingLink createLink(DriveItem item) throws OneDriveException {
        this.accountType = this.getUser().api().getDrive().driveType;
        if (BUSINESS.equals(this.accountType)) {
            return this.getUser().api().createLink(item.id, "view");
        }
        if (PERSONAL.equals(this.accountType)) {
            return this.createEmbedLink(item);
        }
        try {
            this.accountType = PERSONAL;
            return this.createEmbedLink(item);
        }
        catch (GraphServiceException ex) {
            GraphError graphError = ex.getServiceError();
            if (graphError != null && StringUtils.containsIgnoreCase((CharSequence)graphError.message, (CharSequence)"Link type must be either")) {
                this.accountType = BUSINESS;
                return this.createViewLink(item);
            }
            throw ex;
        }
    }

    private DriveItemInfo prepareAdditionalDriveItemFields(DriveItem item) throws OneDriveException {
        String link = "";
        String previewLink = "";
        String lastModifiedUserName = "";
        String createdUserName = "";
        if (item.lastModifiedBy != null && item.lastModifiedBy.user != null) {
            lastModifiedUserName = item.lastModifiedBy.user.displayName;
        }
        if (item.createdBy != null && item.createdBy.user != null) {
            createdUserName = item.createdBy.user.displayName;
        }
        SharingLink sharingLink = this.createLink(item);
        if (sharingLink.type.equalsIgnoreCase("embed")) {
            previewLink = item.webUrl;
        }
        link = sharingLink.webUrl;
        return new DriveItemInfo(this, link, previewLink, lastModifiedUserName, createdUserName);
    }

    JCRLocalCloudFile initCreateFile(Node fileNode, DriveItem item) throws OneDriveException, RepositoryException {
        String link = "";
        String previewLink = "";
        String lastModifiedUserName = "";
        String createdUserName = "";
        if (item.lastModifiedBy != null && item.lastModifiedBy.user != null) {
            lastModifiedUserName = item.lastModifiedBy.user.displayName;
        }
        if (item.createdBy != null && item.createdBy.user != null) {
            createdUserName = item.createdBy.user.displayName;
        }
        SharingLink sharingLink = this.createLink(item);
        if (sharingLink.type.equalsIgnoreCase("embed")) {
            previewLink = sharingLink.webUrl;
        }
        link = sharingLink.webUrl;
        this.initFile(fileNode, item.id, item.name, item.file.mimeType, link, previewLink, null, createdUserName, lastModifiedUserName, item.createdDateTime, item.lastModifiedDateTime, item.size);
        return new JCRLocalOneDriveFile(fileNode.getPath(), item.id, item.name, link, previewLink, null, item.file.mimeType, null, lastModifiedUserName, createdUserName, item.createdDateTime, item.lastModifiedDateTime, item.size, fileNode, true, this.getUser().api(), this.accountType);
    }

    private JCRLocalCloudFile createCloudFolder(Node fileNode, DriveItem item) throws RepositoryException {
        String lastModifiedUserName = "";
        String createdUserName = "";
        if (item.lastModifiedBy != null && item.lastModifiedBy.user != null) {
            lastModifiedUserName = item.lastModifiedBy.user.displayName;
        }
        if (item.createdBy != null && item.createdBy.user != null) {
            createdUserName = item.createdBy.user.displayName;
        }
        return new JCRLocalCloudFile(fileNode.getPath(), item.id, item.name, item.webUrl, "folder", lastModifiedUserName, createdUserName, item.createdDateTime, item.lastModifiedDateTime, fileNode, true);
    }

    public CloudFile getFile(String path) throws DriveRemovedException, NotCloudDriveException, NotCloudFileException, NotYetCloudFileException, RepositoryException {
        CloudFile cloudFile = super.getFile(path);
        Node driveNode = this.rootNode(true);
        Item target = this.finder.findItem(driveNode.getSession(), path);
        Node fileNode = null;
        if (target.isNode()) {
            fileNode = this.fileNode((Node)target);
        }
        return new JCRLocalOneDriveFile(cloudFile.getPath(), cloudFile.getId(), cloudFile.getTitle(), cloudFile.getLink(), cloudFile.getEditLink(), cloudFile.getPreviewLink(), cloudFile.getThumbnailLink(), cloudFile.getType(), cloudFile.getTypeMode(), cloudFile.getLastUser(), cloudFile.getAuthor(), cloudFile.getCreatedDate(), cloudFile.getModifiedDate(), cloudFile.isFolder(), cloudFile.getSize(), fileNode, false, this.getUser().api(), this.accountType);
    }

    class OneDriveConnectCommand
    extends JCRLocalCloudDrive.ConnectCommand {
        private final OneDriveAPI api;

        OneDriveConnectCommand() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalOneDrive.this);
            this.api = JCRLocalOneDrive.this.getUser().api();
        }

        private JCRLocalCloudFile openInitFolder(Map<String, Set<HashSetCompatibleDriveItem>> itemChildren, DriveItem item, Node localFile) throws RepositoryException, CloudDriveException {
            Node fileNode = JCRLocalOneDrive.this.openFolder(item.id, item.name, localFile);
            JCRLocalOneDrive.this.initFolderByDriveItem(fileNode, item);
            this.fetchFiles(itemChildren, item.id, fileNode);
            return JCRLocalOneDrive.this.createCloudFolder(fileNode, item);
        }

        private JCRLocalCloudFile openInitFile(DriveItem item, Node localFile) throws CloudDriveException, RepositoryException {
            Node fileNode = JCRLocalOneDrive.this.openFile(item.id, item.name, localFile);
            return JCRLocalOneDrive.this.initCreateFile(fileNode, item);
        }

        private void fetchFiles(Map<String, Set<HashSetCompatibleDriveItem>> itemChildren, String fileId, Node localFile) throws CloudDriveException, RepositoryException {
            Set<HashSetCompatibleDriveItem> children = itemChildren.get(fileId);
            if (children != null) {
                OneDriveAPI.SimpleChildIterator childIterator = this.api.getSimpleChildIterator(children);
                this.iterators.add(childIterator);
                while (childIterator.hasNext()) {
                    DriveItem item = ((HashSetCompatibleDriveItem)childIterator.next()).getItem();
                    if (item.deleted == null) {
                        if (this.isConnected(fileId, item.id)) continue;
                        JCRLocalCloudFile localCloudFile = item.folder != null ? this.openInitFolder(itemChildren, item, localFile) : this.openInitFile(item, localFile);
                        this.addConnected(fileId, (CloudFile)localCloudFile);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Skipping deleted folder: " + String.valueOf(item)));
                }
            }
        }

        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            String rootId = this.api.getRootId();
            DeltaDriveFiles allFiles = this.api.getAllFiles();
            List<DriveItem> items = allFiles.getItems();
            HashMap<String, Set<HashSetCompatibleDriveItem>> itemChildren = new HashMap<String, Set<HashSetCompatibleDriveItem>>();
            items.forEach(item -> {
                String parentId = item.parentReference.id;
                Set children = itemChildren.computeIfAbsent(parentId, k -> new HashSet());
                HashSetCompatibleDriveItem hashSetCompatibleDriveItem = new HashSetCompatibleDriveItem((DriveItem)item);
                children.remove(hashSetCompatibleDriveItem);
                children.add(hashSetCompatibleDriveItem);
            });
            this.fetchFiles(itemChildren, rootId, this.driveNode);
            this.driveNode.setProperty("onedrive:changeToken", allFiles.getDeltaToken());
        }
    }

    protected class OneDriveSyncCommand
    extends JCRLocalCloudDrive.SyncCommand {
        private final OneDriveAPI api;
        private OneDriveAPI.ChangesIterator changes;

        OneDriveSyncCommand() {
            super((JCRLocalCloudDrive)JCRLocalOneDrive.this);
            this.api = JCRLocalOneDrive.this.getUser().api();
        }

        void saveDeltaToken(String deltaToken) throws RepositoryException {
            this.driveNode.setProperty("onedrive:changeToken", deltaToken);
        }

        String getDeltaToken() throws RepositoryException {
            if (this.driveNode.hasProperty("onedrive:changeToken")) {
                return this.driveNode.getProperty("onedrive:changeToken").getString();
            }
            return null;
        }

        protected void preSaveChunk() {
        }

        private void addFileNode(DriveItem driveItem, Node parentNode) throws RepositoryException, CloudDriveException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Add File(): id:  " + driveItem.id + " name: " + driveItem.name + "parentId: " + driveItem.parentReference.id));
            }
            final Node fileNode = JCRLocalOneDrive.this.openFile(driveItem.id, driveItem.name, parentNode);
            JCRLocalCloudFile jcrLocalCloudFile = JCRLocalOneDrive.this.initCreateFile(fileNode, driveItem);
            this.nodes.put(driveItem.id, new ArrayList<Node>(){
                {
                    this.add(fileNode);
                }
            });
            this.addChanged((CloudFile)jcrLocalCloudFile);
        }

        private void fetchChilds(String fileId, Node localFile) throws CloudDriveException, RepositoryException {
            OneDriveAPI.ChildIterator childIterator = this.api.getChildIterator(fileId);
            while (childIterator.hasNext()) {
                DriveItem item = (DriveItem)childIterator.next();
                if (item.deleted == null) {
                    if (item.folder != null) {
                        Node folderNode = this.addFolderNode(item, localFile);
                        this.fetchChilds(item.id, folderNode);
                        continue;
                    }
                    if (item.file == null) continue;
                    this.addFileNode(item, localFile);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Skipping deleted folder: " + String.valueOf(item)));
            }
        }

        private void updateNode(DriveItem driveItem, Node fileNode) throws RepositoryException, CloudDriveException {
            List destParentNodes = (List)this.nodes.get(driveItem.parentReference.id);
            if (this.api.getRootId().equals(driveItem.id)) {
                return;
            }
            if (destParentNodes == null || destParentNodes.isEmpty()) {
                this.syncNext();
                destParentNodes = (List)this.nodes.get(driveItem.parentReference.id);
            }
            Node destParentNode = (Node)destParentNodes.get(0);
            if (!JCRLocalOneDrive.this.fileAPI.getParentId(fileNode).equals(driveItem.parentReference.id) || !JCRLocalOneDrive.this.fileAPI.getTitle(fileNode).equals(driveItem.name)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(">> Must be moved, name={}", new Object[]{driveItem.name});
                }
                try {
                    Node node = JCRLocalOneDrive.this.moveFile(driveItem.id, driveItem.name, fileNode, destParentNode);
                    if (node != null) {
                        JCRLocalCloudFile localCloudFile;
                        if (driveItem.folder != null) {
                            JCRLocalOneDrive.this.initFolderByDriveItem(node, driveItem);
                            localCloudFile = JCRLocalOneDrive.this.createCloudFolder(node, driveItem);
                        } else {
                            localCloudFile = JCRLocalOneDrive.this.initCreateFile(node, driveItem);
                        }
                        this.addChanged((CloudFile)localCloudFile);
                    }
                }
                catch (RepositoryException | OneDriveException ex) {
                    LOG.warn((Object)"An error occurred when a node was updating (move or rename), while synchronizing remote changes to local.");
                    this.deleteItem(driveItem.id);
                    DriveItem item = this.api.getItem(driveItem.id);
                    if (item.file != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"try move file");
                        }
                        this.addFileNode(driveItem, destParentNode);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"try move folder");
                    }
                    Node folderNode = this.addFolderNode(driveItem, destParentNode);
                    this.fetchChilds(item.id, folderNode);
                }
            }
        }

        public void syncNext() throws CloudDriveException, RepositoryException {
            while (this.changes.hasNext()) {
                Node fileNode;
                Node parentNode;
                List nodes;
                DriveItem driveItem = (DriveItem)this.changes.next();
                if (driveItem.file != null) {
                    if (driveItem.deleted == null) {
                        nodes = null;
                        if (this.nodes.containsKey(driveItem.id)) {
                            nodes = (List)this.nodes.get(driveItem.id);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(">> Nodes size: {} for item with id {}", new Object[]{nodes.size(), driveItem.id});
                            }
                        }
                        if (nodes == null || nodes.size() == 0) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(">> Add file id: {}, name: {}, parentId: {}", new Object[]{driveItem.id, driveItem.name, driveItem.parentReference.id});
                            }
                            parentNode = (Node)((List)this.nodes.get(driveItem.parentReference.id)).get(0);
                            this.addFileNode(driveItem, parentNode);
                            continue;
                        }
                        fileNode = (Node)nodes.get(0);
                        this.updateNode(driveItem, fileNode);
                        continue;
                    }
                    this.deleteItem(driveItem.id);
                    continue;
                }
                if (driveItem.deleted == null) {
                    nodes = null;
                    if (this.nodes.containsKey(driveItem.id)) {
                        nodes = (List)this.nodes.get(driveItem.id);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(">> Folder nodes size: {} for item with id {}", new Object[]{nodes.size(), driveItem.id});
                        }
                    }
                    if (nodes == null || nodes.size() == 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(">> Add folder id: {}, name: {}, parentId: {}", new Object[]{driveItem.id, driveItem.name, driveItem.parentReference.id});
                        }
                        parentNode = (Node)((List)this.nodes.get(driveItem.parentReference.id)).get(0);
                        this.addFolderNode(driveItem, parentNode);
                        continue;
                    }
                    fileNode = (Node)nodes.get(0);
                    this.updateNode(driveItem, fileNode);
                    continue;
                }
                this.deleteItem(driveItem.id);
            }
        }

        protected boolean notInRange(String path, Collection<String> range) {
            for (String p : range) {
                if (!path.startsWith(p)) continue;
                return false;
            }
            return true;
        }

        private void sync(int numOfAttemptsInCaseOfFailure) throws RepositoryException, CloudDriveException {
            String deltaToken = this.getDeltaToken();
            if (LOG.isDebugEnabled()) {
                LOG.debug(">> Sync files with deltatoken {}", new Object[]{deltaToken});
            }
            this.changes = this.api.changes(deltaToken);
            this.iterators.add(this.changes);
            if (this.changes.hasNext()) {
                try {
                    this.readLocalNodes();
                    this.syncNext();
                    this.saveDeltaToken(this.changes.getDeltaToken());
                }
                catch (RepositoryException | ClientException ex) {
                    LOG.warn((Object)"Error occurred while synchronizing with the onedrive");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(">> Try update all drive after exception {}", new Object[]{ex.getMessage()});
                    }
                    this.nodes.remove(this.api.getRootId());
                    Iterator niter = this.nodes.values().iterator();
                    while (niter.hasNext() && !Thread.currentThread().isInterrupted()) {
                        List nls = (List)niter.next();
                        niter.remove();
                        for (Node n : nls) {
                            String npath = n.getPath();
                            if (!this.notInRange(npath, this.getRemoved())) continue;
                            JCRLocalOneDrive.this.removeNode(n);
                            this.addRemoved(npath);
                        }
                    }
                    this.saveDeltaToken("ALL");
                    if (numOfAttemptsInCaseOfFailure > 0) {
                        this.sync(--numOfAttemptsInCaseOfFailure);
                    }
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)">> Save delta token if no changes");
                }
                this.saveDeltaToken(this.changes.getDeltaToken());
            }
        }

        protected void syncFiles() throws CloudDriveException, RepositoryException {
            this.sync(3);
        }

        private Node addFolderNode(DriveItem driveItem, Node parentNode) throws CloudDriveException, RepositoryException {
            if (LOG.isDebugEnabled()) {
                LOG.debug(">> Add folder id: {}, name: {}, parentId: {}", new Object[]{driveItem.id, driveItem.name, driveItem.parentReference.id});
            }
            final Node folderNode = JCRLocalOneDrive.this.openFolder(driveItem.id, driveItem.name, parentNode);
            JCRLocalOneDrive.this.initFolderByDriveItem(folderNode, driveItem);
            this.nodes.put(driveItem.id, new ArrayList<Node>(){
                {
                    this.add(folderNode);
                }
            });
            JCRLocalCloudFile jcrLocalCloudFile = JCRLocalOneDrive.this.createCloudFolder(folderNode, driveItem);
            this.addChanged((CloudFile)jcrLocalCloudFile);
            return folderNode;
        }

        private void deleteItem(String itemId) throws CloudDriveException, RepositoryException {
            List existing = (List)this.nodes.remove(itemId);
            if (existing != null) {
                for (Node en : existing) {
                    this.removeLocalNode(en);
                }
            }
        }
    }

    public class OneDriveState
    implements CloudDrive.FilesState {
        final Subscription subscription;
        private final String rootId;

        public OneDriveState(Subscription subscription, String rootId) {
            this.subscription = subscription;
            this.rootId = rootId;
        }

        public Collection<String> getUpdating() {
            return JCRLocalOneDrive.this.state.getUpdating();
        }

        public boolean isUpdating(String fileIdOrPath) {
            return JCRLocalOneDrive.this.state.isUpdating(fileIdOrPath);
        }

        public boolean isNew(String fileIdOrPath) {
            return JCRLocalOneDrive.this.state.isNew(fileIdOrPath);
        }

        public String getUrl() {
            return this.subscription.notificationUrl;
        }

        public long getExpirationDateTime() {
            return this.subscription.expirationDateTime.getTimeInMillis();
        }

        public Subscription getSubscription() {
            return null;
        }

        public String getCreatorId() {
            return this.rootId;
        }
    }

    class OneDriveFileAPI
    extends JCRLocalCloudDrive.AbstractFileAPI {
        private OneDriveAPI api;

        OneDriveFileAPI() {
            super((JCRLocalCloudDrive)JCRLocalOneDrive.this);
            this.api = JCRLocalOneDrive.this.getUser().api();
        }

        public boolean removeFile(String id) {
            try {
                this.api.removeFile(id);
            }
            catch (ClientException ex) {
                LOG.warn("Error removing remote file {}", new Object[]{id, ex});
                return false;
            }
            return true;
        }

        public boolean removeFolder(String id) {
            try {
                this.api.removeFolder(id);
            }
            catch (ClientException ex) {
                LOG.warn("Error removing remote folder {}", new Object[]{id, ex});
                return false;
            }
            return true;
        }

        public boolean isTrashSupported() {
            return false;
        }

        public boolean trashFile(String id) throws CloudDriveException {
            throw new SyncNotSupportedException("Trash not supported");
        }

        public boolean trashFolder(String id) throws CloudDriveException {
            throw new SyncNotSupportedException("Trash not supported");
        }

        public CloudFile untrashFile(Node fileNode) throws CloudDriveException {
            throw new SyncNotSupportedException("Trash not supported");
        }

        public CloudFile untrashFolder(Node fileNode) throws CloudDriveException {
            throw new SyncNotSupportedException("Trash not supported");
        }

        public CloudFile createFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content) throws RepositoryException, CloudDriveException {
            if (LOG.isDebugEnabled()) {
                LOG.debug(">> Create file name: {} path: {}", new Object[]{this.getTitle(fileNode), fileNode.getPath()});
            }
            DriveItem createdDriveItem = null;
            try {
                createdDriveItem = this.api.insert(this.getParentId(fileNode), this.getTitle(fileNode), created, modified, content, "rename");
            }
            catch (OneDriveException ex) {
                throw new OneDriveException("Error occured while upload file " + ex.getMessage(), (Throwable)((Object)ex));
            }
            try {
                return JCRLocalOneDrive.this.initCreateFile(fileNode, createdDriveItem);
            }
            catch (RepositoryException | OneDriveException e) {
                LOG.warn("Error creating file {}", new Object[]{fileNode, e});
                fileNode.remove();
                throw new SkipSyncException("Error occurred storing data locally while loading a file");
            }
        }

        public CloudFile createFolder(Node folderNode, Calendar created) throws RepositoryException {
            String parentId = this.getParentId(folderNode);
            DriveItem createdFolder = null;
            createdFolder = this.api.createFolder(parentId, this.getTitle(folderNode), created);
            JCRLocalOneDrive.this.initFolderByDriveItem(folderNode, createdFolder);
            return JCRLocalOneDrive.this.createCloudFolder(folderNode, createdFolder);
        }

        public CloudFile copyFile(Node srcFileNode, Node destFileNode) throws SkipSyncException, SkipChangeException {
            DriveItem file = null;
            try {
                file = this.api.copyFile(this.getParentId(destFileNode), this.getTitle(destFileNode), this.getId(srcFileNode));
            }
            catch (IOException | RepositoryException | CloudDriveException e) {
                throw new SkipChangeException(e.getMessage(), e);
            }
            try {
                return JCRLocalOneDrive.this.initCreateFile(destFileNode, file);
            }
            catch (RepositoryException | CloudDriveException e) {
                LOG.error("Error copying file {} to {}", new Object[]{srcFileNode, destFileNode, e});
                throw new SkipSyncException("Error during copy file. " + e.getMessage());
            }
        }

        private void fetchChilds(String fileId, Node localFile) throws CloudDriveException, RepositoryException {
            OneDriveAPI.ChildIterator childIterator = this.api.getChildIterator(fileId);
            while (childIterator.hasNext()) {
                DriveItem item = (DriveItem)childIterator.next();
                if (item.folder != null) {
                    this.openInitFolder(item, localFile);
                    continue;
                }
                if (item.file == null) continue;
                this.openInitFile(item, localFile);
            }
        }

        private JCRLocalCloudFile openInitFolder(DriveItem item, Node localFile) throws RepositoryException, CloudDriveException {
            Node fileNode = JCRLocalOneDrive.this.openFolder(item.id, item.name, localFile);
            JCRLocalOneDrive.this.initFolderByDriveItem(fileNode, item);
            this.fetchChilds(item.id, fileNode);
            return JCRLocalOneDrive.this.createCloudFolder(fileNode, item);
        }

        private JCRLocalCloudFile openInitFile(DriveItem item, Node localFile) throws CloudDriveException, RepositoryException {
            Node fileNode = JCRLocalOneDrive.this.openFile(item.id, item.name, localFile);
            return JCRLocalOneDrive.this.initCreateFile(fileNode, item);
        }

        public CloudFile copyFolder(Node srcFolderNode, Node destFolderNode) throws SkipSyncException {
            try {
                DriveItem folder = this.api.copyFolder(this.getParentId(destFolderNode), this.getTitle(destFolderNode), this.getId(srcFolderNode));
                if (LOG.isDebugEnabled()) {
                    LOG.debug(">> Copy to folder {}. Trying to delete local subtree...", new Object[]{folder.name});
                }
                NodeIterator nodeIterator = destFolderNode.getNodes();
                while (nodeIterator.hasNext()) {
                    Node n = nodeIterator.nextNode();
                    JCRLocalOneDrive.this.removeNode(n);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(">> Local subtree deleted for {}", new Object[]{folder.name});
                }
                JCRLocalOneDrive.this.initFolderByDriveItem(destFolderNode, folder);
                this.fetchChilds(folder.id, destFolderNode);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(">> Local subtree fetched for {}", new Object[]{folder.name});
                }
                return JCRLocalOneDrive.this.createCloudFolder(destFolderNode, folder);
            }
            catch (IOException | RepositoryException | CloudDriveException e) {
                LOG.error("Error copying folder {} to {}", new Object[]{srcFolderNode, destFolderNode, e});
                throw new SkipSyncException("unable to copy folder");
            }
        }

        public CloudFile updateFile(Node fileNode, Calendar modified) throws RepositoryException, SkipSyncException {
            try {
                DriveItem modifiedItem = this.updateItem(fileNode, modified);
                return JCRLocalOneDrive.this.initCreateFile(fileNode, modifiedItem);
            }
            catch (Throwable e) {
                LOG.error("Error updating file {}", new Object[]{fileNode, e});
                throw new SkipSyncException("error during updateFile");
            }
        }

        public CloudFile updateFolder(Node folderNode, Calendar modified) throws RepositoryException, SkipSyncException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"updateFolder(): ");
            }
            try {
                DriveItem modifiedItem = this.updateItem(folderNode, modified);
                JCRLocalOneDrive.this.initFolderByDriveItem(folderNode, modifiedItem);
                return JCRLocalOneDrive.this.createCloudFolder(folderNode, modifiedItem);
            }
            catch (Throwable e) {
                LOG.error((Object)"failed to update folder", e);
                throw new SkipSyncException("failed to update folder");
            }
        }

        public CloudFile updateFileContent(Node fileNode, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            try {
                DriveItem updatedDriveItem = this.api.updateFileContent(this.getId(fileNode), null, modified, content);
                return JCRLocalOneDrive.this.initCreateFile(fileNode, updatedDriveItem);
            }
            catch (Throwable e) {
                LOG.error("Failed to update file content {}", new Object[]{fileNode, e});
                throw new SkipSyncException("failed to update file content");
            }
        }

        public CloudFile restore(String id, String path) throws SyncNotSupportedException {
            throw new SyncNotSupportedException("Restore not supported");
        }

        private DriveItem updateItem(Node itemNode, Calendar modified) throws RepositoryException, URISyntaxException {
            DriveItem driveItemModifiedFields = this.prepareModifiedDriveItem(itemNode, modified);
            return this.api.updateFile(driveItemModifiedFields);
        }

        private DriveItem prepareModifiedDriveItem(Node fileNode, Calendar modified) throws RepositoryException {
            DriveItem driveItem = new DriveItem();
            driveItem.id = this.getId(fileNode);
            driveItem.name = this.getTitle(fileNode);
            driveItem.parentReference = new ItemReference();
            String parentId = this.getParentId(fileNode);
            if (parentId == null || parentId.isEmpty()) {
                parentId = this.api.getRootId();
            }
            driveItem.parentReference.id = parentId;
            driveItem.fileSystemInfo = new FileSystemInfo();
            driveItem.fileSystemInfo.lastModifiedDateTime = modified;
            return driveItem;
        }
    }

    class DriveItemInfo {
        private String link;
        private String previewLink;
        private String lastModifiedUserName;
        private String createdUserName;

        public DriveItemInfo(JCRLocalOneDrive this$0, String link, String previewLink, String lastModifiedUserName, String createdUserName) {
            this.link = link;
            this.previewLink = previewLink;
            this.lastModifiedUserName = lastModifiedUserName;
            this.createdUserName = createdUserName;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getPreviewLink() {
            return this.previewLink;
        }

        public void setPreviewLink(String previewLink) {
            this.previewLink = previewLink;
        }

        public String getLastModifiedUserName() {
            return this.lastModifiedUserName;
        }

        public void setLastModifiedUserName(String lastModifiedUserName) {
            this.lastModifiedUserName = lastModifiedUserName;
        }

        public String getCreatedUserName() {
            return this.createdUserName;
        }

        public void setCreatedUserName(String createdUserName) {
            this.createdUserName = createdUserName;
        }
    }
}

