/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core;

import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.authentication.IAuthenticationProvider;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.DefaultExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IClientConfig;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.CoreHttpProvider;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.IHttpProvider;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.logger.DefaultLogger;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.logger.ILogger;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.serializer.DefaultSerializer;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.serializer.ISerializer;

public abstract class DefaultClientConfig
implements IClientConfig {
    private IExecutors executors;
    private IHttpProvider httpProvider;
    private ILogger logger;
    private DefaultSerializer serializer;

    public static IClientConfig createWithAuthenticationProvider(final IAuthenticationProvider authenticationProvider) {
        DefaultClientConfig config = new DefaultClientConfig(){

            @Override
            public IAuthenticationProvider getAuthenticationProvider() {
                return authenticationProvider;
            }
        };
        config.getLogger().logDebug("Using provided auth provider " + authenticationProvider.getClass().getSimpleName());
        return config;
    }

    @Override
    public abstract IAuthenticationProvider getAuthenticationProvider();

    @Override
    public IHttpProvider getHttpProvider() {
        if (this.httpProvider == null) {
            this.httpProvider = new CoreHttpProvider(this.getSerializer(), this.getAuthenticationProvider(), this.getExecutors(), this.getLogger());
            this.getLogger().logDebug("Created CoreHttpProvider");
        }
        return this.httpProvider;
    }

    @Override
    public ISerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new DefaultSerializer(this.getLogger());
            this.getLogger().logDebug("Created DefaultSerializer");
        }
        return this.serializer;
    }

    @Override
    public IExecutors getExecutors() {
        if (this.executors == null) {
            this.executors = new DefaultExecutors(this.getLogger());
            this.getLogger().logDebug("Created DefaultExecutors");
        }
        return this.executors;
    }

    @Override
    public ILogger getLogger() {
        if (this.logger == null) {
            this.logger = new DefaultLogger();
            this.logger.logDebug("Created DefaultLogger");
        }
        return this.logger;
    }
}

