/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IProgressCallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.SynchronousExecutor;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.logger.ILogger;

public class DefaultExecutors
implements IExecutors {
    private final ThreadPoolExecutor backgroundExecutor;
    private final SynchronousExecutor foregroundExecutor;
    private final ILogger logger;

    public DefaultExecutors(ILogger logger) {
        this.logger = logger;
        this.backgroundExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.foregroundExecutor = new SynchronousExecutor();
    }

    @Override
    public void performOnBackground(Runnable runnable2) {
        this.logger.logDebug("Starting background task, current active count: " + this.backgroundExecutor.getActiveCount());
        this.backgroundExecutor.execute(runnable2);
    }

    @Override
    public <Result> void performOnForeground(final Result result, final ICallback<Result> callback) {
        this.logger.logDebug("Starting foreground task, current active count:" + this.foregroundExecutor.getActiveCount() + ", with result " + result);
        this.foregroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.success(result);
            }
        });
    }

    @Override
    public <Result> void performOnForeground(final int progress, final int progressMax, final IProgressCallback<Result> callback) {
        this.logger.logDebug("Starting foreground task, current active count:" + this.foregroundExecutor.getActiveCount() + ", with progress  " + progress + ", max progress" + progressMax);
        this.foregroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.progress(progress, progressMax);
            }
        });
    }

    @Override
    public <Result> void performOnForeground(final ClientException exception, final ICallback<Result> callback) {
        this.logger.logDebug("Starting foreground task, current active count:" + this.foregroundExecutor.getActiveCount() + ", with exception " + exception);
        this.foregroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.failure(exception);
            }
        });
    }

    @VisibleForTesting
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public void shutdownBackgroundExecutors() {
        this.backgroundExecutor.shutdown();
    }
}

