/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.google.gson.JsonObject;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.HttpMethod;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;

public class CustomRequest<T>
extends BaseRequest {
    public CustomRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<T> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public static CustomRequest<JsonObject> create(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        return new CustomRequest<JsonObject>(requestUrl, client, (List<Option>)requestOptions, JsonObject.class);
    }

    public T get() throws ClientException {
        return (T)this.send(HttpMethod.GET, null);
    }

    public void get(ICallback<T> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    public void delete(ICallback<Void> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    public void patch(ICallback<T> callback) {
        this.send(HttpMethod.PATCH, callback, super.getResponseType());
    }

    public T patch(T sourceObject) throws ClientException {
        return (T)this.send(HttpMethod.PATCH, sourceObject);
    }

    public void post(T newObject, ICallback<T> callback) {
        this.send(HttpMethod.POST, callback, newObject);
    }

    public T post(T newObject) throws ClientException {
        return (T)this.send(HttpMethod.POST, newObject);
    }

    public void put(T putObject, ICallback<T> callback) {
        this.send(HttpMethod.PUT, callback, putObject);
    }

    public T put(T putObject) throws ClientException {
        return (T)this.send(HttpMethod.PUT, putObject);
    }

    public CustomRequest<T> select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    public CustomRequest<T> expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

