/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.OnenoteSection;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IOnenoteSectionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IOnenoteSectionCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.OnenoteSectionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.OnenoteSectionCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.OnenoteSectionCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.OnenoteSectionRequestBuilder;

public class OnenoteSectionCollectionRequest
extends BaseCollectionRequest<OnenoteSectionCollectionResponse, IOnenoteSectionCollectionPage>
implements IOnenoteSectionCollectionRequest {
    public OnenoteSectionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenoteSectionCollectionResponse.class, IOnenoteSectionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOnenoteSectionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OnenoteSectionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOnenoteSectionCollectionPage get() throws ClientException {
        OnenoteSectionCollectionResponse response = (OnenoteSectionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OnenoteSection newOnenoteSection, ICallback<OnenoteSection> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OnenoteSectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenoteSection, callback);
    }

    @Override
    public OnenoteSection post(OnenoteSection newOnenoteSection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OnenoteSectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenoteSection);
    }

    @Override
    public IOnenoteSectionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOnenoteSectionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOnenoteSectionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IOnenoteSectionCollectionPage buildFromResponse(OnenoteSectionCollectionResponse response) {
        OnenoteSectionCollectionRequestBuilder builder = response.nextLink != null ? new OnenoteSectionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OnenoteSectionCollectionPage page = new OnenoteSectionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

