/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.PlannerTask;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IPlannerTaskCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IPlannerTaskCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.PlannerTaskCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.PlannerTaskCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.PlannerTaskCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.PlannerTaskRequestBuilder;

public class PlannerTaskCollectionRequest
extends BaseCollectionRequest<PlannerTaskCollectionResponse, IPlannerTaskCollectionPage>
implements IPlannerTaskCollectionRequest {
    public PlannerTaskCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PlannerTaskCollectionResponse.class, IPlannerTaskCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPlannerTaskCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PlannerTaskCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPlannerTaskCollectionPage get() throws ClientException {
        PlannerTaskCollectionResponse response = (PlannerTaskCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PlannerTask newPlannerTask, ICallback<PlannerTask> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PlannerTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPlannerTask, callback);
    }

    @Override
    public PlannerTask post(PlannerTask newPlannerTask) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PlannerTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPlannerTask);
    }

    @Override
    public IPlannerTaskCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPlannerTaskCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPlannerTaskCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IPlannerTaskCollectionPage buildFromResponse(PlannerTaskCollectionResponse response) {
        PlannerTaskCollectionRequestBuilder builder = response.nextLink != null ? new PlannerTaskCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PlannerTaskCollectionPage page = new PlannerTaskCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

