/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis.portlet;

import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.inject.Inject;
import juzu.Action;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.request.RequestContext;
import juzu.request.RequestParameter;
import org.exoplatform.clouddrive.cmis.CMISException;
import org.exoplatform.clouddrive.cmis.CMISUser;
import org.exoplatform.clouddrive.cmis.WrongCMISProviderException;
import org.exoplatform.clouddrive.cmis.login.AuthenticationException;
import org.exoplatform.clouddrive.cmis.login.CodeAuthentication;
import org.exoplatform.clouddrive.cmis.portlet.CMISLoginController_;
import org.exoplatform.clouddrive.cmis.portlet.templates.error;
import org.exoplatform.clouddrive.cmis.portlet.templates.errorMessage;
import org.exoplatform.clouddrive.cmis.portlet.templates.login;
import org.exoplatform.clouddrive.cmis.portlet.templates.repository;
import org.exoplatform.clouddrive.cmis.portlet.templates.userkey;
import org.exoplatform.clouddrive.cmis.portlet.templates.warnMessage;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.cms.clouddrives.CloudDriveAccessException;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudProvider;
import org.exoplatform.services.cms.clouddrives.ProviderNotAvailableException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.util.Base64;

public class CMISLoginController {
    private static final Log LOG = ExoLogger.getLogger(CMISLoginController.class);
    private static final String KEY_ALGORITHM = "RSA";
    @Inject
    @Path(value="login.gtmpl")
    login login;
    @Inject
    @Path(value="userkey.gtmpl")
    userkey userKey;
    @Inject
    @Path(value="repository.gtmpl")
    repository repository;
    @Inject
    @Path(value="error.gtmpl")
    error error;
    @Inject
    @Path(value="errorMessage.gtmpl")
    errorMessage errorMessage;
    @Inject
    @Path(value="warnMessage.gtmpl")
    warnMessage warnMessage;
    @Inject
    CodeAuthentication authService;
    @Inject
    CloudDriveService cloudDrives;
    private final ConcurrentHashMap<String, PrivateKey> keys = new ConcurrentHashMap();

    @View
    public Response index(String providerId, RequestContext context) {
        if (providerId == null || providerId.length() == 0) {
            providerId = this.readProviderId();
        }
        try {
            return this.login.with().set("res", (Object)context.getApplicationContext().resolveBundle(context.getUserContext().getLocale())).set("provider", (Object)this.cloudDrives.getProvider(providerId)).ok();
        }
        catch (ProviderNotAvailableException e) {
            LOG.error((Object)("Login error: provider not available " + providerId), (Throwable)e);
            return CMISLoginController_.error((String)("CMIS provider (" + providerId + ") not available"));
        }
    }

    @View
    public Response error(String message) {
        return this.error.with().message((Object)message).ok();
    }

    @Ajax
    @Resource
    public Response userKey(String userName) {
        return this.userKey.with().key((Object)this.createKey(userName)).ok();
    }

    Response errorMessage(String text) {
        return this.errorMessage.with().message((Object)text).ok();
    }

    Response warnMessage(String text) {
        return this.warnMessage.with().message((Object)text).ok();
    }

    @Ajax
    @Resource
    public Response loginUser(String serviceURL, String userName, String password, String providerId) {
        if (serviceURL != null && serviceURL.length() > 0) {
            if (userName != null && userName.length() > 0) {
                if (password != null && password.length() > 0) {
                    if (providerId == null || providerId.length() == 0) {
                        providerId = this.readProviderId();
                    }
                    String providerName = providerId;
                    try {
                        String passwordText = this.decodePassword(userName, password);
                        String code = this.authService.authenticate(serviceURL, userName, passwordText);
                        CloudProvider cmisProvider = this.cloudDrives.getProvider(providerId);
                        providerName = cmisProvider.getName();
                        CMISUser cmisUser = (CMISUser)this.cloudDrives.authenticate(cmisProvider, code);
                        try {
                            return this.repository.with().code((Object)code).repositories((Object)cmisUser.getRepositories()).ok();
                        }
                        catch (WrongCMISProviderException e) {
                            LOG.error((Object)("Login error: wrong CMIS service URL for " + providerName + ": " + e.getMessage()));
                            return this.errorMessage("Wrong service URL for " + providerName);
                        }
                        catch (CloudDriveAccessException e) {
                            LOG.error((Object)("Repository access error for " + userName + ": " + e.getMessage()));
                            return this.errorMessage("Access error for " + userName + ". Check your username, password and have access permissions and try again.");
                        }
                        catch (CMISException e) {
                            LOG.error((Object)"Login error: error reading repositories list", (Throwable)e);
                            return this.errorMessage("Error reading repositories list from " + providerName + ". " + e.getMessage());
                        }
                    }
                    catch (InvalidKeyException e) {
                        LOG.warn((Object)("Error initializing RSA cipher for key from user " + userName), (Throwable)e);
                        return this.errorMessage("Invalid password key of user " + userName);
                    }
                    catch (IllegalBlockSizeException e) {
                        LOG.warn((Object)("Error decoding RSA key from user " + userName), (Throwable)e);
                        return this.errorMessage("Error processing password of user " + userName);
                    }
                    catch (BadPaddingException e) {
                        LOG.warn((Object)("Error decoding RSA key from user " + userName), (Throwable)e);
                        return this.errorMessage("Error processing password of user " + userName);
                    }
                    catch (IllegalStateException e) {
                        LOG.error((Object)"Login error: authentication initialization error", (Throwable)e);
                        return this.errorMessage("Authentication initialization error for " + userName);
                    }
                    catch (ProviderNotAvailableException e) {
                        LOG.error((Object)"Login error: provider not available", (Throwable)e);
                        return this.errorMessage("CMIS provider not available");
                    }
                    catch (CloudDriveAccessException e) {
                        LOG.warn((Object)("Service access error: " + e.getMessage()));
                        return this.errorMessage("Access error for " + userName + ". Ensure you are using correct username, password and have access permissions.");
                    }
                    catch (CloudDriveException e) {
                        LOG.error((Object)"Login error: authentication error", (Throwable)e);
                        return this.errorMessage("Authentication error for " + userName + ". " + e.getMessage());
                    }
                }
                LOG.warn((Object)("Wrong login: password required for " + userName));
                return this.errorMessage("Password required");
            }
            LOG.warn((Object)("Wrong login: user required for " + serviceURL));
            return this.errorMessage("User required");
        }
        LOG.warn((Object)"Wrong login: serviceURL required");
        return this.errorMessage("Service URL required");
    }

    @Action
    public Response loginRepository(String code, String repository2, RequestContext context) {
        Map parameters = context.getParameters();
        RequestParameter redirect = (RequestParameter)parameters.get("redirect_uri");
        if (redirect != null && redirect.size() > 0) {
            try {
                this.authService.setCodeContext(code, repository2);
            }
            catch (AuthenticationException e) {
                LOG.warn((Object)("Authentication error. " + e.getMessage()));
                return CMISLoginController_.error((String)("Authentication error. " + e.getMessage()));
            }
            Object redirectURL = redirect.get(0);
            redirectURL = ((String)redirectURL).indexOf(63) > 0 ? (String)redirectURL + "&code=" + code : (String)redirectURL + "?code=" + code;
            return Response.redirect((String)redirectURL);
        }
        LOG.warn((Object)"Wrong login URL: redirect_uri not found");
        return CMISLoginController_.error((String)"Wrong login URL.");
    }

    private String createKey(String user) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyGen.initialize(1024, SecureRandom.getInstance("SHA1PRNG"));
            KeyPair keyPair = keyGen.genKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            this.keys.put(user, privateKey);
            return Base64.encodeBytes((byte[])publicKey.getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)("Error creating RSA key pair for user " + user), (Throwable)e);
            throw new IllegalStateException("Error creating key for user " + user, e);
        }
    }

    private String decodePassword(String user, String password) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        PrivateKey userKey = (PrivateKey)this.keys.get(user);
        if (userKey != null) {
            try {
                Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
                cipher.init(2, userKey);
                return new String(cipher.doFinal(password.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)("Error creating RSA cipher for user " + user), (Throwable)e);
                throw new IllegalStateException("Error decoding password for user " + user, e);
            }
            catch (NoSuchPaddingException e) {
                LOG.error((Object)("Error creating RSA cipher for user " + user), (Throwable)e);
                throw new IllegalStateException("Error decoding password for user " + user, e);
            }
        }
        LOG.warn((Object)("User key not found for " + user + ". Use password as plain text."));
        return password;
    }

    private String readProviderId() {
        PortalRequestContext portalReq = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
        if (portalReq != null) {
            String reqProviderId = portalReq.getRequestParameter("providerId");
            return reqProviderId != null && reqProviderId.length() > 0 ? reqProviderId : "cmis";
        }
        return "cmis";
    }
}

