/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.dropbox;

import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxDelta;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxUrlWithExpiration;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudFileAPI;
import org.exoplatform.clouddrive.CloudProviderException;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.FileRestoreException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.dropbox.DropboxAPI;
import org.exoplatform.clouddrive.dropbox.DropboxConnector;
import org.exoplatform.clouddrive.dropbox.DropboxException;
import org.exoplatform.clouddrive.dropbox.DropboxProvider;
import org.exoplatform.clouddrive.dropbox.DropboxUser;
import org.exoplatform.clouddrive.dropbox.TooManyFilesException;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.oauth2.UserTokenRefreshListener;
import org.exoplatform.clouddrive.rest.ContentService;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.clouddrive.viewer.CloudFileContent;
import org.exoplatform.clouddrive.viewer.ContentReader;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalDropboxDrive
extends JCRLocalCloudDrive
implements UserTokenRefreshListener {
    public static final long DEFAULT_LINK_EXPIRATION_PERIOD = 10800000L;
    public static final String FOLDER_REV = "".intern();
    public static final String FOLDER_TYPE = "folder".intern();
    protected DropboxState state;
    protected Map<String, MovedFile> moved = new ConcurrentHashMap<String, MovedFile>();

    protected JCRLocalDropboxDrive(DropboxUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws CloudDriveException, RepositoryException {
        super((CloudUser)user, driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getToken().addListener(this);
    }

    protected JCRLocalDropboxDrive(DropboxConnector.API apiBuilder, DropboxProvider provider, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws RepositoryException, CloudDriveException {
        super((CloudUser)JCRLocalDropboxDrive.loadUser(apiBuilder, provider, driveNode), driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getToken().addListener(this);
        try {
            String cursor = driveNode.getProperty("dropbox:cursor").getString();
            this.updateState(cursor);
        }
        catch (PathNotFoundException e) {
            LOG.warn((Object)("Drive node exists but delta cursor not found for " + this.title() + ": " + e.getMessage()));
        }
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        driveNode.setProperty("ecd:id", "/");
        driveNode.setProperty("ecd:url", "https://www.dropbox.com/home");
    }

    protected void updateState(String cursor) {
        this.state = new DropboxState(cursor);
    }

    protected static DropboxUser loadUser(DropboxConnector.API apiBuilder, DropboxProvider provider, Node driveNode) throws RepositoryException, DropboxException, CloudDriveException {
        String username = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessToken = driveNode.getProperty("dropbox:oauth2AccessToken").getString();
        DropboxAPI driveAPI = apiBuilder.load(accessToken).build();
        return new DropboxUser(userId, username, email, provider, driveAPI);
    }

    public void onUserTokenRefresh(UserToken token) throws CloudDriveException {
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                driveNode.setProperty("dropbox:oauth2AccessToken", token.getAccessToken());
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error updating access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    public void onUserTokenRemove() throws CloudDriveException {
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                if (driveNode.hasProperty("dropbox:oauth2AccessToken")) {
                    driveNode.getProperty("dropbox:oauth2AccessToken").remove();
                }
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error removing access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    public ContentReader getFileContent(String idPath) throws RepositoryException, CloudDriveException {
        DropboxAPI api = this.getUser().api();
        DbxClient.Downloader downloader = api.getContent(idPath);
        if (downloader != null && downloader.metadata.isFile()) {
            DbxEntry.File file = downloader.metadata.asFile();
            String type = this.findMimetype(file.name);
            String typeMode = this.mimeTypes.getMimeTypeMode(type, file.name);
            return new CloudFileContent(file.name, downloader.body, type, typeMode, file.numBytes);
        }
        return null;
    }

    public CloudDrive.FilesState getState() throws DriveRemovedException, RefreshAccessException, CloudProviderException, RepositoryException {
        return this.state;
    }

    public boolean isSharingSupported() {
        return true;
    }

    public void shareFile(Node fileNode, String ... users) throws RepositoryException, CloudDriveException {
        this.createSharedLink(fileNode);
    }

    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new Connect();
    }

    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new EventsSync();
    }

    protected CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new FileAPI();
    }

    protected Long readChangeId() throws RepositoryException, CloudDriveException {
        try {
            return this.rootNode().getProperty("dropbox:changePosition").getLong();
        }
        catch (PathNotFoundException e) {
            throw new CloudDriveException("Change id not found for the drive " + this.title(), (Throwable)e);
        }
    }

    protected void saveChangeId(Long id) throws CloudDriveException, RepositoryException {
        Node driveNode = this.rootNode();
        driveNode.setProperty("dropbox:changePosition", id.longValue());
        driveNode.setProperty("dropbox:changeDate", Calendar.getInstance());
    }

    public DropboxUser getUser() {
        return (DropboxUser)this.user;
    }

    protected void refreshAccess() throws CloudDriveException {
    }

    protected void updateAccess(CloudUser newUser) throws CloudDriveException, RepositoryException {
        this.getUser().api().updateToken(((DropboxUser)newUser).api().getToken());
    }

    @Deprecated
    protected void initCloudItem(Node localNode, Object item) throws RepositoryException, DropboxException {
        localNode.setProperty("dropbox:etag", "item.getEtag()");
        try {
            String sequenceIdStr = "";
            if (sequenceIdStr != null) {
                localNode.setProperty("dropbox:sequenceId", Long.parseLong(sequenceIdStr));
            }
        }
        catch (NumberFormatException e) {
            throw new DropboxException("Error parsing sequence_id of " + localNode.getPath(), e);
        }
        localNode.setProperty("ecd:size", "");
        localNode.setProperty("dropbox:ownedBy", "");
        localNode.setProperty("dropbox:description", "");
    }

    protected void initDropboxFile(Node localNode, Boolean mightHaveThumbnail, String iconName, String rev, Long size) throws RepositoryException, DropboxException {
        localNode.setProperty("dropbox:rev", rev);
        localNode.setProperty("ecd:size", size.longValue());
        this.initDropboxCommon(localNode, mightHaveThumbnail, iconName);
    }

    protected void initDropboxFolder(Node localNode, Boolean mightHaveThumbnail, String iconName, String deltaHash) throws RepositoryException, DropboxException {
        if (deltaHash != null) {
            localNode.setProperty("dropbox:hash", deltaHash);
        }
        this.initDropboxCommon(localNode, mightHaveThumbnail, iconName);
    }

    protected void initDropboxCommon(Node localNode, Boolean mightHaveThumbnail, String iconName) throws RepositoryException, DropboxException {
        localNode.setProperty("dropbox:mightHaveThumbnail", mightHaveThumbnail.booleanValue());
        localNode.setProperty("dropbox:iconName", iconName);
    }

    protected JCRLocalCloudFile updateItem(DropboxAPI api, DbxFileInfo file, DbxEntry metadata, Node parent, Node node) throws RepositoryException, CloudDriveException {
        JCRLocalCloudFile localFile;
        String modifiedBy;
        String id = file.idPath;
        String title = metadata.name;
        boolean isFolder = metadata.isFolder();
        String createdBy = modifiedBy = this.currentUserName();
        if (isFolder) {
            String type;
            Calendar created;
            Calendar modified;
            boolean changed;
            DbxEntry.Folder dbxFolder = metadata.asFolder();
            if (node == null) {
                node = this.openFolder(id, file.name, parent);
            }
            if (!this.fileAPI.isFolder(node)) {
                node.remove();
                node = this.openFolder(id, file.name, parent);
            }
            if (node.isNew()) {
                changed = true;
                created = modified = Calendar.getInstance();
                type = FOLDER_TYPE;
                String link = api.getUserFolderLink(dbxFolder.path);
                this.initFolder(node, id, title, type, link, createdBy, modifiedBy, created, modified);
                this.initDropboxFolder(node, dbxFolder.mightHaveThumbnail, dbxFolder.iconName, null);
            } else {
                changed = false;
                modified = null;
                created = null;
                type = null;
                Object thumbnailLink = null;
                Object link = null;
            }
            localFile = new JCRLocalCloudFile(node.getPath(), id, title, this.link(node), type, modifiedBy, createdBy, created, modified, node, changed);
        } else {
            String thumbnailLink;
            String typeMode;
            String type;
            Calendar modified;
            Calendar created;
            boolean changed;
            DbxEntry.File dbxFile = metadata.asFile();
            if (node == null) {
                node = this.openFile(id, file.name, parent);
            }
            if (this.fileAPI.isFolder(node)) {
                node.remove();
                node = this.openFile(id, file.name, parent);
            }
            if (node.isNew() || !node.getProperty("dropbox:rev").getString().equals(dbxFile.rev)) {
                changed = true;
                created = Calendar.getInstance();
                created.setTime(dbxFile.clientMtime);
                modified = Calendar.getInstance();
                modified.setTime(dbxFile.lastModified);
                type = this.findMimetype(title);
                typeMode = this.mimeTypes.getMimeTypeMode(type, title);
                String link = api.getUserFileLink(file.parentPath, dbxFile.name);
                thumbnailLink = null;
                this.initFile(node, id, title, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified, dbxFile.numBytes);
                this.initDropboxFile(node, dbxFile.mightHaveThumbnail, dbxFile.iconName, dbxFile.rev, dbxFile.numBytes);
            } else {
                changed = false;
                modified = null;
                created = null;
                typeMode = null;
                type = null;
                thumbnailLink = null;
                String link = null;
            }
            localFile = new JCRLocalCloudFile(node.getPath(), id, title, this.link(node), null, this.previewLink(null, node), thumbnailLink, type, typeMode, createdBy, modifiedBy, created, modified, dbxFile.numBytes, node, changed);
        }
        return localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createSharedLink(Node fileNode) throws RepositoryException, CloudDriveException {
        String idPath = this.fileAPI.getId(fileNode);
        DbxUrlWithExpiration dbxLink = this.getUser().api().getSharedLink(idPath);
        if (dbxLink.url != null) {
            this.jcrListener.disable();
            try {
                Property dlProp = fileNode.setProperty("dropbox:sharedLink", dbxLink.url);
                long sharedLinkExpires = dbxLink.expires != null ? dbxLink.expires.getTime() : System.currentTimeMillis() + 10800000L;
                Property dleProp = fileNode.setProperty("dropbox:sharedLinkExpires", sharedLinkExpires);
                if (dlProp.isNew()) {
                    if (!fileNode.isNew() && !fileNode.isModified()) {
                        fileNode.save();
                    }
                } else {
                    dlProp.save();
                    dleProp.save();
                }
                String string = dbxLink.url;
                return string;
            }
            finally {
                this.jcrListener.enable();
            }
        }
        throw new CloudDriveException("Cannot share Dropbox file: null shared link returned for " + idPath);
    }

    protected String link(Node fileNode) throws RepositoryException {
        boolean isNotOwner;
        String currentUser = this.currentUserName();
        try {
            String driveOwner = this.rootNode().getProperty("ecd:localUserName").getString();
            isNotOwner = !driveOwner.equals(currentUser);
        }
        catch (DriveRemovedException e) {
            LOG.warn((Object)("Cannot read drive owner: " + e.getMessage()));
            isNotOwner = false;
        }
        if (isNotOwner) {
            boolean acquireNew;
            block9: {
                acquireNew = false;
                try {
                    String sharedLink = fileNode.getProperty("dropbox:sharedLink").getString();
                    long expires = fileNode.getProperty("dropbox:sharedLinkExpires").getLong();
                    if (expires > System.currentTimeMillis()) {
                        return sharedLink;
                    }
                    acquireNew = true;
                }
                catch (PathNotFoundException e) {
                    Node parent = fileNode.getParent();
                    if (!this.fileAPI.isFolder(parent) || !parent.hasProperty("dropbox:sharedLink")) break block9;
                    acquireNew = true;
                }
            }
            if (acquireNew) {
                try {
                    Node node = isNotOwner ? (Node)this.systemSession().getItem(fileNode.getPath()) : fileNode;
                    return this.createSharedLink(node);
                }
                catch (CloudDriveException e) {
                    LOG.error((Object)("Error creating shared link of Dropbox file " + this.fileAPI.getId(fileNode)), (Throwable)e);
                }
            }
        }
        return super.link(fileNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String previewLink(String type, Node fileNode) throws RepositoryException {
        String directLink;
        String idPath = this.fileAPI.getId(fileNode);
        try {
            directLink = fileNode.getProperty("dropbox:directLink").getString();
            long expires = fileNode.getProperty("dropbox:directLinkExpires").getLong();
            if (expires > System.currentTimeMillis()) {
                return directLink;
            }
        }
        catch (PathNotFoundException expires) {
            // empty catch block
        }
        try {
            DbxUrlWithExpiration dbxLink = this.getUser().api().getDirectLink(idPath);
            this.jcrListener.disable();
            String currentUser = this.currentUserName();
            String driveOwner = this.rootNode().getProperty("ecd:localUserName").getString();
            Node node = !driveOwner.equals(currentUser) && !fileNode.isNew() ? (Node)this.systemSession().getItem(fileNode.getPath()) : fileNode;
            directLink = dbxLink.url;
            Property dlProp = node.setProperty("dropbox:directLink", directLink);
            Property dleProp = node.setProperty("dropbox:directLinkExpires", dbxLink.expires.getTime());
            if (dlProp.isNew()) {
                if (!node.isNew() && !node.isModified()) {
                    node.save();
                }
            } else {
                dlProp.save();
                dleProp.save();
            }
            String string = directLink;
            return string;
        }
        catch (DriveRemovedException e) {
            LOG.warn((Object)("Error getting direct link of Dropbox file " + idPath + ": " + e.getMessage()), (Throwable)e);
        }
        catch (DropboxException e) {
            LOG.error((Object)("Error getting direct link of Dropbox file " + idPath), (Throwable)((Object)e));
        }
        catch (RefreshAccessException e) {
            LOG.warn((Object)("Cannot getting direct link of Dropbox file " + idPath + ": authorization required."), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
        return ContentService.contentLink((String)this.rootWorkspace, (String)fileNode.getPath(), (String)idPath);
    }

    protected boolean notInRange(String path, Collection<String> range) {
        for (String p : range) {
            if (!path.startsWith(p)) continue;
            return false;
        }
        return true;
    }

    protected String idPath(String dbxPath) {
        String loPath = dbxPath.toUpperCase().toLowerCase();
        return loPath;
    }

    protected String findMimetype(String fileName) {
        String defaultType = this.mimeTypes.getDefaultMimeType();
        String resolvedType = this.mimeTypes.getMimeType(fileName);
        String fileType = resolvedType != null && !resolvedType.startsWith(defaultType) ? resolvedType : defaultType;
        return fileType;
    }

    protected DbxEntry restoreSubtree(DropboxAPI api, String idPath, Node node) throws CloudDriveException, RepositoryException {
        return this.fetchSubtree(api, idPath, node, false, null, null);
    }

    protected DbxEntry fetchSubtree(DropboxAPI api, String idPath, Node node, boolean useHash, Collection<ChunkIterator<?>> iterators, Changes changes) throws CloudDriveException, RepositoryException {
        String hash = useHash ? this.folderHash(node) : null;
        DropboxAPI.FileMetadata items = api.getWithChildren(idPath, hash);
        if (items != null) {
            if (iterators != null) {
                iterators.add(items);
            }
            if (items.changed) {
                while (items.hasNext()) {
                    DbxEntry item = (DbxEntry)items.next();
                    DbxFileInfo file = new DbxFileInfo(item.path);
                    if (file.isRoot()) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Fetched root folder entry - ignore it: " + item.path));
                        continue;
                    }
                    if (changes != null && !changes.canApply(idPath, file.idPath)) continue;
                    JCRLocalCloudFile localItem = this.updateItem(api, file, item, node, null);
                    if (changes != null && localItem.isChanged()) {
                        changes.apply(localItem);
                    }
                    if (!localItem.isFolder()) continue;
                    this.fetchSubtree(api, localItem.getId(), localItem.getNode(), useHash, iterators, changes);
                }
                if (items.target.isFolder()) {
                    DbxEntry.Folder folder = items.target.asFolder();
                    this.initDropboxFolder(node, folder.mightHaveThumbnail, folder.iconName, items.hash);
                } else {
                    DbxEntry.File file = items.target.asFile();
                    this.initDropboxFile(node, file.mightHaveThumbnail, file.iconName, file.rev, file.numBytes);
                }
                return items.target;
            }
        }
        return null;
    }

    protected String folderHash(Node node) throws RepositoryException {
        String hash;
        if (this.fileAPI.isFolder(node)) {
            try {
                hash = node.getProperty("dropbox:hash").getString();
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Folder hash not found in the node: " + node.getPath()));
                }
                hash = null;
            }
        } else {
            hash = null;
        }
        return hash;
    }

    protected void cleanExpiredMoved() {
        Iterator<MovedFile> fiter = this.moved.values().iterator();
        while (fiter.hasNext()) {
            MovedFile file = fiter.next();
            if (!file.isOutdated()) continue;
            fiter.remove();
        }
    }

    protected String nodeName(String title) {
        return super.nodeName(this.idPath(title));
    }

    protected Node normalizeName(Node fileNode) throws RepositoryException {
        String jcrName = fileNode.getName();
        String lcName = this.idPath(this.fileAPI.getTitle(fileNode));
        if (!lcName.equals(jcrName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Normalizing node name: " + jcrName + " -> " + lcName));
            }
            fileNode.getSession().move(fileNode.getPath(), fileNode.getParent().getPath() + "/" + lcName);
        }
        return fileNode;
    }

    protected class DbxFileInfo {
        protected final String name;
        protected final String path;
        protected final String parentPath;
        protected final String idPath;
        protected DbxFileInfo parent;

        protected DbxFileInfo(String dbxPath) {
            String parentPath;
            String name;
            if (dbxPath == null) {
                throw new NullPointerException("Null path not allowed");
            }
            if (dbxPath.length() == 0) {
                throw new IllegalArgumentException("Empty path not allowed");
            }
            this.path = dbxPath;
            this.idPath = JCRLocalDropboxDrive.this.idPath(dbxPath);
            if ("/".equals(this.idPath)) {
                name = null;
                parentPath = null;
            } else {
                int endIndex;
                int parentEndIndex = this.path.lastIndexOf(47);
                if (parentEndIndex == this.path.length() - 1) {
                    endIndex = parentEndIndex;
                    parentEndIndex = this.path.lastIndexOf(47, endIndex - 1);
                } else {
                    endIndex = this.path.length();
                }
                if (parentEndIndex > 0) {
                    parentPath = this.path.substring(0, parentEndIndex);
                    int nameIndex = parentEndIndex + 1;
                    name = nameIndex < endIndex ? this.path.substring(nameIndex, endIndex) : null;
                } else if (parentEndIndex == 0) {
                    parentPath = "/";
                    name = this.path.substring(parentEndIndex + 1, endIndex);
                } else {
                    parentPath = "/";
                    name = this.path;
                }
            }
            this.name = name;
            this.parentPath = parentPath;
        }

        protected DbxFileInfo getParent() {
            if (this.isRoot()) {
                return null;
            }
            if (this.parent == null) {
                this.parent = new DbxFileInfo(this.parentPath);
            }
            return this.parent;
        }

        protected boolean isRoot() {
            return this.parentPath == null;
        }
    }

    public class DropboxState
    extends JCRLocalCloudDrive.DriveState {
        final String cursor;
        final String url;
        final int timeout;

        protected DropboxState(String cursor) {
            super((JCRLocalCloudDrive)JCRLocalDropboxDrive.this);
            this.cursor = cursor;
            this.timeout = 60;
            this.url = "https://api-notify.dropbox.com/1/longpoll_delta" + "?cursor=" + cursor + "&timeout=" + this.timeout;
        }

        public String getCursor() {
            return this.cursor;
        }

        public String getUrl() {
            return this.url;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }

    protected class EventsSync
    extends JCRLocalCloudDrive.SyncCommand
    implements Changes {
        protected final DropboxAPI api;
        protected final Map<String, Node> pathNodes;

        protected EventsSync() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalDropboxDrive.this);
            this.pathNodes = new HashMap<String, Node>();
            this.api = JCRLocalDropboxDrive.this.getUser().api();
        }

        protected void syncFiles() throws CloudDriveException, RepositoryException {
            long changeId = System.currentTimeMillis();
            JCRLocalDropboxDrive.this.cleanExpiredMoved();
            this.pathNodes.put("/", this.driveNode);
            String cursor = this.driveNode.getProperty("dropbox:cursor").getString();
            DropboxAPI.DeltaChanges deltas = this.api.getDeltas(cursor);
            this.iterators.add(deltas);
            while (deltas.hasNext() && !Thread.currentThread().isInterrupted()) {
                DbxFileInfo file;
                DbxDelta.Entry delta = (DbxDelta.Entry)deltas.next();
                DbxEntry item = (DbxEntry)delta.metadata;
                String deltaPath = delta.lcPath;
                if (item != null) {
                    Node parent;
                    file = new DbxFileInfo(item.path);
                    if (file.isRoot()) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Root folder entry found in delta changes - ignore it: " + deltaPath));
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> delta: " + item.name + (item.isFolder() ? " folder change " : " file change ") + deltaPath));
                    }
                    if ((parent = this.getParent(file)) == null) {
                        Node existingAncestor = this.getExistingAncestor(file.getParent());
                        if (existingAncestor != null) {
                            String idPath = JCRLocalDropboxDrive.this.fileAPI.getId(existingAncestor);
                            JCRLocalDropboxDrive.this.fetchSubtree(this.api, idPath, existingAncestor, false, this.iterators, this);
                            continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Cannot find existing ancestor in local drive storage. Delta path: " + deltaPath + ". File path: " + item.path));
                        }
                        throw new CloudDriveException("Cannot find existing parent folder locally for " + item.path);
                    }
                    this.apply(JCRLocalDropboxDrive.this.updateItem(this.api, file, item, parent, null));
                    continue;
                }
                file = new DbxFileInfo(deltaPath);
                if (file.isRoot()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Root folder entry found in delta changes for removal - ignore it: " + deltaPath));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">> delta: removed " + deltaPath));
                }
                this.removeFile(file);
            }
            if (!Thread.currentThread().isInterrupted()) {
                JCRLocalDropboxDrive.this.setChangeId(changeId);
                Property cursorProp = this.driveNode.setProperty("dropbox:cursor", deltas.cursor);
                cursorProp.save();
                JCRLocalDropboxDrive.this.updateState(deltas.cursor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<< syncFiles: " + this.driveNode.getPath() + "\n\r" + cursor + " --> " + deltas.cursor));
                }
            }
        }

        @Override
        public void apply(JCRLocalCloudFile local) throws RepositoryException, CloudDriveException {
            if (local.isChanged()) {
                this.removeRemoved(local.getPath());
                this.addChanged((CloudFile)local);
            }
        }

        @Override
        public boolean canApply(String parentId, String fileId) {
            return true;
        }

        protected Node getFile(DbxFileInfo file) throws RepositoryException, CloudDriveException {
            Node node = this.pathNodes.get(file.idPath);
            if (node == null) {
                node = this.readNode(file);
            }
            return node;
        }

        protected boolean removeFile(DbxFileInfo file) throws RepositoryException, CloudDriveException {
            Node node = this.pathNodes.remove(file.idPath);
            if (node == null) {
                node = this.readNode(file);
            }
            if (node != null) {
                this.removeLinks(node);
                String nodePath = node.getPath();
                node.remove();
                this.addRemoved(nodePath);
                return true;
            }
            return false;
        }

        protected Node getExistingAncestor(DbxFileInfo file) throws RepositoryException, CloudDriveException, IllegalArgumentException {
            if (file.isRoot()) {
                Node node;
                DbxFileInfo parent = file.getParent();
                if (parent.isRoot()) {
                    node = this.driveNode;
                } else {
                    node = this.getFile(parent);
                    if (node == null) {
                        node = this.getExistingAncestor(parent);
                    }
                }
                return node;
            }
            return this.driveNode;
        }

        protected Node readNode(DbxFileInfo file) throws RepositoryException, CloudDriveException {
            Node parent = this.getParent(file);
            if (parent != null) {
                Node node = JCRLocalDropboxDrive.this.readNode(parent, file.name, file.idPath);
                if (node != null) {
                    this.pathNodes.put(file.idPath, node);
                }
                return node;
            }
            return null;
        }

        protected Node getParent(DbxFileInfo file) throws RepositoryException, CloudDriveException {
            Node parent = file.isRoot() ? this.driveNode : this.getFile(file.getParent());
            return parent;
        }

        protected void preSaveChunk() throws CloudDriveException, RepositoryException {
        }
    }

    protected class FileAPI
    extends JCRLocalCloudDrive.AbstractFileAPI {
        protected final DropboxAPI api;

        FileAPI() {
            super((JCRLocalCloudDrive)JCRLocalDropboxDrive.this);
            this.api = JCRLocalDropboxDrive.this.getUser().api();
        }

        public CloudFile createFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            JCRLocalDropboxDrive.this.normalizeName(fileNode);
            return this.uploadFile(fileNode, created, modified, mimeType, content, false);
        }

        public CloudFile createFolder(Node folderNode, Calendar created) throws CloudDriveException, RepositoryException {
            String createdBy;
            DbxEntry.Folder folder;
            JCRLocalDropboxDrive.this.normalizeName(folderNode);
            String parentId = this.getParentId(folderNode);
            String title = this.getTitle(folderNode);
            try {
                folder = this.api.createFolder(parentId, title);
            }
            catch (ConflictException e) {
                String idPath = this.getId(folderNode);
                DbxEntry item = this.api.get(idPath);
                if (item.isFolder()) {
                    folder = item.asFolder();
                }
                throw e;
            }
            String id = JCRLocalDropboxDrive.this.idPath(folder.path);
            String name = folder.name;
            String link = this.api.getUserFolderLink(folder.path);
            String modifiedBy = createdBy = JCRLocalDropboxDrive.this.currentUserName();
            String type = FOLDER_TYPE;
            JCRLocalDropboxDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, created, created);
            JCRLocalDropboxDrive.this.initDropboxFolder(folderNode, folder.mightHaveThumbnail, folder.iconName, null);
            return new JCRLocalCloudFile(folderNode.getPath(), id, name, link, type, modifiedBy, createdBy, created, created, folderNode, true);
        }

        public CloudFile updateFile(Node fileNode, Calendar modified) throws CloudDriveException, RepositoryException {
            DbxEntry item = this.move(fileNode);
            if (item != null) {
                if (item.isFile()) {
                    String createdBy;
                    DbxEntry.File file = item.asFile();
                    DbxFileInfo info = new DbxFileInfo(file.path);
                    String id = info.idPath;
                    String name = file.name;
                    String link = this.api.getUserFileLink(info.parentPath, info.name);
                    String thumbnailLink = null;
                    String modifiedBy = createdBy = JCRLocalDropboxDrive.this.currentUserName();
                    String type = JCRLocalDropboxDrive.this.findMimetype(name);
                    long size = file.numBytes;
                    JCRLocalDropboxDrive.this.initFile(fileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, null, modified, size);
                    JCRLocalDropboxDrive.this.initDropboxFile(fileNode, file.mightHaveThumbnail, file.iconName, file.rev, size);
                    this.resetSharing(fileNode);
                    return new JCRLocalCloudFile(fileNode.getPath(), id, name, link, null, JCRLocalDropboxDrive.this.previewLink(null, fileNode), thumbnailLink, type, JCRLocalDropboxDrive.this.mimeTypes.getMimeTypeMode(type, name), createdBy, modifiedBy, JCRLocalDropboxDrive.this.fileAPI.getCreated(fileNode), modified, size, fileNode, true);
                }
                throw new CloudDriveException("Moved file appears as not a file in Dropbox " + item.path);
            }
            return JCRLocalDropboxDrive.this.readFile(fileNode);
        }

        public CloudFile updateFolder(Node folderNode, Calendar modified) throws CloudDriveException, RepositoryException {
            DbxEntry item = this.move(folderNode);
            if (item != null) {
                if (item.isFolder()) {
                    String createdBy;
                    DbxEntry.Folder folder = item.asFolder();
                    String id = JCRLocalDropboxDrive.this.idPath(folder.path);
                    String name = folder.name;
                    String link = this.api.getUserFolderLink(folder.path);
                    String modifiedBy = createdBy = JCRLocalDropboxDrive.this.currentUserName();
                    String type = FOLDER_TYPE;
                    JCRLocalDropboxDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, null, modified);
                    JCRLocalDropboxDrive.this.initDropboxFolder(folderNode, folder.mightHaveThumbnail, folder.iconName, null);
                    return new JCRLocalCloudFile(folderNode.getPath(), id, name, link, type, modifiedBy, createdBy, JCRLocalDropboxDrive.this.fileAPI.getCreated(folderNode), modified, folderNode, true);
                }
                throw new CloudDriveException("Moved folder appears as not a folder in Dropbox " + item.path);
            }
            return JCRLocalDropboxDrive.this.readFile(folderNode);
        }

        public CloudFile updateFileContent(Node fileNode, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            return this.uploadFile(fileNode, null, modified, mimeType, content, true);
        }

        public CloudFile copyFile(Node srcFileNode, Node destFileNode) throws CloudDriveException, RepositoryException {
            DbxEntry item = this.copy(srcFileNode, destFileNode);
            if (item != null) {
                if (item.isFile()) {
                    String createdBy;
                    DbxEntry.File file = item.asFile();
                    DbxFileInfo info = new DbxFileInfo(file.path);
                    String id = info.idPath;
                    String name = file.name;
                    String link = this.api.getUserFileLink(info.parentPath, info.name);
                    String thumbnailLink = null;
                    String modifiedBy = createdBy = JCRLocalDropboxDrive.this.currentUserName();
                    String type = JCRLocalDropboxDrive.this.findMimetype(name);
                    long size = file.numBytes;
                    Calendar created = Calendar.getInstance();
                    JCRLocalDropboxDrive.this.initFile(destFileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, created, size);
                    JCRLocalDropboxDrive.this.initDropboxFile(destFileNode, file.mightHaveThumbnail, file.iconName, file.rev, size);
                    this.resetSharing(destFileNode);
                    return new JCRLocalCloudFile(destFileNode.getPath(), id, name, link, null, JCRLocalDropboxDrive.this.previewLink(null, destFileNode), thumbnailLink, type, JCRLocalDropboxDrive.this.mimeTypes.getMimeTypeMode(type, name), createdBy, modifiedBy, created, created, size, destFileNode, true);
                }
                throw new CloudDriveException("Copied file appears as not a file in Dropbox " + item.path);
            }
            if (LOG.isDebugEnabled()) {
                StringBuilder idInfo = new StringBuilder();
                try {
                    String idPath = this.getId(srcFileNode);
                    idInfo.append('(').append(idPath);
                }
                catch (PathNotFoundException e) {
                    idInfo.append("???");
                }
                try {
                    idInfo.append(" -> ").append(this.getId(destFileNode)).append(") ");
                }
                catch (PathNotFoundException e) {
                    idInfo.append("???) ");
                }
                LOG.debug((Object)("File copy failed in Dropbox without a reason " + idInfo.toString() + destFileNode.getPath()));
            }
            throw new DropboxException("File copy failed in Dropbox without a reason " + destFileNode.getPath());
        }

        public CloudFile copyFolder(Node srcFolderNode, Node destFolderNode) throws CloudDriveException, RepositoryException {
            DbxEntry item = this.copy(srcFolderNode, destFolderNode);
            if (item != null) {
                if (item.isFolder()) {
                    String createdBy;
                    DbxEntry.Folder folder = item.asFolder();
                    String id = JCRLocalDropboxDrive.this.idPath(folder.path);
                    String name = folder.name;
                    String link = this.api.getUserFolderLink(folder.path);
                    String modifiedBy = createdBy = JCRLocalDropboxDrive.this.currentUserName();
                    String type = FOLDER_TYPE;
                    Calendar created = Calendar.getInstance();
                    JCRLocalDropboxDrive.this.initFolder(destFolderNode, id, name, type, link, createdBy, modifiedBy, created, created);
                    JCRLocalDropboxDrive.this.initDropboxFolder(destFolderNode, folder.mightHaveThumbnail, folder.iconName, null);
                    return new JCRLocalCloudFile(destFolderNode.getPath(), id, name, link, type, modifiedBy, createdBy, created, created, destFolderNode, true);
                }
                throw new CloudDriveException("Copied folder appears as not a folder in Dropbox " + item.path);
            }
            if (LOG.isDebugEnabled()) {
                StringBuilder idInfo = new StringBuilder();
                try {
                    String idPath = this.getId(srcFolderNode);
                    idInfo.append('(').append(idPath);
                }
                catch (PathNotFoundException e) {
                    idInfo.append("???");
                }
                try {
                    idInfo.append(" -> ").append(this.getId(destFolderNode)).append(") ");
                }
                catch (PathNotFoundException e) {
                    idInfo.append("???) ");
                }
                LOG.debug((Object)("Folder copy failed in Dropbox without a reason " + idInfo.toString() + destFolderNode.getPath()));
            }
            throw new DropboxException("Folder copy failed in Dropbox without a reason " + destFolderNode.getPath());
        }

        public boolean removeFile(String id) throws CloudDriveException, RepositoryException {
            this.api.delete(id);
            return true;
        }

        public boolean removeFolder(String id) throws CloudDriveException, RepositoryException {
            this.api.delete(id);
            return true;
        }

        public boolean trashFile(String id) throws CloudDriveException, RepositoryException {
            return this.removeFile(id);
        }

        public boolean trashFolder(String id) throws CloudDriveException, RepositoryException {
            return this.removeFolder(id);
        }

        public CloudFile untrashFile(Node fileNode) throws CloudDriveException, RepositoryException {
            String rev;
            String idPath = this.getId(fileNode);
            DbxEntry.File file = this.api.restoreFile(idPath, rev = this.getRev(fileNode));
            if (file != null) {
                String createdBy;
                DbxFileInfo info = new DbxFileInfo(file.path);
                String id = info.idPath;
                String name = file.name;
                String link = this.api.getUserFileLink(info.parentPath, info.name);
                String thumbnailLink = null;
                String modifiedBy = createdBy = JCRLocalDropboxDrive.this.currentUserName();
                String type = JCRLocalDropboxDrive.this.findMimetype(name);
                Calendar modified = Calendar.getInstance();
                long size = file.numBytes;
                JCRLocalDropboxDrive.this.initFile(fileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, null, modified, size);
                JCRLocalDropboxDrive.this.initDropboxFile(fileNode, file.mightHaveThumbnail, file.iconName, file.rev, size);
                return new JCRLocalCloudFile(fileNode.getPath(), id, name, link, null, JCRLocalDropboxDrive.this.previewLink(null, fileNode), thumbnailLink, type, JCRLocalDropboxDrive.this.mimeTypes.getMimeTypeMode(type, name), createdBy, modifiedBy, JCRLocalDropboxDrive.this.fileAPI.getCreated(fileNode), modified, size, fileNode, true);
            }
            throw new FileRestoreException("File revision (" + rev + ") cannot be restored '" + this.getTitle(fileNode) + "'");
        }

        public CloudFile untrashFolder(Node folderNode) throws CloudDriveException, RepositoryException {
            NodeIterator children = folderNode.getNodes();
            while (children.hasNext()) {
                Node childNode = children.nextNode();
                if (this.isFolder(childNode)) {
                    this.untrashFolder(childNode);
                    continue;
                }
                if (this.isFile(childNode)) {
                    this.untrashFile(childNode);
                    continue;
                }
                childNode.remove();
            }
            String idPath = this.getId(folderNode);
            DbxEntry item = this.api.get(idPath);
            if (item != null) {
                if (item.isFolder()) {
                    String createdBy;
                    DbxEntry.Folder folder = item.asFolder();
                    String id = JCRLocalDropboxDrive.this.idPath(folder.path);
                    String name = folder.name;
                    String link = this.api.getUserFolderLink(folder.path);
                    String modifiedBy = createdBy = JCRLocalDropboxDrive.this.currentUserName();
                    String type = FOLDER_TYPE;
                    Calendar modified = Calendar.getInstance();
                    JCRLocalDropboxDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, null, modified);
                    JCRLocalDropboxDrive.this.initDropboxFolder(folderNode, folder.mightHaveThumbnail, folder.iconName, null);
                    return new JCRLocalCloudFile(folderNode.getPath(), id, name, link, type, modifiedBy, createdBy, JCRLocalDropboxDrive.this.fileAPI.getCreated(folderNode), modified, folderNode, true);
                }
                throw new FileRestoreException("Untrashed folder appears as not a folder in Dropbox " + item.path);
            }
            throw new FileRestoreException("Folder cannot be restored '" + this.getTitle(folderNode) + "'");
        }

        public boolean isTrashSupported() {
            return true;
        }

        public CloudFile restore(String idPath, String nodePath) throws NotFoundException, CloudDriveException, RepositoryException {
            DbxFileInfo fileInfo = new DbxFileInfo(idPath);
            if (fileInfo.isRoot()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cannot restore root folder - ignore it: " + idPath + " node: " + nodePath));
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">> restore(" + idPath + ", " + nodePath + ")"));
            }
            DbxFileInfo parentInfo = fileInfo.getParent();
            JCRLocalCloudFile restored = null;
            for (Node node : JCRLocalDropboxDrive.this.findNodes(Arrays.asList(idPath))) {
                String path = node.getPath();
                if (path.equals(nodePath)) {
                    Node parent = node.getParent();
                    String parentIdPath = JCRLocalDropboxDrive.this.fileAPI.getId(parent);
                    if (parentInfo.idPath.equals(parentIdPath)) {
                        DbxEntry item = JCRLocalDropboxDrive.this.restoreSubtree(this.api, idPath, parent);
                        if (item != null) {
                            restored = JCRLocalDropboxDrive.this.updateItem(this.api, fileInfo, item, parent, node);
                            continue;
                        }
                        this.remove(node);
                        continue;
                    }
                    this.remove(node);
                    continue;
                }
                this.remove(node);
            }
            if (restored == null) {
                DbxEntry remoteParent = this.api.get(parentInfo.path);
                if (remoteParent != null) {
                    for (Node parent : JCRLocalDropboxDrive.this.findNodes(Arrays.asList(remoteParent.path))) {
                        if (nodePath.startsWith(parent.getPath())) {
                            DbxEntry item = JCRLocalDropboxDrive.this.restoreSubtree(this.api, idPath, parent);
                            if (item == null) continue;
                            restored = JCRLocalDropboxDrive.this.updateItem(this.api, fileInfo, item, parent, null);
                            continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Restoration of " + idPath + " found parent on wrong path " + parent.getPath() + ". Node will be removed."));
                        }
                        this.remove(parent);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Restore not possible: remote parent not found for " + idPath));
                }
            }
            return restored;
        }

        protected String getRev(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("dropbox:rev").getString();
        }

        protected CloudFile uploadFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content, boolean update) throws CloudDriveException, RepositoryException {
            String createdBy;
            DbxEntry.File file;
            String parentId = this.getParentId(fileNode);
            String title = this.getTitle(fileNode);
            String rev = update ? this.getRev(fileNode) : null;
            try {
                file = this.api.uploadFile(parentId, title, content, rev);
            }
            catch (ConflictException e) {
                String idPath = this.getId(fileNode);
                DbxEntry item = this.api.get(idPath);
                if (item != null) {
                    if (item.isFile()) {
                        file = item.asFile();
                        if (fileNode.hasNode("jcr:content")) {
                            fileNode.getNode("jcr:content").setProperty("jcr:data", JCRLocalCloudDrive.DUMMY_DATA);
                        }
                    }
                    throw e;
                }
                LOG.warn((Object)("File upload conflicted but remote file not found " + this.api.filePath(parentId, title)));
                throw e;
            }
            DbxFileInfo info = new DbxFileInfo(file.path);
            String id = info.idPath;
            String name = file.name;
            String link = this.api.getUserFileLink(info.parentPath, info.name);
            String thumbnailLink = null;
            String modifiedBy = createdBy = JCRLocalDropboxDrive.this.currentUserName();
            String type = JCRLocalDropboxDrive.this.findMimetype(name);
            long size = file.numBytes;
            JCRLocalDropboxDrive.this.initFile(fileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified, size);
            JCRLocalDropboxDrive.this.initDropboxFile(fileNode, file.mightHaveThumbnail, file.iconName, file.rev, size);
            return new JCRLocalCloudFile(fileNode.getPath(), id, title, link, null, JCRLocalDropboxDrive.this.previewLink(null, fileNode), thumbnailLink, type, JCRLocalDropboxDrive.this.mimeTypes.getMimeTypeMode(type, name), createdBy, modifiedBy, created, modified, size, fileNode, true);
        }

        protected void remove(Node node) throws RepositoryException {
            if (!JCRLocalDropboxDrive.this.fileAPI.isIgnored(node)) {
                try {
                    node.remove();
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
            }
        }

        protected DbxEntry move(Node node) throws RepositoryException, TooManyFilesException, DropboxException, RefreshAccessException, ConflictException, NotFoundException {
            String localIdPath = this.getId(node);
            String nodePath = node.getPath();
            MovedFile file = JCRLocalDropboxDrive.this.moved.get(localIdPath);
            if (file != null && file.nodePath.equals(nodePath) && file.isNotOutdated()) {
                return this.api.get(file.path);
            }
            String localParentIdPath = this.getParentId(node);
            String title = this.getTitle(node);
            String name = JCRLocalDropboxDrive.this.idPath(title);
            boolean isMove = !localIdPath.startsWith(localParentIdPath) ? true : !localIdPath.endsWith(name);
            if (isMove) {
                String destPath = this.api.filePath(localParentIdPath, title);
                try {
                    DbxEntry f = this.api.move(localIdPath, destPath);
                    if (f == null) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Move failed in Dropbox without a reason ");
                        if (LOG.isDebugEnabled()) {
                            StringBuilder dmsg = new StringBuilder();
                            dmsg.append((CharSequence)msg).append('(').append(localIdPath).append(") ").append(nodePath);
                            LOG.debug((Object)dmsg.toString());
                        }
                        msg.append(nodePath);
                        throw new DropboxException(msg.toString());
                    }
                    JCRLocalDropboxDrive.this.moved.put(localIdPath, new MovedFile(destPath, nodePath));
                    if (f.isFolder()) {
                        this.updateSubtree(node, JCRLocalDropboxDrive.this.idPath(destPath));
                    }
                    return f;
                }
                catch (NotFoundException e) {
                    DbxEntry f = this.api.get(destPath);
                    if (f != null) {
                        return f;
                    }
                    throw e;
                }
            }
            return null;
        }

        protected void updateSubtree(Node folderNode, String folderIdPath) throws RepositoryException {
            NodeIterator niter = folderNode.getNodes();
            while (niter.hasNext()) {
                Node node = niter.nextNode();
                if (!this.isFile(node)) continue;
                String title = this.getTitle(node);
                String idPath = JCRLocalDropboxDrive.this.idPath(this.api.filePath(folderIdPath, title));
                this.setId(node, idPath);
                this.resetSharing(node);
                if (!this.isFolder(node)) continue;
                this.updateSubtree(node, idPath);
            }
        }

        protected void resetSharing(Node fileNode) throws RepositoryException {
            fileNode.setProperty("dropbox:directLink", (String)null);
            if (fileNode.hasProperty("dropbox:sharedLink")) {
                fileNode.setProperty("dropbox:sharedLinkExpires", System.currentTimeMillis());
            }
        }

        protected DbxEntry copy(Node sourceNode, Node destNode) throws RepositoryException, TooManyFilesException, DropboxException, RefreshAccessException, ConflictException, NotFoundException {
            String title;
            String destParentIdPath;
            String destPath;
            String sourceIdPath = this.getId(sourceNode);
            DbxEntry f = this.api.copy(sourceIdPath, destPath = this.api.filePath(destParentIdPath = this.getParentId(destNode), title = this.getTitle(destNode)));
            if (f != null && f.isFolder()) {
                this.updateSubtree(destNode, JCRLocalDropboxDrive.this.idPath(destPath));
            }
            return f;
        }
    }

    protected class MovedFile {
        protected final String path;
        protected final String nodePath;
        protected final long expirationTime;

        protected MovedFile(String path, String nodePath) {
            this.path = path;
            this.nodePath = nodePath;
            this.expirationTime = System.currentTimeMillis() + 15000L;
        }

        protected boolean isNotOutdated() {
            return this.expirationTime >= System.currentTimeMillis();
        }

        protected boolean isOutdated() {
            return this.expirationTime < System.currentTimeMillis();
        }
    }

    @Deprecated
    protected class FullSync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final DropboxAPI api;

        protected FullSync() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalDropboxDrive.this);
            this.api = JCRLocalDropboxDrive.this.getUser().api();
        }

        protected void syncFiles() throws RepositoryException, CloudDriveException {
            long changeId = System.currentTimeMillis();
            this.readLocalNodes();
            String syncCursor = this.api.getDeltas(null).getCursor();
            Object root = this.syncChilds(syncCursor, this.driveNode);
            JCRLocalDropboxDrive.this.initCloudItem(this.driveNode, root);
            this.nodes.remove("ROOT_ID");
            Iterator niter = this.nodes.values().iterator();
            while (niter.hasNext() && !Thread.currentThread().isInterrupted()) {
                List nls = (List)niter.next();
                niter.remove();
                for (Node n : nls) {
                    String npath = n.getPath();
                    if (!JCRLocalDropboxDrive.this.notInRange(npath, this.getRemoved())) continue;
                    this.removeLinks(n);
                    n.remove();
                    this.addRemoved(npath);
                }
            }
            JCRLocalDropboxDrive.this.setChangeId(changeId);
            this.driveNode.setProperty("dropbox:cursor", syncCursor);
            JCRLocalDropboxDrive.this.updateState(syncCursor);
        }

        protected Object syncChilds(String folderId, Node parent) throws RepositoryException, CloudDriveException {
            DropboxAPI.FileMetadata items = this.api.getWithChildren(folderId, null);
            this.iterators.add(items);
            while (items.hasNext() && !Thread.currentThread().isInterrupted()) {
                DbxEntry item = (DbxEntry)items.next();
                DbxFileInfo file = new DbxFileInfo(item.path);
                if (file.isRoot()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Fetched root folder entry - ignore it: " + item.path));
                    continue;
                }
                List existing = (List)this.nodes.remove("TODO item.getId()");
                JCRLocalCloudFile localItem = JCRLocalDropboxDrive.this.updateItem(this.api, file, item, parent, null);
                if (localItem.isChanged()) {
                    this.addChanged((CloudFile)localItem);
                    if (existing != null) {
                        Iterator eiter = existing.iterator();
                        while (eiter.hasNext()) {
                            Node enode = (Node)eiter.next();
                            String path = localItem.getPath();
                            String epath = enode.getPath();
                            if (epath.equals(path) || !JCRLocalDropboxDrive.this.notInRange(epath, this.getRemoved())) continue;
                            this.removeLinks(enode);
                            enode.remove();
                            this.addRemoved(epath);
                            eiter.remove();
                        }
                    }
                }
                if (!localItem.isFolder()) continue;
                this.syncChilds(localItem.getId(), localItem.getNode());
            }
            return items.target;
        }

        protected void execLocal() throws CloudDriveException, RepositoryException {
            JCRLocalDropboxDrive.this.commandEnv.configure((CloudDrive.Command)this);
            super.exec();
            JCRLocalDropboxDrive.this.fileHistory.clear();
            try {
                JCRLocalDropboxDrive.this.jcrListener.disable();
                String empty = "".intern();
                this.driveNode.setProperty("ecd:localHistory", empty);
                this.driveNode.setProperty("ecd:localChanges", empty);
                this.driveNode.save();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error cleaning local history in " + JCRLocalDropboxDrive.this.title()), e);
            }
            finally {
                JCRLocalDropboxDrive.this.jcrListener.enable();
            }
        }

        protected void preSaveChunk() throws CloudDriveException, RepositoryException {
        }
    }

    protected class Connect
    extends JCRLocalCloudDrive.ConnectCommand
    implements Changes {
        protected final DropboxAPI api;

        protected Connect() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalDropboxDrive.this);
            this.api = JCRLocalDropboxDrive.this.getUser().api();
        }

        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            long changeId = System.currentTimeMillis();
            String connectCursor = this.api.getDeltas(null).getCursor();
            JCRLocalDropboxDrive.this.fetchSubtree(this.api, "/", this.driveNode, false, this.iterators, this);
            JCRLocalDropboxDrive.this.setChangeId(changeId);
            this.driveNode.setProperty("dropbox:cursor", connectCursor);
            JCRLocalDropboxDrive.this.updateState(connectCursor);
        }

        @Override
        public void apply(JCRLocalCloudFile localFile) throws RepositoryException, CloudDriveException {
            String parentIdPath = JCRLocalDropboxDrive.this.fileAPI.getParentId(localFile.getNode());
            this.addConnected(parentIdPath, (CloudFile)localFile);
        }

        @Override
        public boolean canApply(String parentId, String fileId) {
            return !this.isConnected(parentId, fileId);
        }
    }

    protected static interface Changes {
        public void apply(JCRLocalCloudFile var1) throws RepositoryException, CloudDriveException;

        public boolean canApply(String var1, String var2);
    }
}

