/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.googleapis.media;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.exoplatform.shaded.google.api.client.googleapis.MethodOverride;
import org.exoplatform.shaded.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import org.exoplatform.shaded.google.api.client.googleapis.media.MediaUploadErrorHandler;
import org.exoplatform.shaded.google.api.client.http.AbstractInputStreamContent;
import org.exoplatform.shaded.google.api.client.http.ByteArrayContent;
import org.exoplatform.shaded.google.api.client.http.EmptyContent;
import org.exoplatform.shaded.google.api.client.http.GZipEncoding;
import org.exoplatform.shaded.google.api.client.http.GenericUrl;
import org.exoplatform.shaded.google.api.client.http.HttpContent;
import org.exoplatform.shaded.google.api.client.http.HttpHeaders;
import org.exoplatform.shaded.google.api.client.http.HttpRequest;
import org.exoplatform.shaded.google.api.client.http.HttpRequestFactory;
import org.exoplatform.shaded.google.api.client.http.HttpRequestInitializer;
import org.exoplatform.shaded.google.api.client.http.HttpResponse;
import org.exoplatform.shaded.google.api.client.http.HttpTransport;
import org.exoplatform.shaded.google.api.client.http.InputStreamContent;
import org.exoplatform.shaded.google.api.client.http.MultipartContent;
import org.exoplatform.shaded.google.api.client.util.Beta;
import org.exoplatform.shaded.google.api.client.util.ByteStreams;
import org.exoplatform.shaded.google.api.client.util.Preconditions;
import org.exoplatform.shaded.google.api.client.util.Sleeper;

public final class MediaHttpUploader {
    public static final String CONTENT_LENGTH_HEADER = "X-Upload-Content-Length";
    public static final String CONTENT_TYPE_HEADER = "X-Upload-Content-Type";
    private UploadState uploadState = UploadState.NOT_STARTED;
    static final int MB = 0x100000;
    private static final int KB = 1024;
    public static final int MINIMUM_CHUNK_SIZE = 262144;
    public static final int DEFAULT_CHUNK_SIZE = 0xA00000;
    private final AbstractInputStreamContent mediaContent;
    private final HttpRequestFactory requestFactory;
    private final HttpTransport transport;
    private HttpContent metadata;
    private long mediaContentLength;
    private boolean isMediaContentLengthCalculated;
    private String initiationRequestMethod = "POST";
    private HttpHeaders initiationHeaders = new HttpHeaders();
    private HttpRequest currentRequest;
    private InputStream contentInputStream;
    private boolean directUploadEnabled;
    private MediaHttpUploaderProgressListener progressListener;
    String mediaContentLengthStr = "*";
    private long totalBytesServerReceived;
    private int chunkSize = 0xA00000;
    private Byte cachedByte;
    private long totalBytesClientSent;
    private int currentChunkLength;
    private byte[] currentRequestContentBuffer;
    private boolean disableGZipContent;
    Sleeper sleeper = Sleeper.DEFAULT;

    public MediaHttpUploader(AbstractInputStreamContent mediaContent, HttpTransport transport, HttpRequestInitializer httpRequestInitializer) {
        this.mediaContent = Preconditions.checkNotNull(mediaContent);
        this.transport = Preconditions.checkNotNull(transport);
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
    }

    public HttpResponse upload(GenericUrl initiationRequestUrl) throws IOException {
        Preconditions.checkArgument(this.uploadState == UploadState.NOT_STARTED);
        if (this.directUploadEnabled) {
            return this.directUpload(initiationRequestUrl);
        }
        return this.resumableUpload(initiationRequestUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse directUpload(GenericUrl initiationRequestUrl) throws IOException {
        this.updateStateAndNotifyListener(UploadState.MEDIA_IN_PROGRESS);
        HttpContent content = this.mediaContent;
        if (this.metadata != null) {
            content = new MultipartContent().setContentParts(Arrays.asList(this.metadata, this.mediaContent));
            initiationRequestUrl.put("uploadType", (Object)"multipart");
        } else {
            initiationRequestUrl.put("uploadType", (Object)"media");
        }
        HttpRequest request = this.requestFactory.buildRequest(this.initiationRequestMethod, initiationRequestUrl, content);
        request.getHeaders().putAll(this.initiationHeaders);
        HttpResponse response = this.executeCurrentRequest(request);
        boolean responseProcessed = false;
        try {
            if (this.isMediaLengthKnown()) {
                this.totalBytesServerReceived = this.getMediaContentLength();
            }
            this.updateStateAndNotifyListener(UploadState.MEDIA_COMPLETE);
            responseProcessed = true;
        }
        finally {
            if (!responseProcessed) {
                response.disconnect();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse resumableUpload(GenericUrl initiationRequestUrl) throws IOException {
        GenericUrl uploadUrl;
        HttpResponse initialResponse = this.executeUploadInitiation(initiationRequestUrl);
        if (!initialResponse.isSuccessStatusCode()) {
            return initialResponse;
        }
        try {
            uploadUrl = new GenericUrl(initialResponse.getHeaders().getLocation());
        }
        finally {
            initialResponse.disconnect();
        }
        this.contentInputStream = this.mediaContent.getInputStream();
        if (!this.contentInputStream.markSupported() && this.isMediaLengthKnown()) {
            this.contentInputStream = new BufferedInputStream(this.contentInputStream);
        }
        while (true) {
            this.currentRequest = this.requestFactory.buildPutRequest(uploadUrl, null);
            this.setContentAndHeadersOnCurrentRequest();
            new MediaUploadErrorHandler(this, this.currentRequest);
            HttpResponse response = this.isMediaLengthKnown() ? this.executeCurrentRequestWithoutGZip(this.currentRequest) : this.executeCurrentRequest(this.currentRequest);
            boolean returningResponse = false;
            try {
                long newBytesServerReceived;
                long currentBytesServerReceived;
                HttpResponse httpResponse;
                if (response.isSuccessStatusCode()) {
                    this.totalBytesServerReceived = this.getMediaContentLength();
                    if (this.mediaContent.getCloseInputStream()) {
                        this.contentInputStream.close();
                    }
                    this.updateStateAndNotifyListener(UploadState.MEDIA_COMPLETE);
                    returningResponse = true;
                    httpResponse = response;
                    return httpResponse;
                }
                if (response.getStatusCode() != 308) {
                    returningResponse = true;
                    httpResponse = response;
                    return httpResponse;
                }
                String updatedUploadUrl = response.getHeaders().getLocation();
                if (updatedUploadUrl != null) {
                    uploadUrl = new GenericUrl(updatedUploadUrl);
                }
                Preconditions.checkState((currentBytesServerReceived = (newBytesServerReceived = this.getNextByteIndex(response.getHeaders().getRange())) - this.totalBytesServerReceived) >= 0L && currentBytesServerReceived <= (long)this.currentChunkLength);
                long copyBytes = (long)this.currentChunkLength - currentBytesServerReceived;
                if (this.isMediaLengthKnown()) {
                    if (copyBytes > 0L) {
                        this.contentInputStream.reset();
                        long actualSkipValue = this.contentInputStream.skip(currentBytesServerReceived);
                        Preconditions.checkState(currentBytesServerReceived == actualSkipValue);
                    }
                } else if (copyBytes == 0L) {
                    this.currentRequestContentBuffer = null;
                }
                this.totalBytesServerReceived = newBytesServerReceived;
                this.updateStateAndNotifyListener(UploadState.MEDIA_IN_PROGRESS);
                continue;
            }
            finally {
                if (returningResponse) continue;
                response.disconnect();
                continue;
            }
            break;
        }
    }

    private boolean isMediaLengthKnown() throws IOException {
        return this.getMediaContentLength() >= 0L;
    }

    private long getMediaContentLength() throws IOException {
        if (!this.isMediaContentLengthCalculated) {
            this.mediaContentLength = this.mediaContent.getLength();
            this.isMediaContentLengthCalculated = true;
        }
        return this.mediaContentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeUploadInitiation(GenericUrl initiationRequestUrl) throws IOException {
        this.updateStateAndNotifyListener(UploadState.INITIATION_STARTED);
        initiationRequestUrl.put("uploadType", (Object)"resumable");
        HttpContent content = this.metadata == null ? new EmptyContent() : this.metadata;
        HttpRequest request = this.requestFactory.buildRequest(this.initiationRequestMethod, initiationRequestUrl, content);
        this.initiationHeaders.set(CONTENT_TYPE_HEADER, this.mediaContent.getType());
        if (this.isMediaLengthKnown()) {
            this.initiationHeaders.set(CONTENT_LENGTH_HEADER, this.getMediaContentLength());
        }
        request.getHeaders().putAll(this.initiationHeaders);
        HttpResponse response = this.executeCurrentRequest(request);
        boolean notificationCompleted = false;
        try {
            this.updateStateAndNotifyListener(UploadState.INITIATION_COMPLETE);
            notificationCompleted = true;
        }
        finally {
            if (!notificationCompleted) {
                response.disconnect();
            }
        }
        return response;
    }

    private HttpResponse executeCurrentRequestWithoutGZip(HttpRequest request) throws IOException {
        new MethodOverride().intercept(request);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        return response;
    }

    private HttpResponse executeCurrentRequest(HttpRequest request) throws IOException {
        if (!this.disableGZipContent && !(request.getContent() instanceof EmptyContent)) {
            request.setEncoding(new GZipEncoding());
        }
        HttpResponse response = this.executeCurrentRequestWithoutGZip(request);
        return response;
    }

    private void setContentAndHeadersOnCurrentRequest() throws IOException {
        AbstractInputStreamContent contentChunk;
        int blockSize = this.isMediaLengthKnown() ? (int)Math.min((long)this.chunkSize, this.getMediaContentLength() - this.totalBytesServerReceived) : this.chunkSize;
        int actualBlockSize = blockSize;
        if (this.isMediaLengthKnown()) {
            this.contentInputStream.mark(blockSize);
            InputStream limitInputStream = ByteStreams.limit(this.contentInputStream, blockSize);
            contentChunk = new InputStreamContent(this.mediaContent.getType(), limitInputStream).setRetrySupported(true).setLength(blockSize).setCloseInputStream(false);
            this.mediaContentLengthStr = String.valueOf(this.getMediaContentLength());
        } else {
            int actualBytesRead;
            int bytesAllowedToRead;
            int copyBytes = 0;
            if (this.currentRequestContentBuffer == null) {
                bytesAllowedToRead = this.cachedByte == null ? blockSize + 1 : blockSize;
                this.currentRequestContentBuffer = new byte[blockSize + 1];
                if (this.cachedByte != null) {
                    this.currentRequestContentBuffer[0] = this.cachedByte;
                }
            } else {
                copyBytes = (int)(this.totalBytesClientSent - this.totalBytesServerReceived);
                System.arraycopy(this.currentRequestContentBuffer, this.currentChunkLength - copyBytes, this.currentRequestContentBuffer, 0, copyBytes);
                if (this.cachedByte != null) {
                    this.currentRequestContentBuffer[copyBytes] = this.cachedByte;
                }
                bytesAllowedToRead = blockSize - copyBytes;
            }
            if ((actualBytesRead = ByteStreams.read(this.contentInputStream, this.currentRequestContentBuffer, blockSize + 1 - bytesAllowedToRead, bytesAllowedToRead)) < bytesAllowedToRead) {
                actualBlockSize = copyBytes + Math.max(0, actualBytesRead);
                if (this.cachedByte != null) {
                    ++actualBlockSize;
                    this.cachedByte = null;
                }
                if (this.mediaContentLengthStr.equals("*")) {
                    this.mediaContentLengthStr = String.valueOf(this.totalBytesServerReceived + (long)actualBlockSize);
                }
            } else {
                this.cachedByte = this.currentRequestContentBuffer[blockSize];
            }
            contentChunk = new ByteArrayContent(this.mediaContent.getType(), this.currentRequestContentBuffer, 0, actualBlockSize);
            this.totalBytesClientSent = this.totalBytesServerReceived + (long)actualBlockSize;
        }
        this.currentChunkLength = actualBlockSize;
        this.currentRequest.setContent(contentChunk);
        if (actualBlockSize == 0) {
            this.currentRequest.getHeaders().setContentRange("bytes */" + this.mediaContentLengthStr);
        } else {
            this.currentRequest.getHeaders().setContentRange("bytes " + this.totalBytesServerReceived + "-" + (this.totalBytesServerReceived + (long)actualBlockSize - 1L) + "/" + this.mediaContentLengthStr);
        }
    }

    @Beta
    void serverErrorCallback() throws IOException {
        Preconditions.checkNotNull(this.currentRequest, "The current request should not be null");
        this.currentRequest.setContent(new EmptyContent());
        this.currentRequest.getHeaders().setContentRange("bytes */" + this.mediaContentLengthStr);
    }

    private long getNextByteIndex(String rangeHeader) {
        if (rangeHeader == null) {
            return 0L;
        }
        return Long.parseLong(rangeHeader.substring(rangeHeader.indexOf(45) + 1)) + 1L;
    }

    public HttpContent getMetadata() {
        return this.metadata;
    }

    public MediaHttpUploader setMetadata(HttpContent metadata) {
        this.metadata = metadata;
        return this;
    }

    public HttpContent getMediaContent() {
        return this.mediaContent;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public MediaHttpUploader setDirectUploadEnabled(boolean directUploadEnabled) {
        this.directUploadEnabled = directUploadEnabled;
        return this;
    }

    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    public MediaHttpUploader setProgressListener(MediaHttpUploaderProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public MediaHttpUploaderProgressListener getProgressListener() {
        return this.progressListener;
    }

    public MediaHttpUploader setChunkSize(int chunkSize) {
        Preconditions.checkArgument(chunkSize > 0 && chunkSize % 262144 == 0, "chunkSize must be a positive multiple of 262144.");
        this.chunkSize = chunkSize;
        return this;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public boolean getDisableGZipContent() {
        return this.disableGZipContent;
    }

    public MediaHttpUploader setDisableGZipContent(boolean disableGZipContent) {
        this.disableGZipContent = disableGZipContent;
        return this;
    }

    public Sleeper getSleeper() {
        return this.sleeper;
    }

    public MediaHttpUploader setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
        return this;
    }

    public String getInitiationRequestMethod() {
        return this.initiationRequestMethod;
    }

    public MediaHttpUploader setInitiationRequestMethod(String initiationRequestMethod) {
        Preconditions.checkArgument(initiationRequestMethod.equals("POST") || initiationRequestMethod.equals("PUT") || initiationRequestMethod.equals("PATCH"));
        this.initiationRequestMethod = initiationRequestMethod;
        return this;
    }

    public MediaHttpUploader setInitiationHeaders(HttpHeaders initiationHeaders) {
        this.initiationHeaders = initiationHeaders;
        return this;
    }

    public HttpHeaders getInitiationHeaders() {
        return this.initiationHeaders;
    }

    public long getNumBytesUploaded() {
        return this.totalBytesServerReceived;
    }

    private void updateStateAndNotifyListener(UploadState uploadState) throws IOException {
        this.uploadState = uploadState;
        if (this.progressListener != null) {
            this.progressListener.progressChanged(this);
        }
    }

    public UploadState getUploadState() {
        return this.uploadState;
    }

    public double getProgress() throws IOException {
        Preconditions.checkArgument(this.isMediaLengthKnown(), "Cannot call getProgress() if the specified AbstractInputStreamContent has no content length. Use  getNumBytesUploaded() to denote progress instead.");
        return this.getMediaContentLength() == 0L ? 0.0 : (double)this.totalBytesServerReceived / (double)this.getMediaContentLength();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UploadState {
        NOT_STARTED,
        INITIATION_STARTED,
        INITIATION_COMPLETE,
        MEDIA_IN_PROGRESS,
        MEDIA_COMPLETE;

    }
}

