/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.dropbox;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxSessionStore;
import com.dropbox.core.DbxWebAuth;
import com.dropbox.core.InvalidAccessTokenException;
import com.dropbox.core.RetryException;
import com.dropbox.core.v2.users.FullAccount;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotApprovedException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.dropbox.DropboxAPI;
import org.exoplatform.clouddrive.dropbox.DropboxException;
import org.exoplatform.clouddrive.dropbox.DropboxProvider;
import org.exoplatform.clouddrive.dropbox.DropboxUser;
import org.exoplatform.clouddrive.dropbox.JCRLocalDropboxDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.organization.OrganizationService;

public class DropboxConnector
extends CloudDriveConnector {
    public static final String CLIENT_NAME = "eXoCloudDriveClient/2.0";
    protected final OrganizationService organization;
    private API apiFactory;

    public DropboxConnector(RepositoryService jcrService, SessionProviderService sessionProviders, OrganizationService organization, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, InitParams params) throws ConfigurationException {
        super(jcrService, sessionProviders, finder, mimeTypes, params);
        this.organization = organization;
    }

    protected DropboxProvider getProvider() {
        return (DropboxProvider)super.getProvider();
    }

    protected CloudProvider createProvider() throws ConfigurationException {
        return new DropboxProvider(this.getProviderId(), this.getProviderName(), this.apiFactory(), this.jcrService);
    }

    protected CloudUser authenticate(Map<String, String> params) throws CloudDriveException {
        String code = params.get("code");
        if (code != null && code.length() > 0) {
            DropboxAPI driveAPI = this.apiFactory().auth(params).build();
            FullAccount apiUser = driveAPI.getCurrentUser();
            DropboxUser user = new DropboxUser(apiUser.getAccountId(), apiUser.getName().getDisplayName(), apiUser.getEmail(), this.provider, driveAPI);
            return user;
        }
        throw new CloudDriveException("Access key should not be null or empty");
    }

    protected CloudDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof DropboxUser) {
            DropboxUser apiUser = (DropboxUser)user;
            JCRLocalDropboxDrive drive = new JCRLocalDropboxDrive(apiUser, driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
            return drive;
        }
        throw new CloudDriveException("Not cloud user: " + user);
    }

    protected CloudDrive loadDrive(Node driveNode) throws DriveRemovedException, CloudDriveException, RepositoryException {
        JCRLocalCloudDrive.checkNotTrashed((Node)driveNode);
        JCRLocalCloudDrive.migrateName((Node)driveNode);
        JCRLocalDropboxDrive drive = new JCRLocalDropboxDrive(this.apiFactory(), this.getProvider(), driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes);
        return drive;
    }

    protected API apiFactory() {
        if (this.apiFactory == null) {
            this.apiFactory = new API();
        }
        return this.apiFactory;
    }

    class API {
        final DbxAppInfo appInfo;
        final String redirectUri;
        final DbxRequestConfig authConfig;
        final Map<String, Builder> users;

        API() {
            this.appInfo = new DbxAppInfo(DropboxConnector.this.getClientId(), DropboxConnector.this.getClientSecret());
            this.redirectUri = DropboxConnector.this.redirectLink();
            this.authConfig = DbxRequestConfig.newBuilder((String)DropboxConnector.CLIENT_NAME).withUserLocaleFrom(Locale.getDefault()).build();
            this.users = new HashMap<String, Builder>();
        }

        private synchronized Builder init(String user) {
            Builder apiBuilder = this.users.get(user);
            if (apiBuilder == null) {
                apiBuilder = new Builder();
                this.users.put(user, apiBuilder);
            }
            return apiBuilder;
        }

        private synchronized Builder finish(String user) {
            return this.users.remove(user);
        }

        String authLink(String state) {
            return this.init(DropboxConnector.this.currentUser()).withState(state).buildAuthLink();
        }

        Builder auth(Map<String, String> params) {
            HashMap<String, String[]> dbxParams = new HashMap<String, String[]>();
            for (Map.Entry<String, String> pe : params.entrySet()) {
                dbxParams.put(pe.getKey(), new String[]{pe.getValue()});
            }
            return this.init(DropboxConnector.this.currentUser()).withParams(dbxParams);
        }

        Builder load(String accessToken) {
            return this.init(DropboxConnector.this.currentUser()).withAccessToken(accessToken);
        }

        class Builder {
            final DbxWebAuth auth;
            DbxSessionStore sessionStore;
            String accessToken;
            String state;
            String authLink;
            Map<String, String[]> params;

            Builder() {
                this.auth = new DbxWebAuth(API.this.authConfig, API.this.appInfo);
                this.sessionStore = new AuthSessionStore();
            }

            Builder withAccessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            Builder withState(String state) {
                if (this.state == null || this.state != null && !this.state.equals(state)) {
                    this.state = state;
                    this.authLink = null;
                }
                return this;
            }

            Builder withParams(Map<String, String[]> params) {
                this.params = params;
                return this;
            }

            String buildAuthLink() {
                if (this.authLink == null) {
                    DbxWebAuth.Request.Builder authRequestBuilder = DbxWebAuth.newRequestBuilder().withRedirectUri(API.this.redirectUri, this.sessionStore);
                    if (this.state != null) {
                        authRequestBuilder.withState(this.state);
                    }
                    this.authLink = this.auth.authorize(authRequestBuilder.build());
                }
                return this.authLink;
            }

            DropboxAPI build() throws DropboxException, CloudDriveException {
                String user = DropboxConnector.this.currentUser();
                if (this.params != null && this.params.size() > 0) {
                    try {
                        DbxAuthFinish authFinish = this.auth.finishFromRedirect(API.this.redirectUri, this.sessionStore, this.params);
                        DropboxAPI dropboxAPI = new DropboxAPI(API.this.authConfig, authFinish.getAccessToken());
                        return dropboxAPI;
                    }
                    catch (DbxWebAuth.BadRequestException e) {
                        String msg = "Wrong authorization parameter(s)";
                        LOG.error((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                        throw new DropboxException(msg);
                    }
                    catch (DbxWebAuth.BadStateException e) {
                        String msg = "Authorization session expired";
                        LOG.warn((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                        throw new CloudDriveAccessException(msg + ". Please try again later.");
                    }
                    catch (DbxWebAuth.CsrfException e) {
                        String msg = "Authorization state not found";
                        LOG.warn((Object)(msg + ". CSRF error during authorization: " + e.getMessage()), (Throwable)e);
                        throw new DropboxException(msg + ". Please retry your request.");
                    }
                    catch (DbxWebAuth.NotApprovedException e) {
                        String msg = "Access not approved";
                        LOG.warn((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                        throw new NotApprovedException(msg);
                    }
                    catch (DbxWebAuth.ProviderException e) {
                        String msg = "Authorization process error";
                        LOG.error((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                        throw new DropboxException(msg + ". Please retry your request.");
                    }
                    catch (InvalidAccessTokenException e) {
                        String msg = "Invalid access credentials";
                        LOG.warn((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
                        throw new RefreshAccessException(msg + ". Please authorize to Dropbox.");
                    }
                    catch (RetryException e) {
                        String msg = "Dropbox overloaded or hit rate exceeded";
                        LOG.warn((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                        throw new DropboxException(msg + ". Please try again later.");
                    }
                    catch (DbxException e) {
                        String msg = "Dropbox error";
                        LOG.error((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                        throw new DropboxException(msg + ". Please try again later.");
                    }
                    finally {
                        this.params.clear();
                        this.sessionStore.clear();
                        this.accessToken = null;
                        API.this.finish(user);
                    }
                }
                if (this.accessToken != null) {
                    return new DropboxAPI(API.this.authConfig, this.accessToken);
                }
                throw new CloudDriveException("API not properly authorized nor loaded with ready access token for user " + user);
            }
        }
    }

    class AuthLink {
        final String link;
        final DbxSessionStore store;

        AuthLink(String link, DbxSessionStore store) {
            this.link = link;
            this.store = store;
        }
    }

    class AuthSessionStore
    implements DbxSessionStore {
        final AtomicReference<String> value = new AtomicReference();

        AuthSessionStore() {
        }

        public String get() {
            return this.value.get();
        }

        public void set(String newValue) {
            this.value.set(newValue);
        }

        public void clear() {
            this.value.set(null);
        }
    }
}

