/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.filters;

import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.clouddrive.ecms.CloudDriveContext;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class PersonalDocumentsFilter
implements UIExtensionFilter {
    protected static final Log LOG = ExoLogger.getLogger(PersonalDocumentsFilter.class);

    public boolean accept(Map<String, Object> context) throws Exception {
        if (context == null) {
            return true;
        }
        Node contextNode = (Node)context.get(Node.class.getName());
        if (contextNode == null) {
            return false;
        }
        String contextPath = contextNode.getPath();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)context.get(UIJCRExplorer.class.getName());
        String personalDocsPath = Utils.getPersonalDrivePath((String)uiExplorer.getDriveData().getHomePath(), (String)userId);
        if (contextPath.startsWith(personalDocsPath)) {
            boolean isRoot = contextNode.getPath().equals(personalDocsPath);
            if (isRoot) {
                CloudDriveContext.initConnected(WebuiRequestContext.getCurrentInstance(), contextNode);
            } else {
                Item personalDocs = contextNode.getSession().getItem(personalDocsPath);
                if (personalDocs.isNode()) {
                    CloudDriveContext.initConnected(WebuiRequestContext.getCurrentInstance(), (Node)personalDocs);
                } else {
                    LOG.warn((Object)("Personal Documents not a Node: " + personalDocs.getPath()));
                }
            }
            return isRoot;
        }
        return false;
    }

    public UIExtensionFilterType getType() {
        return UIExtensionFilterType.MANDATORY;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }
}

