/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.SharingPublicPolicyType;
import com.dropbox.core.v2.paper.SharingTeamPolicyType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class SharingPolicy {
    protected final SharingPublicPolicyType publicSharingPolicy;
    protected final SharingTeamPolicyType teamSharingPolicy;

    public SharingPolicy(SharingPublicPolicyType publicSharingPolicy, SharingTeamPolicyType teamSharingPolicy) {
        this.publicSharingPolicy = publicSharingPolicy;
        this.teamSharingPolicy = teamSharingPolicy;
    }

    public SharingPolicy() {
        this(null, null);
    }

    public SharingPublicPolicyType getPublicSharingPolicy() {
        return this.publicSharingPolicy;
    }

    public SharingTeamPolicyType getTeamSharingPolicy() {
        return this.teamSharingPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.publicSharingPolicy, this.teamSharingPolicy});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharingPolicy other = (SharingPolicy)obj;
            return (this.publicSharingPolicy == other.publicSharingPolicy || this.publicSharingPolicy != null && this.publicSharingPolicy.equals((Object)other.publicSharingPolicy)) && (this.teamSharingPolicy == other.teamSharingPolicy || this.teamSharingPolicy != null && this.teamSharingPolicy.equals((Object)other.teamSharingPolicy));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharingPolicy> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharingPolicy value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.publicSharingPolicy != null) {
                g.writeFieldName("public_sharing_policy");
                StoneSerializers.nullable(SharingPublicPolicyType.Serializer.INSTANCE).serialize(value.publicSharingPolicy, g);
            }
            if (value.teamSharingPolicy != null) {
                g.writeFieldName("team_sharing_policy");
                StoneSerializers.nullable(SharingTeamPolicyType.Serializer.INSTANCE).serialize(value.teamSharingPolicy, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharingPolicy deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            SharingTeamPolicyType f_teamSharingPolicy;
            SharingPublicPolicyType f_publicSharingPolicy;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_publicSharingPolicy = null;
                f_teamSharingPolicy = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("public_sharing_policy".equals(field)) {
                        f_publicSharingPolicy = StoneSerializers.nullable(SharingPublicPolicyType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("team_sharing_policy".equals(field)) {
                        f_teamSharingPolicy = StoneSerializers.nullable(SharingTeamPolicyType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharingPolicy value = new SharingPolicy(f_publicSharingPolicy, f_teamSharingPolicy);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected SharingPublicPolicyType publicSharingPolicy = null;
        protected SharingTeamPolicyType teamSharingPolicy = null;

        protected Builder() {
        }

        public Builder withPublicSharingPolicy(SharingPublicPolicyType publicSharingPolicy) {
            this.publicSharingPolicy = publicSharingPolicy;
            return this;
        }

        public Builder withTeamSharingPolicy(SharingTeamPolicyType teamSharingPolicy) {
            this.teamSharingPolicy = teamSharingPolicy;
            return this;
        }

        public SharingPolicy build() {
            return new SharingPolicy(this.publicSharingPolicy, this.teamSharingPolicy);
        }
    }
}

