/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.exoplatform.clouddrive.cmis.CMISAPI;
import org.exoplatform.clouddrive.cmis.CMISConnector;
import org.exoplatform.clouddrive.cmis.CMISException;
import org.exoplatform.clouddrive.cmis.CMISUser;
import org.exoplatform.ecm.connector.clouddrives.ContentService;
import org.exoplatform.services.cms.clouddrives.CannotConnectDriveException;
import org.exoplatform.services.cms.clouddrives.CloudDriveAccessException;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.CloudFileAPI;
import org.exoplatform.services.cms.clouddrives.CloudUser;
import org.exoplatform.services.cms.clouddrives.ConflictException;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.NotFoundException;
import org.exoplatform.services.cms.clouddrives.SyncNotSupportedException;
import org.exoplatform.services.cms.clouddrives.UnauthorizedException;
import org.exoplatform.services.cms.clouddrives.jcr.JCRLocalCloudDrive;
import org.exoplatform.services.cms.clouddrives.jcr.JCRLocalCloudFile;
import org.exoplatform.services.cms.clouddrives.jcr.NodeFinder;
import org.exoplatform.services.cms.clouddrives.utils.ExtendedMimeTypeResolver;
import org.exoplatform.services.cms.clouddrives.viewer.ContentReader;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.gatein.common.util.Base64;

public class JCRLocalCMISDrive
extends JCRLocalCloudDrive {
    public static final long FULL_SYNC_PERIOD = 86400000L;
    protected static final String PREVIOUS_LOCAL_NAME = "cmiscd:previousLocalName";
    protected static final String PREVIOUS_LOCAL_PARENT = "cmiscd:previousLocalParent";
    protected final AtomicLong changeIdSequencer = new AtomicLong(0L);
    protected final String exoURL;

    protected JCRLocalCMISDrive(CMISUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, String exoURL) throws CloudDriveException, RepositoryException {
        super((CloudUser)user, driveNode, sessionProviders, finder, mimeTypes);
        this.exoURL = exoURL;
        CMISAPI api = user.api();
        this.saveAccess(driveNode, api.getPassword(), api.getServiceURL(), api.getRepositoryId());
    }

    protected JCRLocalCMISDrive(CMISConnector.API apiBuilder, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, String exoURL) throws RepositoryException, CloudDriveException {
        super((CloudUser)JCRLocalCMISDrive.loadUser(apiBuilder, driveNode), driveNode, sessionProviders, finder, mimeTypes);
        this.exoURL = exoURL;
    }

    protected static CMISUser loadUser(CMISConnector.API apiBuilder, Node driveNode) throws RepositoryException, CMISException, CloudDriveException {
        String userName = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessKey = driveNode.getProperty("cmiscd:accessKey").getString();
        try {
            String password = new String(Base64.decode((String)accessKey), "UTF-8");
            String serviceURL = driveNode.getProperty("cmiscd:serviceURL").getString();
            String repositoryId = driveNode.getProperty("cmiscd:repositoryId").getString();
            CMISAPI driveAPI = apiBuilder.auth(userName, password).serviceUrl(serviceURL).build();
            driveAPI.initRepository(repositoryId);
            return apiBuilder.createUser(userId, userName, email, driveAPI);
        }
        catch (UnsupportedEncodingException e) {
            throw new CloudDriveException("Error decoding user key", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAccess(Node driveNode, String password, String serviceURL, String repositoryId) throws CloudDriveException {
        try {
            this.jcrListener.disable();
            try {
                String accessKey = Base64.encodeBytes((byte[])password.getBytes("UTF-8"));
                driveNode.setProperty("cmiscd:accessKey", accessKey);
                if (serviceURL != null) {
                    driveNode.setProperty("cmiscd:serviceURL", serviceURL);
                } else if (!driveNode.hasProperty("cmiscd:serviceURL")) {
                    this.rollback(driveNode);
                    throw new CloudDriveException("CMIS service URL required for user access");
                }
                if (repositoryId != null) {
                    driveNode.setProperty("cmiscd:repositoryId", repositoryId);
                } else if (!driveNode.hasProperty("cmiscd:repositoryId")) {
                    this.rollback(driveNode);
                    throw new CloudDriveException("CMIS repository ID required for user access");
                }
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error saving user key", (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new CloudDriveException("Error encoding user key", (Throwable)e);
            }
        }
        finally {
            this.jcrListener.enable();
        }
    }

    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new Connect();
    }

    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new Sync();
    }

    protected CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new FileAPI();
    }

    protected Long readChangeId() throws RepositoryException, CloudDriveException {
        try {
            return this.rootNode().getProperty("cmiscd:changeTimestamp").getLong();
        }
        catch (PathNotFoundException e) {
            throw new CloudDriveException("Change id not found for the drive " + this.title());
        }
    }

    protected void saveChangeId(Long id) throws CloudDriveException, RepositoryException {
        Node driveNode = this.rootNode();
        driveNode.setProperty("cmiscd:changeTimestamp", id.longValue());
    }

    public CMISUser getUser() {
        return (CMISUser)this.user;
    }

    protected void refreshAccess() throws CloudDriveException {
    }

    protected void updateAccess(CloudUser newUser) throws CloudDriveException, RepositoryException {
        CMISAPI newAPI = ((CMISUser)newUser).api();
        String user = newAPI.getUser();
        String password = newAPI.getPassword();
        try {
            Node driveNode = this.rootNode();
            String userId = driveNode.getProperty("ecd:cloudUserId").getString();
            if (!userId.equals(user)) {
                throw new CloudDriveException("User doesn't match to access key: " + user);
            }
            this.saveAccess(driveNode, password, null, null);
            this.getUser().api().updateUser(newAPI.getParamaters());
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void initCMISItem(Node node, CmisObject item) throws RepositoryException, CMISException {
        this.setChangeToken(node, item.getChangeToken());
        node.setProperty("cmiscd:refreshTimestamp", item.getRefreshTimestamp());
        node.setProperty("cmiscd:description", item.getDescription());
        org.apache.chemistry.opencmis.client.api.Property pbv = item.getProperty("cmis:isLatestVersion");
        if (pbv != null) {
            node.setProperty("cmiscd:isLatestVersion", ((Boolean)pbv.getFirstValue()).booleanValue());
        } else {
            node.setProperty("cmiscd:isLatestVersion", (String)null);
        }
        pbv = item.getProperty("cmis:isMajorVersion");
        if (pbv != null) {
            node.setProperty("cmiscd:isMajorVersion", ((Boolean)pbv.getFirstValue()).booleanValue());
        } else {
            node.setProperty("cmiscd:isMajorVersion", (String)null);
        }
        pbv = item.getProperty("cmis:isLatestMajorVersion");
        if (pbv != null) {
            node.setProperty("cmiscd:isLatestMajorVersion", ((Boolean)pbv.getFirstValue()).booleanValue());
        } else {
            node.setProperty("cmiscd:isLatestMajorVersion", (String)null);
        }
        org.apache.chemistry.opencmis.client.api.Property psv = item.getProperty("cmis:versionLabel");
        if (psv != null) {
            node.setProperty("cmiscd:versionLabel", (String)psv.getFirstValue());
        } else {
            node.setProperty("cmiscd:versionLabel", (String)null);
        }
        psv = item.getProperty("cmis:versionSeriesId");
        if (psv != null) {
            node.setProperty("cmiscd:versionSeriesId", (String)psv.getFirstValue());
        } else {
            node.setProperty("cmiscd:versionSeriesId", (String)null);
        }
        psv = item.getProperty("cmis:versionSeriesCheckedOutId");
        if (psv != null) {
            node.setProperty("cmiscd:versionSeriesCheckedOutId", (String)psv.getFirstValue());
        } else {
            node.setProperty("cmiscd:versionSeriesCheckedOutId", (String)null);
        }
        psv = item.getProperty("cmis:checkinComment");
        if (psv != null) {
            node.setProperty("cmiscd:checkinComment", (String)psv.getFirstValue());
        } else {
            node.setProperty("cmiscd:checkinComment", (String)null);
        }
    }

    protected void initFile(Node localNode, String title, String id, String type, String link, String previewLink, String thumbnailLink, String author, String lastUser, Calendar created, Calendar modified, long size) throws RepositoryException {
        String recommendedType = this.findMimetype(title, type);
        if (recommendedType != null && !recommendedType.equals(type)) {
            type = recommendedType;
        }
        super.initFile(localNode, title, id, type, link, previewLink, thumbnailLink, author, lastUser, created, modified, size);
    }

    protected void setChangeToken(Node localNode, String changeToken) throws RepositoryException, CMISException {
        localNode.setProperty("cmiscd:changeToken", changeToken);
    }

    protected String getChangeToken(Node localNode) throws RepositoryException, CMISException {
        return localNode.getProperty("cmiscd:changeToken").getString();
    }

    protected JCRLocalCloudFile updateItem(CMISAPI api, CmisObject item, Node parent, Node node) throws RepositoryException, CloudDriveException {
        JCRLocalCloudFile file;
        String thumbnailLink;
        String link;
        String typeMode;
        String type;
        long size;
        boolean isFolder;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> updateItem: " + item.getId() + " " + item.getName() + " " + item.getType().getDisplayName() + " (" + item.getBaseType().getDisplayName() + ", " + item.getBaseTypeId().value() + ")"));
        }
        String id = item.getId();
        String name = item.getName();
        if (api.isDocument(item)) {
            isFolder = false;
            boolean isDocument = true;
            Document document = (Document)item;
            size = document.getContentStreamLength();
            type = document.getContentStreamMimeType();
            if (type == null || type.equals(this.mimeTypes.getDefaultMimeType())) {
                type = this.mimeTypes.getMimeType(name);
            }
            typeMode = this.mimeTypes.getMimeTypeMode(type, name);
        } else {
            boolean isDocument = false;
            isFolder = api.isFolder(item);
            size = -1L;
            type = item.getType().getId();
            typeMode = null;
        }
        if (node == null) {
            node = isFolder ? this.openFolder(id, name, parent) : this.openFile(id, name, parent);
        }
        GregorianCalendar created = item.getCreationDate();
        GregorianCalendar modified = item.getLastModificationDate();
        String createdBy = item.getCreatedBy();
        String modifiedBy = item.getLastModifiedBy();
        boolean changed = node.isNew();
        if (!changed) {
            String localChangeTokenText;
            String changeTokenText = item.getChangeToken();
            try {
                localChangeTokenText = this.getChangeToken(node);
            }
            catch (PathNotFoundException e) {
                localChangeTokenText = null;
            }
            if (changeTokenText == null || localChangeTokenText == null) {
                changed = !((Calendar)modified).equals(node.getProperty("ecd:modified").getDate());
            } else {
                boolean bl = changed = !localChangeTokenText.equals(changeTokenText);
            }
        }
        if (isFolder) {
            link = api.getLink((Folder)item);
            thumbnailLink = null;
            if (changed) {
                this.initFolder(node, id, name, type, link, createdBy, modifiedBy, created, modified);
                this.initCMISItem(node, item);
            }
            file = new JCRLocalCloudFile(node.getPath(), id, name, link, type, modifiedBy, createdBy, (Calendar)created, (Calendar)modified, node, true);
        } else {
            thumbnailLink = link = api.getLink(item);
            if (changed) {
                this.initFile(node, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified, size);
                this.initCMISItem(node, item);
            }
            file = new JCRLocalCloudFile(node.getPath(), id, name, link, this.previewLink(null, node), thumbnailLink, type, typeMode, createdBy, modifiedBy, (Calendar)created, (Calendar)modified, size, node, changed);
        }
        return file;
    }

    protected String previewLink(String type, Node fileNode) throws RepositoryException {
        return ContentService.contentLink((String)this.rootWorkspace, (String)fileNode.getPath(), (String)this.fileAPI.getId(fileNode));
    }

    protected String findMimetype(Document file, String localType) {
        return this.findMimetype(file.getName(), file.getContentStreamMimeType(), localType);
    }

    protected String findMimetype(String fileName, String fileType) {
        return this.findMimetype(fileName, fileType, null);
    }

    protected String findMimetype(String fileName, String fileType, String alternativeType) {
        String defaultType = this.mimeTypes.getDefaultMimeType();
        if (fileType == null || fileType.startsWith(defaultType)) {
            String resolvedType = this.mimeTypes.getMimeType(fileName);
            fileType = resolvedType != null && !resolvedType.startsWith(defaultType) ? resolvedType : (alternativeType != null ? alternativeType : defaultType);
        }
        return fileType;
    }

    protected void ensureSame(CloudUser user, Node driveNode) throws RepositoryException, CannotConnectDriveException {
        super.ensureSame(user, driveNode);
        try {
            String serviceURL = driveNode.getProperty("cmiscd:serviceURL").getString();
            String repositoryId = driveNode.getProperty("cmiscd:repositoryId").getString();
            CMISUser cmisUser = (CMISUser)user;
            if (!repositoryId.equals(cmisUser.api().getRepositoryId())) {
                LOG.warn((Object)("Cannot connect drive. Node " + driveNode.getPath() + " was connected to another repository " + repositoryId));
                throw new CannotConnectDriveException("Node already initialized for another repository " + repositoryId);
            }
            if (!serviceURL.equals(cmisUser.api().getServiceURL())) {
                LOG.warn((Object)("Cannot connect drive. Node " + driveNode.getPath() + " was connected to another server " + serviceURL));
                throw new CannotConnectDriveException("Node already initialized by another server " + serviceURL);
            }
        }
        catch (PathNotFoundException e) {
            throw new CannotConnectDriveException("Mandatory drive property not found: " + e.getMessage());
        }
    }

    protected void readNodes(Node parent, Map<String, List<Node>> nodes, boolean deep) throws RepositoryException {
        super.readNodes(parent, nodes, deep);
        FileAPI fileAPI = (FileAPI)this.fileAPI;
        LinkedHashMap<String, List<Node>> newNodes = new LinkedHashMap<String, List<Node>>();
        for (Map.Entry<String, List<Node>> me : nodes.entrySet()) {
            for (Node lnode : me.getValue()) {
                if (fileAPI.isFile(lnode)) {
                    try {
                        String vsid = fileAPI.getVersionSeriesId(lnode);
                        newNodes.put(vsid, me.getValue());
                    }
                    catch (PathNotFoundException vsid) {
                        // empty catch block
                    }
                    try {
                        String vscoid = fileAPI.getVersionSeriesCheckedOutId(lnode);
                        newNodes.put(vscoid, me.getValue());
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        // empty catch block
                    }
                }
                newNodes.put(me.getKey(), me.getValue());
            }
        }
        nodes.clear();
        nodes.putAll(newNodes);
    }

    protected List<Node> findDocumentNode(String id, CmisObject file, Map<String, List<Node>> nodes) throws CloudDriveAccessException, CMISException, UnauthorizedException {
        List<Node> existing;
        block4: {
            Document document;
            CMISAPI api;
            existing = nodes.get(id);
            if (existing == null && (api = this.getUser().api()).isDocument(file) && (existing = nodes.get((document = (Document)file).getVersionSeriesId())) == null) {
                try {
                    Document v;
                    List<Document> versions = api.getAllVersion(document);
                    Iterator<Document> iterator = versions.iterator();
                    while (iterator.hasNext() && (existing = nodes.get((v = iterator.next()).getId())) == null) {
                    }
                }
                catch (NotFoundException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)("Remote file " + id + " (" + file.getName() + ") or its versions cannot be found. " + e.getMessage()));
                }
            }
        }
        return existing;
    }

    public ContentReader getFileContent(String fileId) throws CloudDriveException, NotFoundException, CloudDriveAccessException, DriveRemovedException, UnauthorizedException, RepositoryException {
        CmisObject item;
        CMISAPI api = this.getUser().api();
        if (api.isDocument(item = api.getObject(fileId))) {
            String fileType;
            Document document = (Document)item;
            String name = document.getName();
            String mimeType = document.getContentStreamMimeType();
            if ((mimeType == null || mimeType.startsWith(this.mimeTypes.getDefaultMimeType())) && (fileType = this.mimeTypes.getMimeType(name)) != null) {
                mimeType = fileType;
            }
            return new DocumentContent(document.getContentStream(), mimeType, name);
        }
        return null;
    }

    protected class DocumentContent
    implements ContentReader {
        protected final ContentStream content;
        protected final String type;
        protected final long length;
        protected final String fileName;

        protected DocumentContent(ContentStream content, String type, String fileName) {
            this.content = content;
            this.length = content.getLength();
            this.type = type != null ? type : content.getMimeType();
            this.fileName = fileName;
        }

        public InputStream getStream() {
            return this.content.getStream();
        }

        public String getMimeType() {
            return this.type;
        }

        public String getTypeMode() {
            return JCRLocalCMISDrive.this.mimeTypes.getMimeTypeMode(this.type, this.fileName);
        }

        public long getLength() {
            return this.length;
        }
    }

    protected class FileAPI
    extends JCRLocalCloudDrive.AbstractFileAPI {
        protected final CMISAPI api;

        protected FileAPI() {
            super((JCRLocalCloudDrive)JCRLocalCMISDrive.this);
            this.api = JCRLocalCMISDrive.this.getUser().api();
        }

        protected LocalFile context(String fileId, Node fileNode) {
            return new ContextLocalFile(fileId, fileNode);
        }

        protected String getVersionSeriesId(Node fileNode) throws PathNotFoundException, RepositoryException {
            return fileNode.getProperty("cmiscd:versionSeriesId").getString();
        }

        protected String getVersionSeriesCheckedOutId(Node node) throws PathNotFoundException, RepositoryException {
            return node.getProperty("cmiscd:versionSeriesCheckedOutId").getString();
        }

        public CloudFile createFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            String link;
            Document file;
            String parentId = this.getParentId(fileNode);
            String title = this.getTitle(fileNode);
            try {
                file = this.api.createDocument(parentId, title, mimeType, content);
            }
            catch (ConflictException e) {
                CmisObject existing = null;
                CMISAPI.ChildrenIterator files = this.api.getFolderItems(parentId);
                while (files.hasNext()) {
                    CmisObject item = (CmisObject)files.next();
                    if (!title.equals(item.getName())) continue;
                    existing = item;
                    break;
                }
                if (existing == null || !this.api.isDocument(existing)) {
                    throw e;
                }
                file = (Document)existing;
            }
            String id = file.getId();
            String name = file.getName();
            String thumbnailLink = link = this.api.getLink((CmisObject)file);
            String createdBy = file.getCreatedBy();
            String modifiedBy = file.getLastModifiedBy();
            String type = JCRLocalCMISDrive.this.findMimetype(file, mimeType);
            long size = file.getContentStreamLength();
            JCRLocalCMISDrive.this.initFile(fileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified, size);
            JCRLocalCMISDrive.this.initCMISItem(fileNode, (CmisObject)file);
            return new JCRLocalCloudFile(fileNode.getPath(), id, name, link, JCRLocalCMISDrive.this.previewLink(null, fileNode), thumbnailLink, type, JCRLocalCMISDrive.this.mimeTypes.getMimeTypeMode(type, name), modifiedBy, createdBy, created, modified, size, fileNode, true);
        }

        public CloudFile createFolder(Node folderNode, Calendar created) throws CloudDriveException, RepositoryException {
            Folder folder;
            String parentId = this.getParentId(folderNode);
            String title = this.getTitle(folderNode);
            try {
                folder = this.api.createFolder(this.getParentId(folderNode), this.getTitle(folderNode));
            }
            catch (ConflictException e) {
                CmisObject existing = null;
                CMISAPI.ChildrenIterator files = this.api.getFolderItems(parentId);
                while (files.hasNext()) {
                    CmisObject item = (CmisObject)files.next();
                    if (!title.equals(item.getName())) continue;
                    existing = item;
                    break;
                }
                if (existing == null || !this.api.isFolder(existing)) {
                    throw e;
                }
                folder = (Folder)existing;
            }
            String id = folder.getId();
            String name = folder.getName();
            String link = this.api.getLink(folder);
            String createdBy = folder.getCreatedBy();
            String modifiedBy = folder.getLastModifiedBy();
            String type = folder.getType().getId();
            JCRLocalCMISDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, created, created);
            JCRLocalCMISDrive.this.initCMISItem(folderNode, (CmisObject)folder);
            return new JCRLocalCloudFile(folderNode.getPath(), id, name, link, type, modifiedBy, createdBy, created, created, folderNode, true);
        }

        public CloudFile updateFile(Node fileNode, Calendar modified) throws CloudDriveException, RepositoryException {
            String id = this.getId(fileNode);
            CmisObject obj = this.api.updateObject(this.getParentId(fileNode), id, this.getTitle(fileNode), this.context(id, fileNode));
            if (obj != null) {
                if (this.api.isDocument(obj)) {
                    String link;
                    Document file = (Document)obj;
                    id = file.getId();
                    String name = file.getName();
                    String thumbnailLink = link = this.api.getLink((CmisObject)file);
                    String createdBy = file.getCreatedBy();
                    String modifiedBy = file.getLastModifiedBy();
                    String type = file.getContentStreamMimeType();
                    GregorianCalendar created = file.getCreationDate();
                    modified = file.getLastModificationDate();
                    long size = file.getContentStreamLength();
                    JCRLocalCMISDrive.this.initFile(fileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified, size);
                    JCRLocalCMISDrive.this.initCMISItem(fileNode, (CmisObject)file);
                    String filePath = fileNode.getPath();
                    return new JCRLocalCloudFile(filePath, id, name, link, JCRLocalCMISDrive.this.previewLink(null, fileNode), thumbnailLink, type, JCRLocalCMISDrive.this.mimeTypes.getMimeTypeMode(type, name), modifiedBy, createdBy, (Calendar)created, modified, size, fileNode, true);
                }
                throw new CMISException("Object not a document: " + id + ", " + obj.getName());
            }
            return null;
        }

        public CloudFile updateFolder(Node folderNode, Calendar modified) throws CloudDriveException, RepositoryException {
            String id = this.getId(folderNode);
            CmisObject obj = this.api.updateObject(this.getParentId(folderNode), id, this.getTitle(folderNode), this.context(id, folderNode));
            if (obj != null) {
                if (this.api.isFolder(obj)) {
                    Folder folder = (Folder)obj;
                    id = folder.getId();
                    String name = folder.getName();
                    String link = this.api.getLink(folder);
                    String createdBy = folder.getCreatedBy();
                    String modifiedBy = folder.getLastModifiedBy();
                    String type = folder.getType().getId();
                    GregorianCalendar created = folder.getCreationDate();
                    modified = folder.getLastModificationDate();
                    JCRLocalCMISDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, created, modified);
                    JCRLocalCMISDrive.this.initCMISItem(folderNode, (CmisObject)folder);
                    String folderPath = folderNode.getPath();
                    return new JCRLocalCloudFile(folderPath, id, name, link, type, modifiedBy, createdBy, (Calendar)created, modified, folderNode, true);
                }
                throw new CMISException("Object not a folder: " + id + ", " + obj.getName());
            }
            return null;
        }

        public CloudFile updateFileContent(Node fileNode, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            String link;
            String fileId = this.getId(fileNode);
            Document file = this.api.updateContent(fileId, this.getTitle(fileNode), content, mimeType, this.context(fileId, fileNode));
            String id = file.getId();
            String name = file.getName();
            String thumbnailLink = link = this.api.getLink((CmisObject)file);
            String createdBy = file.getCreatedBy();
            String modifiedBy = file.getLastModifiedBy();
            String type = file.getContentStreamMimeType();
            GregorianCalendar created = file.getCreationDate();
            modified = file.getLastModificationDate();
            long size = file.getContentStreamLength();
            JCRLocalCMISDrive.this.initFile(fileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified, size);
            JCRLocalCMISDrive.this.initCMISItem(fileNode, (CmisObject)file);
            return new JCRLocalCloudFile(fileNode.getPath(), id, name, link, JCRLocalCMISDrive.this.previewLink(null, fileNode), thumbnailLink, type, JCRLocalCMISDrive.this.mimeTypes.getMimeTypeMode(type, name), modifiedBy, createdBy, (Calendar)created, modified, size, fileNode, true);
        }

        public CloudFile copyFile(Node srcFileNode, Node destFileNode) throws CloudDriveException, RepositoryException {
            CmisObject obj;
            String parentId = this.getParentId(destFileNode);
            try {
                obj = this.api.getObject(parentId);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (this.api.isFolder(obj)) {
                Folder parent = (Folder)obj;
                String sourceId = this.getId(srcFileNode);
                try {
                    obj = this.api.getObject(sourceId);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new NotFoundException("Source not found: " + sourceId, (Throwable)e);
                }
                if (this.api.isDocument(obj)) {
                    Document source = (Document)obj;
                    return this.copyFile(source, parent, destFileNode);
                }
                throw new CMISException("Source not a document: " + sourceId + ", " + obj.getName());
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }

        protected CloudFile copyFile(Document srcFile, Folder destParent, Node destFileNode) throws CloudDriveException, RepositoryException {
            String link;
            Document file = this.api.copyDocument(srcFile, destParent, this.getTitle(destFileNode));
            String id = file.getId();
            String name = file.getName();
            String thumbnailLink = link = this.api.getLink((CmisObject)file);
            String createdBy = file.getCreatedBy();
            String modifiedBy = file.getLastModifiedBy();
            String type = file.getContentStreamMimeType();
            GregorianCalendar created = file.getCreationDate();
            GregorianCalendar modified = file.getLastModificationDate();
            long size = file.getContentStreamLength();
            JCRLocalCMISDrive.this.initFile(destFileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified, size);
            JCRLocalCMISDrive.this.initCMISItem(destFileNode, (CmisObject)file);
            return new JCRLocalCloudFile(destFileNode.getPath(), id, name, link, JCRLocalCMISDrive.this.previewLink(null, destFileNode), thumbnailLink, type, JCRLocalCMISDrive.this.mimeTypes.getMimeTypeMode(type, name), modifiedBy, createdBy, (Calendar)created, (Calendar)modified, size, destFileNode, true);
        }

        public CloudFile copyFolder(Node srcFolderNode, Node destFolderNode) throws CloudDriveException, RepositoryException {
            CmisObject obj;
            String parentId = this.getParentId(destFolderNode);
            try {
                obj = this.api.getObject(parentId);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (this.api.isFolder(obj)) {
                Folder parent = (Folder)obj;
                String sourceId = this.getId(srcFolderNode);
                try {
                    obj = this.api.getObject(sourceId);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new NotFoundException("Source not found: " + sourceId, (Throwable)e);
                }
                if (this.api.isFolder(obj)) {
                    Folder source = (Folder)obj;
                    return this.copyFolder(source, parent, destFolderNode);
                }
                throw new CMISException("Source not a folder: " + sourceId + ", " + obj.getName());
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }

        protected CloudFile copyFolder(Folder srcFolder, Folder destParent, Node destFolderNode) throws CloudDriveException, RepositoryException {
            String name = this.getTitle(destFolderNode);
            Folder folder = this.api.copyFolder(srcFolder, destParent, name);
            CMISAPI.ChildrenIterator childs = this.api.getFolderItems(srcFolder);
            while (childs.hasNext()) {
                CmisObject child = (CmisObject)childs.next();
                String childName = child.getName();
                Node fileNode = JCRLocalCMISDrive.this.readNode(destFolderNode, childName, child.getId());
                if (fileNode != null) {
                    if (this.api.isDocument(child)) {
                        this.copyFile((Document)child, folder, fileNode);
                        continue;
                    }
                    if (!(child instanceof Folder)) continue;
                    this.copyFolder((Folder)child, folder, fileNode);
                    continue;
                }
                LOG.warn((Object)("Ignoring not existing locally child node " + name + "/" + childName + " in " + destFolderNode.getPath()));
                if (this.api.isDocument(child)) {
                    this.api.copyDocument((Document)child, folder, childName);
                    continue;
                }
                if (!(child instanceof Folder)) continue;
                this.api.copyFolder((Folder)child, folder, child.getName());
            }
            String id = folder.getId();
            name = folder.getName();
            String link = this.api.getLink(folder);
            String createdBy = folder.getCreatedBy();
            String modifiedBy = folder.getLastModifiedBy();
            String type = folder.getType().getId();
            GregorianCalendar created = folder.getCreationDate();
            GregorianCalendar modified = folder.getLastModificationDate();
            JCRLocalCMISDrive.this.initFolder(destFolderNode, id, name, type, link, createdBy, modifiedBy, created, modified);
            JCRLocalCMISDrive.this.initCMISItem(destFolderNode, (CmisObject)folder);
            return new JCRLocalCloudFile(destFolderNode.getPath(), id, name, link, type, modifiedBy, createdBy, (Calendar)created, (Calendar)modified, destFolderNode, true);
        }

        public boolean removeFile(String id) throws CloudDriveException, RepositoryException {
            this.api.deleteDocument(id);
            return true;
        }

        public boolean removeFolder(String id) throws CloudDriveException, RepositoryException {
            this.api.deleteFolder(id);
            return true;
        }

        public boolean trashFile(String id) throws CloudDriveException, RepositoryException {
            throw new SyncNotSupportedException("Trash not supported");
        }

        public boolean trashFolder(String id) throws CloudDriveException, RepositoryException {
            throw new SyncNotSupportedException("Trash not supported");
        }

        public CloudFile untrashFile(Node fileNode) throws CloudDriveException, RepositoryException {
            throw new SyncNotSupportedException("Trash not supported");
        }

        public CloudFile untrashFolder(Node folderNode) throws CloudDriveException, RepositoryException {
            throw new SyncNotSupportedException("Trash not supported");
        }

        public boolean isTrashSupported() {
            return false;
        }

        private JCRLocalCloudFile restore(CmisObject obj, Node parent) throws CloudDriveException, RepositoryException {
            JCRLocalCloudFile localItem = JCRLocalCMISDrive.this.updateItem(this.api, obj, parent, null);
            Node localNode = localItem.getNode();
            if (localNode.isNew() && localItem.isFolder()) {
                CMISAPI.ChildrenIterator childs = this.api.getFolderItems(localItem.getId());
                while (childs.hasNext()) {
                    this.restore((CmisObject)childs.next(), localNode);
                }
            }
            return localItem;
        }

        public JCRLocalCloudFile restore(String id, String path) throws CloudDriveException, RepositoryException {
            JCRLocalCloudFile result = null;
            try {
                CmisObject remote = this.api.getObject(id);
                ArrayList<Folder> remoteParents = new ArrayList<Folder>(this.api.getParents(remote));
                for (Node node : JCRLocalCMISDrive.this.findNodes(Arrays.asList(id))) {
                    Node localParent = node.getParent();
                    String parentId = JCRLocalCMISDrive.this.fileAPI.getId(localParent);
                    JCRLocalCloudFile restored = null;
                    Iterator rpiter = remoteParents.iterator();
                    while (rpiter.hasNext()) {
                        Folder remoteParent = (Folder)rpiter.next();
                        String rpid = remoteParent.getId();
                        if (!parentId.equals(rpid)) continue;
                        restored = this.restore(remote, localParent);
                        rpiter.remove();
                        if (!path.equals(node.getPath())) continue;
                        result = restored;
                    }
                    if (restored != null) continue;
                    JCRLocalCMISDrive.this.removeNode(node);
                }
                for (Folder remoteParent : remoteParents) {
                    String rpid = remoteParent.getId();
                    for (Node parent : JCRLocalCMISDrive.this.findNodes(Arrays.asList(rpid))) {
                        JCRLocalCloudFile restored = this.restore(remote, parent);
                        if (result != null) continue;
                        result = restored;
                    }
                }
            }
            catch (NotFoundException e) {
                for (Node node : JCRLocalCMISDrive.this.findNodes(Arrays.asList(id))) {
                    JCRLocalCMISDrive.this.removeNode(node);
                }
            }
            return result;
        }

        protected class ContextLocalFile
        implements LocalFile {
            protected final String fileId;
            protected final Node fileNode;

            protected ContextLocalFile(String fileId, Node fileNode) {
                this.fileId = fileId;
                this.fileNode = fileNode;
            }

            @Override
            public String findRemoteParent(Set<String> remoteParents) throws CMISException {
                try {
                    Collection localParents = FileAPI.this.findParents(this.fileId);
                    for (String rpid : remoteParents) {
                        if (localParents.contains(rpid)) continue;
                        return rpid;
                    }
                }
                catch (DriveRemovedException e) {
                    throw new CMISException(e);
                }
                catch (RepositoryException e) {
                    throw new CMISException("Error finding file parents", e);
                }
                return null;
            }

            @Override
            public String findVersionSeriesId() {
                try {
                    return FileAPI.this.getVersionSeriesId(this.fileNode);
                }
                catch (PathNotFoundException e) {
                    return null;
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)("Error reading local version series id: " + e.getMessage()));
                    return null;
                }
            }

            @Override
            public String findVersionSeriesCheckedOutId() {
                try {
                    return FileAPI.this.getVersionSeriesCheckedOutId(this.fileNode);
                }
                catch (PathNotFoundException e) {
                    return null;
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)("Error reading local version series checked-out id: " + e.getMessage()));
                    return null;
                }
            }

            @Override
            @Deprecated
            public void markMoved(String prevParentId) {
                try {
                    this.fileNode.setProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_PARENT, prevParentId);
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)("Error storing cmiscd:previousLocalParent : " + e.getMessage()));
                }
            }

            @Override
            public void markRenamed(String prevName) {
                try {
                    this.fileNode.setProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_NAME, prevName);
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)("Error storing cmiscd:previousLocalName : " + e.getMessage()));
                }
            }
        }
    }

    public static interface LocalFile {
        public String findRemoteParent(Set<String> var1) throws CMISException;

        public String findVersionSeriesId();

        public String findVersionSeriesCheckedOutId();

        @Deprecated
        public void markMoved(String var1);

        public void markRenamed(String var1);
    }

    protected class Sync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final CMISAPI api;
        protected CloudDriveException preSyncError;
        protected ChangesAlgorithm changesLog;

        protected Sync() {
            super((JCRLocalCloudDrive)JCRLocalCMISDrive.this);
            this.preSyncError = null;
            this.api = JCRLocalCMISDrive.this.getUser().api();
        }

        protected void preSyncFiles() throws CloudDriveException, RepositoryException, InterruptedException {
            try {
                super.preSyncFiles();
            }
            catch (CMISException e) {
                this.preSyncError = e;
                JCRLocalCMISDrive.this.rollback(this.driveNode);
                LOG.warn((Object)("Synchronization error: failed to apply local changes to CMIS repository. Full sync will be initiated for " + JCRLocalCMISDrive.this.title()), (Throwable)((Object)e));
            }
            catch (NotFoundException e) {
                this.preSyncError = e;
                JCRLocalCMISDrive.this.rollback(this.driveNode);
                LOG.warn((Object)("Synchronization error: local changes inconsistent with CMIS repository. Full sync will be initiated for " + JCRLocalCMISDrive.this.title()), (Throwable)e);
            }
        }

        protected void syncFiles() throws CloudDriveException, RepositoryException, InterruptedException {
            long changeId;
            CMISAPI.ChangeToken lastChangeToken;
            CMISAPI.ChangeToken localChangeToken;
            CMISAPI.ChangeToken changeToken;
            block10: {
                RepositoryInfo repoInfo = this.api.getRepositoryInfo();
                this.changesLog = null;
                changeToken = this.api.readToken(repoInfo.getLatestChangeLogToken());
                localChangeToken = this.api.readToken(JCRLocalCMISDrive.this.getChangeToken(this.driveNode));
                lastChangeToken = this.api.emptyToken();
                changeId = System.currentTimeMillis();
                if (!changeToken.isEmpty() && this.preSyncError == null) {
                    if (!changeToken.equals(localChangeToken)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("> Syncing changes from " + localChangeToken + " to " + changeToken));
                        }
                        try {
                            if (CapabilityChanges.NONE != repoInfo.getCapabilities().getChangesCapability()) {
                                this.changesLog = new ChangesAlgorithm();
                                this.changesLog.syncFiles(localChangeToken);
                                lastChangeToken = this.changesLog.getLastChangeToken();
                                break block10;
                            }
                            LOG.info((Object)("CMIS Change Log capability not supported by repository " + repoInfo.getName() + " (" + repoInfo.getVendorName() + " " + repoInfo.getProductName() + " " + repoInfo.getProductVersion() + "). Full synchronization will be used instead of the more efficient based on Change Log. Check if it is possible to enable Change Log for your repository."));
                        }
                        catch (CMISException e) {
                            LOG.warn((Object)("Synchronization error: failed to read CMIS Change Log. Full sync will be initiated for " + JCRLocalCMISDrive.this.title()), (Throwable)((Object)e));
                            JCRLocalCMISDrive.this.rollback(this.driveNode);
                        }
                    } else {
                        return;
                    }
                }
            }
            if (!lastChangeToken.isEmpty() && this.preSyncError == null) {
                changeToken = lastChangeToken;
            } else {
                LOG.info((Object)("Full synchronization initiated instead of the more efficient based on CMIS Change Log: " + JCRLocalCMISDrive.this.title()));
                new TraversingAlgorithm().syncFiles();
            }
            JCRLocalCMISDrive.this.setChangeToken(this.driveNode, changeToken.getString());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Synced changes from " + localChangeToken + " to " + lastChangeToken));
            }
            JCRLocalCMISDrive.this.setChangeId(changeId);
        }

        protected void preSaveChunk() throws CloudDriveException, RepositoryException {
            CMISAPI.ChangeToken lastChangeToken;
            if (this.changesLog != null && !(lastChangeToken = this.changesLog.getLastChangeToken()).isEmpty()) {
                JCRLocalCMISDrive.this.setChangeToken(this.driveNode, lastChangeToken.getString());
            }
        }

        protected boolean wasRenamed(Node fileNode, String changeName) throws RepositoryException {
            if (fileNode.hasProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_NAME)) {
                try {
                    return fileNode.getProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_NAME).getString().equals(changeName);
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)("Error reading cmiscd:previousLocalName property of " + fileNode));
                }
            }
            return false;
        }

        protected void cleanRenamed(Node fileNode, String fileName) throws RepositoryException {
            if (fileNode.hasProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_NAME)) {
                try {
                    Property pln = fileNode.getProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_NAME);
                    if (!pln.getString().equals(fileName)) {
                        pln.remove();
                    }
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)("Error cleaning cmiscd:previousLocalName property of " + fileNode));
                }
            }
        }

        @Deprecated
        protected boolean wasMoved(Node fileNode, String changeParentId) throws RepositoryException {
            if (fileNode.hasProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_PARENT)) {
                try {
                    return fileNode.getProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_PARENT).getString().equals(changeParentId);
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)("Error reading cmiscd:previousLocalParent property of " + fileNode));
                }
            }
            return false;
        }

        @Deprecated
        protected void cleanMoved(Node fileNode, String parentId) throws RepositoryException {
            if (fileNode.hasProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_PARENT)) {
                try {
                    Property ppp = fileNode.getProperty(JCRLocalCMISDrive.PREVIOUS_LOCAL_PARENT);
                    if (!ppp.getString().equals(parentId)) {
                        ppp.remove();
                    }
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)("Error cleaning cmiscd:previousLocalParent property of " + fileNode));
                }
            }
        }

        protected class TraversingAlgorithm {
            protected final Map<String, List<Node>> allLocal = new HashMap<String, List<Node>>();
            protected final Queue<CMISItem> allItems = new ConcurrentLinkedQueue<CMISItem>();
            protected final Queue<Future<Folder>> readers = new ConcurrentLinkedQueue<Future<Folder>>();

            protected TraversingAlgorithm() {
            }

            protected Future<Folder> readItems(String folderId) throws RepositoryException, CloudDriveException {
                Future reader = JCRLocalCMISDrive.this.workerExecutor.submit((Callable)new FolderReader(folderId));
                this.readers.add(reader);
                return reader;
            }

            protected void syncFiles() throws RepositoryException, CloudDriveException, InterruptedException {
                Sync.this.readLocalNodes();
                for (Map.Entry ne : Sync.this.nodes.entrySet()) {
                    this.allLocal.put((String)ne.getKey(), new ArrayList((Collection)ne.getValue()));
                }
                Folder root = this.syncChilds(Sync.this.api.getRootFolder().getId());
                Sync.this.nodes.remove(root.getId());
                boolean notInterrupted = true;
                Iterator niter = Sync.this.nodes.values().iterator();
                while (niter.hasNext() && (notInterrupted = !Thread.currentThread().isInterrupted())) {
                    List nls = (List)niter.next();
                    block2: for (Node n : nls) {
                        String npath = n.getPath();
                        for (String rpath : Sync.this.getRemoved()) {
                            if (!npath.startsWith(rpath)) continue;
                            continue block2;
                        }
                        JCRLocalCMISDrive.this.removeNode(n);
                        Sync.this.addRemoved(npath);
                    }
                }
                if (notInterrupted) {
                    JCRLocalCMISDrive.this.initCMISItem(Sync.this.driveNode, (CmisObject)root);
                    JCRLocalCMISDrive.this.rollbackAllChanges();
                }
                this.allLocal.clear();
                this.allItems.clear();
                this.readers.clear();
            }

            protected boolean isReadDone() {
                Iterator riter = this.readers.iterator();
                while (riter.hasNext()) {
                    Future r = (Future)riter.next();
                    if (r.isDone()) {
                        riter.remove();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            protected Folder syncChilds(String folderId) throws RepositoryException, CloudDriveException, InterruptedException {
                CMISItem item;
                Future<Folder> reader = this.readItems(folderId);
                while (!((item = this.allItems.poll()) == null && this.isReadDone() || Thread.currentThread().isInterrupted())) {
                    if (item != null) {
                        CmisObject obj = item.object;
                        List<Node> parentList = this.allLocal.get(item.parentId);
                        if (parentList != null) {
                            for (Node parent : parentList) {
                                JCRLocalCloudFile localItem = JCRLocalCMISDrive.this.updateItem(Sync.this.api, obj, parent, null);
                                if (localItem.isChanged()) {
                                    Sync.this.addChanged((CloudFile)localItem);
                                    List<Node> itemList = this.allLocal.get(localItem.getId());
                                    if (itemList == null) {
                                        itemList = new ArrayList<Node>();
                                        this.allLocal.put(localItem.getId(), itemList);
                                    }
                                    itemList.add(localItem.getNode());
                                }
                                String fileId = obj.getId();
                                List existing = (List)Sync.this.nodes.get(fileId);
                                if (existing == null) continue;
                                String path = localItem.getPath();
                                Iterator eiter = existing.iterator();
                                while (eiter.hasNext()) {
                                    Node enode = (Node)eiter.next();
                                    if (!enode.getPath().startsWith(path)) continue;
                                    eiter.remove();
                                }
                                if (existing.size() != 0) continue;
                                Sync.this.nodes.remove(fileId);
                            }
                            continue;
                        }
                        if (item.isPostponed()) {
                            throw new CloudDriveException("Inconsistency error: parent cannot be found for remote file " + obj.getName());
                        }
                        this.allItems.add(item);
                        item.postpone();
                        continue;
                    }
                    Thread.yield();
                    Thread.sleep(50L);
                }
                try {
                    return reader.get();
                }
                catch (ExecutionException e) {
                    LOG.error((Object)("Sync worker error: " + e.getMessage()));
                    Throwable c = e.getCause();
                    if (c != null) {
                        if (c instanceof CloudDriveException) {
                            throw (CloudDriveException)c;
                        }
                        if (c instanceof RepositoryException) {
                            throw (RepositoryException)c;
                        }
                        if (c instanceof RuntimeException) {
                            throw (RuntimeException)c;
                        }
                        if (c instanceof Error) {
                            throw (Error)c;
                        }
                        throw new CMISException("Error in sync worker thread", c);
                    }
                    throw new CMISException("Execution error in sync worker thread", e);
                }
            }

            protected class FolderReader
            implements Callable<Folder> {
                protected final String folderId;

                protected FolderReader(String folderId) {
                    this.folderId = folderId;
                }

                @Override
                public Folder call() throws Exception {
                    CMISAPI.ChildrenIterator items = Sync.this.api.getFolderItems(this.folderId);
                    Sync.this.iterators.add(items);
                    while (items.hasNext() && !Thread.currentThread().isInterrupted()) {
                        CmisObject obj = (CmisObject)items.next();
                        if (Sync.this.api.isRelationship(obj)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)("Skipped relationship object: " + obj.getId() + " " + obj.getName()));
                            continue;
                        }
                        TraversingAlgorithm.this.allItems.add(new CMISItem(obj, this.folderId));
                        if (!Sync.this.api.isFolder(obj)) continue;
                        TraversingAlgorithm.this.readItems(obj.getId());
                    }
                    return items.parent;
                }
            }

            protected class CMISItem {
                protected final CmisObject object;
                protected final String parentId;
                private boolean postponed;

                protected CMISItem(CmisObject object, String parentId) {
                    this.object = object;
                    this.parentId = parentId;
                }

                void postpone() {
                    this.postponed = true;
                }

                boolean isPostponed() {
                    return this.postponed;
                }
            }
        }

        protected class ChangesAlgorithm {
            protected CMISAPI.ChangesIterator changes;

            protected ChangesAlgorithm() {
            }

            protected CMISAPI.ChangeToken getLastChangeToken() {
                CMISAPI.ChangeToken lastToken = this.changes.getLastChangeToken();
                return lastToken != null ? lastToken : Sync.this.api.emptyToken();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void syncFiles(CMISAPI.ChangeToken fromChangeToken) throws CloudDriveException, RepositoryException {
                this.changes = Sync.this.api.getChanges(fromChangeToken);
                Sync.this.iterators.add(this.changes);
                if (this.changes.hasNext()) {
                    Sync.this.readLocalNodes();
                    CmisObject previousItem = null;
                    ChangeEvent previousEvent = null;
                    LinkedHashSet<String> previousParentIds = null;
                    boolean skipFirst = true;
                    while (this.changes.hasNext() && !Thread.currentThread().isInterrupted()) {
                        ChangeEvent change = this.changes.next();
                        CMISAPI.ChangeToken lastToken = this.changes.getLastChangeToken();
                        if (skipFirst && fromChangeToken.equals(lastToken)) {
                            skipFirst = false;
                            continue;
                        }
                        CmisObject item = null;
                        LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
                        ChangeType changeType = change.getChangeType();
                        String id = change.getObjectId();
                        if (Sync.this.api.isSyncableChange(change)) {
                            block24: {
                                if (!ChangeType.DELETED.equals((Object)changeType)) {
                                    try {
                                        item = Sync.this.api.getObject(change.getObjectId());
                                    }
                                    catch (NotFoundException e) {
                                        if (!LOG.isDebugEnabled()) break block24;
                                        LOG.debug((Object)("File " + changeType.value() + " " + id + " not found remotely - apply DELETED logic."), (Throwable)e);
                                    }
                                }
                            }
                            if (item == null) {
                                if (JCRLocalCMISDrive.this.hasRemoved(id)) {
                                    JCRLocalCMISDrive.this.cleanRemoved(id);
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)(">> Returned file removal (" + changeType.value() + ") " + id));
                                    }
                                } else if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> File removal (" + changeType.value() + ") " + id));
                                }
                                this.deleteFile(id, new HashSet<String>());
                            } else {
                                boolean isFolder;
                                String remoteName;
                                block25: {
                                    remoteName = item.getName();
                                    isFolder = Sync.this.api.isFolder(item);
                                    if (isFolder) {
                                        Folder p = ((Folder)item).getFolderParent();
                                        if (p != null) {
                                            parentIds.add(p.getId());
                                            break block25;
                                        } else {
                                            if (!LOG.isDebugEnabled()) continue;
                                            LOG.debug((Object)("Found change of folder without parent. Skipping it: " + id + " " + remoteName));
                                            continue;
                                        }
                                    }
                                    if (Sync.this.api.isRelationship(item)) {
                                        if (!LOG.isDebugEnabled()) continue;
                                        LOG.debug((Object)("Found change of relationship. Skipping it: " + id + " " + remoteName));
                                        continue;
                                    }
                                    List ps = ((FileableCmisObject)item).getParents(Sync.this.api.folderContext);
                                    if (ps.size() == 0) {
                                        if (!LOG.isDebugEnabled()) continue;
                                        LOG.debug((Object)("Found change of fileable item without parent. Skipping it: " + id + " " + remoteName));
                                        continue;
                                    }
                                    for (Folder p : ps) {
                                        parentIds.add(p.getId());
                                    }
                                }
                                if (JCRLocalCMISDrive.this.hasUpdated(id)) {
                                    JCRLocalCMISDrive.this.cleanUpdated(id);
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)(">> Returned file update (" + changeType.value() + ") " + id + " " + remoteName));
                                    }
                                } else if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> File update (" + changeType.value() + ") " + id + " " + remoteName));
                                }
                                if (Sync.this.api.getVendorName().indexOf("Nuxeo") >= 0 && previousItem != null && remoteName.equals(previousItem.getName()) && previousEvent != null && ChangeType.CREATED.equals((Object)previousEvent.getChangeType()) && ChangeType.CREATED.equals((Object)changeType) && previousParentIds != null && parentIds.containsAll(previousParentIds)) {
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug((Object)(">> Skipping file update (" + changeType.value() + ") " + id + " " + remoteName));
                                    continue;
                                }
                                this.updateFile(item, parentIds, isFolder);
                            }
                        }
                        previousItem = item;
                        previousEvent = change;
                        previousParentIds = parentIds;
                    }
                }
            }

            protected void deleteFile(String fileId, Set<String> parentIds) throws RepositoryException, CloudDriveException {
                List existing = (List)Sync.this.nodes.get(fileId);
                if (existing != null) {
                    for (Node en : existing) {
                        Node ep = en.getParent();
                        if (JCRLocalCMISDrive.this.fileAPI.isFolder(ep) || JCRLocalCMISDrive.this.fileAPI.isDrive(ep)) {
                            String parentId = JCRLocalCMISDrive.this.fileAPI.getId(ep);
                            if (parentIds.contains(parentId)) continue;
                            Sync.this.removeLocalNode(en);
                            continue;
                        }
                        LOG.warn((Object)("Skipped node with not cloud folder/drive parent: " + en.getPath()));
                    }
                    if (existing.size() == 0) {
                        existing.remove(fileId);
                    }
                }
            }

            protected void updateFile(CmisObject file, Set<String> parentIds, boolean isFolder) throws CloudDriveException, RepositoryException {
                String id = file.getId();
                String name = file.getName();
                List<Node> existing = JCRLocalCMISDrive.this.findDocumentNode(id, file, Sync.this.nodes);
                HashSet<Node> synced = new HashSet<Node>();
                for (String pid : parentIds) {
                    List fileParents = (List)Sync.this.nodes.get(pid);
                    if (fileParents == null) {
                        throw new CMISException("Inconsistent changes: cannot find parent Node for " + id + " '" + name + "'");
                    }
                    for (Node fp : fileParents) {
                        JCRLocalCloudFile localFile;
                        Node localNode = null;
                        Node localNodeOther = null;
                        if (existing == null) {
                            existing = new ArrayList<Node>();
                            Sync.this.nodes.put(id, existing);
                        } else {
                            for (Node n : existing) {
                                if (n.getParent().isSame((Item)fp)) {
                                    localNode = n;
                                    continue;
                                }
                                if (localNodeOther != null) continue;
                                localNodeOther = n;
                            }
                        }
                        if (localNode == null) {
                            if (isFolder && localNodeOther != null) {
                                localNode = JCRLocalCMISDrive.this.copyFile(localNodeOther, fp);
                            }
                            localFile = JCRLocalCMISDrive.this.updateItem(Sync.this.api, file, fp, localNode);
                            Sync.this.addChanged((CloudFile)localFile);
                            localNode = localFile.getNode();
                            existing.add(localNode);
                        } else if (!JCRLocalCMISDrive.this.fileAPI.getTitle(localNode).equals(name) && !Sync.this.wasRenamed(localNode, name)) {
                            localFile = JCRLocalCMISDrive.this.updateItem(Sync.this.api, file, fp, JCRLocalCMISDrive.this.moveFile(id, name, localNode, fp));
                            Sync.this.addChanged((CloudFile)localFile);
                            localNode = localFile.getNode();
                        } else {
                            localFile = JCRLocalCMISDrive.this.updateItem(Sync.this.api, file, fp, localNode);
                            if (localFile.isChanged()) {
                                Sync.this.addChanged((CloudFile)localFile);
                            }
                            localNode = localFile.getNode();
                        }
                        Sync.this.cleanRenamed(localNode, name);
                        Sync.this.cleanMoved(localNode, pid);
                        synced.add(localNode);
                    }
                }
                if (existing != null) {
                    for (Node n : existing) {
                        if (synced.contains(n)) continue;
                        Sync.this.removeLocalNode(n);
                    }
                }
            }
        }
    }

    protected class Connect
    extends JCRLocalCloudDrive.ConnectCommand {
        protected final CMISAPI api;

        protected Connect() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalCMISDrive.this);
            this.api = JCRLocalCMISDrive.this.getUser().api();
        }

        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            CMISAPI.ChangeToken changeToken = this.api.readToken(this.api.getRepositoryInfo().getLatestChangeLogToken());
            long changeId = System.currentTimeMillis();
            Folder root = this.api.getRootFolder();
            this.driveNode.setProperty("ecd:id", root.getId());
            this.driveNode.setProperty("ecd:url", this.api.getLink(root));
            this.fetchChilds(root.getId(), this.driveNode);
            if (!Thread.currentThread().isInterrupted()) {
                JCRLocalCMISDrive.this.initCMISItem(this.driveNode, (CmisObject)root);
                JCRLocalCMISDrive.this.setChangeToken(this.driveNode, changeToken.getString());
                JCRLocalCMISDrive.this.setChangeId(changeId);
            }
        }

        protected Folder fetchChilds(String fileId, Node parent) throws CloudDriveException, RepositoryException {
            CMISAPI.ChildrenIterator items = this.api.getFolderItems(fileId);
            this.iterators.add(items);
            while (items.hasNext() && !Thread.currentThread().isInterrupted()) {
                CmisObject item = (CmisObject)items.next();
                if (this.api.isRelationship(item)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Skipped relationship object: " + item.getId() + " " + item.getName()));
                    continue;
                }
                if (this.isConnected(fileId, item.getId())) continue;
                JCRLocalCloudFile localItem = JCRLocalCMISDrive.this.updateItem(this.api, item, parent, null);
                if (localItem.isChanged()) {
                    this.addConnected(fileId, (CloudFile)localItem);
                    if (!localItem.isFolder()) continue;
                    this.fetchChilds(localItem.getId(), localItem.getNode());
                    continue;
                }
                throw new CMISException("Fetched item was not added to local drive storage");
            }
            return items.parent;
        }
    }
}

