/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.action;

import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveManager;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.ecms.CloudDriveContext;
import org.exoplatform.clouddrive.ecms.action.CloudFileActionException;
import org.exoplatform.clouddrive.ecms.action.CloudFileActionService;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CloudFileAction {
    protected static final Log LOG = ExoLogger.getLogger(CloudFileAction.class);
    protected final String[] emptyParams = new String[0];
    protected final UIJCRExplorer uiExplorer;
    protected final Set<Node> srcNodes = new LinkedHashSet<Node>();
    protected String destWorkspace;
    protected String destPath;
    protected Node destNode;
    protected Node link;
    protected boolean move;

    public CloudFileAction(UIJCRExplorer uiExplorer) {
        this.uiExplorer = uiExplorer;
    }

    public CloudFileAction addSource(Node srcNode) {
        this.srcNodes.add(srcNode);
        return this;
    }

    public CloudFileAction addSource(String srcInfo) throws Exception {
        return this.addSource(this.getNodeByInfo(srcInfo, false));
    }

    public CloudFileAction addSource(String srcWorkspace, String srcPath) throws Exception {
        return this.addSource(this.getNodeByPath(srcWorkspace, srcPath, false));
    }

    public CloudFileAction setDestination(Node destNode) throws Exception {
        this.destWorkspace = destNode.getSession().getWorkspace().getName();
        this.destNode = this.getNodeByPath(this.destWorkspace, destNode.getPath(), true);
        this.destPath = this.destNode.getPath();
        return this;
    }

    public CloudFileAction setDestination(String destInfo) throws Exception {
        return this.setDestination(this.getNodeByInfo(destInfo, true));
    }

    public CloudFileAction move() {
        this.move = true;
        return this;
    }

    public Node getLink() {
        return this.link;
    }

    public String getDestinationWorkspace() {
        return this.destWorkspace;
    }

    public String getDestonationPath() {
        return this.destPath;
    }

    public Node getDestinationNode() {
        return this.destNode;
    }

    public void rollback() throws RepositoryException {
        this.destNode.getSession().refresh(false);
    }

    public boolean apply() throws CloudFileActionException, Exception {
        if (this.destWorkspace != null) {
            if (PermissionUtil.canAddNode((Node)this.destNode) && !this.uiExplorer.nodeIsLocked(this.destNode) && this.destNode.isCheckedOut()) {
                if (this.srcNodes.size() > 0) {
                    Space destSpace = null;
                    String groupId = null;
                    CloudFileActionService actions = (CloudFileActionService)WCMCoreUtils.getService(CloudFileActionService.class);
                    DriveData documentsDrive = this.uiExplorer.getDriveData();
                    if (documentsDrive != null && actions.isGroupDrive(documentsDrive)) {
                        groupId = documentsDrive.getName().replace('.', '/');
                        SpaceService spaces = (SpaceService)WCMCoreUtils.getService(SpaceService.class);
                        destSpace = spaces.getSpaceByGroupId(groupId);
                    }
                    CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
                    LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
                    CloudDrive destLocal = driveService.findDrive(this.destNode);
                    int linksCreated = 0;
                    for (Node srcNode : this.srcNodes) {
                        CloudDrive srcLocal = driveService.findDrive(srcNode);
                        String srcPath = srcNode.getPath();
                        if (!this.destPath.startsWith(srcPath) && srcLocal != null && srcLocal.isDrive(srcNode)) {
                            throw new CloudFileActionException("Copy or move of cloud drive not supported: " + srcPath + " to " + this.destPath, new ApplicationMessage("CloudFile.msg.CloudDriveCopyMoveNotSupported", null, 1));
                        }
                        if (destLocal == null) {
                            if (srcLocal == null || linkManager.isLink((Item)srcNode)) continue;
                            if (this.move) {
                                if (!srcLocal.hasFile(srcPath)) continue;
                                throw new CloudFileActionException("Move of cloud file to outside the cloud drive not supported: " + srcPath + " -> " + this.destPath, new ApplicationMessage("CloudFile.msg.MoveToOutsideDriveNotSupported", null, 1));
                            }
                            String srcWorkspace = srcNode.getSession().getWorkspace().getName();
                            if (srcWorkspace.equals(this.destWorkspace)) {
                                if (groupId != null) {
                                    String[] driveIdentity = documentsDrive.getAllPermissions();
                                    actions.shareCloudFile(srcNode, srcLocal, driveIdentity);
                                    this.link = actions.linkFile(srcNode, this.destNode, groupId);
                                    actions.setAllPermissions(this.link, driveIdentity);
                                } else {
                                    this.link = actions.linkFile(srcNode, this.destNode, null);
                                }
                                actions.postSharedActivity(srcNode, this.link, "");
                                ++linksCreated;
                                continue;
                            }
                            throw new CloudFileActionException("Linking between workspaces not supported for Cloud Drive files. " + srcWorkspace + ":" + srcPath + " -> " + this.destWorkspace + ":" + this.destPath, new ApplicationMessage("CloudFile.msg.MoveBetweenWorkspacesNotSupported", null, 1));
                        }
                        if (srcLocal == null) continue;
                        if (srcLocal.equals(destLocal)) {
                            if (this.move) continue;
                            new CloudDriveManager(destLocal).initCopy(srcNode, this.destNode);
                            continue;
                        }
                        throw new CloudFileActionException("Copy or move of cloud file to another cloud drive not supported: " + srcPath + " -> " + this.destPath, new ApplicationMessage("CloudFile.msg.MoveToAnotherDriveNotSupported", null, 1));
                    }
                    if (linksCreated > 0) {
                        RequestContext rcontext = WebuiRequestContext.getCurrentInstance();
                        if (rcontext != null) {
                            ApplicationMessage text;
                            String multiple = linksCreated > 1 ? "s" : "";
                            String destName = actions.documentName(this.destNode);
                            ApplicationMessage title = new ApplicationMessage("CloudFile.msg.LinkCreated", (Object[])new String[]{multiple});
                            if (destSpace != null) {
                                text = new ApplicationMessage("CloudFile.msg.FileLinksSharedInSpace", (Object[])new String[]{multiple, destName, destSpace.getDisplayName()});
                            } else if (groupId != null) {
                                OrganizationService orgService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
                                Group group = orgService.getGroupHandler().findGroupById(groupId);
                                text = new ApplicationMessage("CloudFile.msg.FileLinksSharedInGroup", (Object[])new String[]{multiple, destName, group.getGroupName()});
                            } else {
                                text = new ApplicationMessage("CloudFile.msg.FileLinksCreated", (Object[])new String[]{multiple, destName});
                            }
                            ResourceBundle res = rcontext.getApplicationResourceBundle();
                            title.setResourceBundle(res);
                            text.setResourceBundle(res);
                            CloudDriveContext.showInfo(rcontext, title.getMessage(), text.getMessage());
                        }
                        this.destNode.getSession().save();
                        return true;
                    }
                    return false;
                }
                throw new CloudFileActionException("Source should be defined.", new ApplicationMessage("CloudFile.msg.SourceNotDefined", (Object[])this.emptyParams));
            }
            throw new CloudFileActionException("Destination not writtable.", new ApplicationMessage("CloudFile.msg.DestinationNotWrittable", (Object[])this.emptyParams));
        }
        throw new CloudFileActionException("Destination should be defined.", new ApplicationMessage("CloudFile.msg.DestinationNotDefined", (Object[])this.emptyParams));
    }

    protected Node getNodeByInfo(String pathInfo, boolean giveTarget) throws Exception {
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(pathInfo);
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + pathInfo + "'");
        }
        String workspace = matcher.group(1);
        String path = matcher.group(2);
        return this.getNodeByPath(workspace, path, giveTarget);
    }

    protected Node getNodeByPath(String workspace, String path, boolean giveTarget) throws Exception {
        Session srcSession = this.uiExplorer.getSessionByWorkspace(workspace);
        return this.uiExplorer.getNodeByPath(path, srcSession, giveTarget);
    }
}

