/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.search.lucene.search.UUIDFieldSelector;
import org.xcmis.spi.utils.Logger;

public class ChildTraversingQueryNode
extends Query {
    private static final long serialVersionUID = 7265002058181097050L;
    private static final Logger log = Logger.getLogger(ChildTraversingQueryNode.class);
    private final Query parentQuery;
    private final boolean isDeep;
    private final boolean isIncludeParent;

    public ChildTraversingQueryNode(Query parentQuery, boolean isDeep) {
        this.parentQuery = parentQuery;
        this.isDeep = isDeep;
        this.isIncludeParent = false;
    }

    private ChildTraversingQueryNode(Query parentQuery, boolean isDeep, boolean isIncludeParent) {
        this.parentQuery = parentQuery;
        this.isDeep = isDeep;
        this.isIncludeParent = isIncludeParent;
    }

    public void extractTerms(Set terms) {
        this.parentQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query newParentQuery = this.parentQuery.rewrite(reader);
        if (newParentQuery.equals((Object)this.parentQuery)) {
            return this;
        }
        return new ChildTraversingQueryNode(newParentQuery, this.isDeep);
    }

    public String toString() {
        return "(ChildTraversingQueryNode:" + this.parentQuery + "isDeep" + this.isDeep + ")";
    }

    public String toString(String field) {
        return "(ChildTraversingQueryNode:" + this.parentQuery + "isDeep" + this.isDeep + ")";
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new ChildTraversingQueryNodeWeight(searcher);
    }

    private class ChildTraversingQueryNodeWeight
    extends Weight {
        private static final long serialVersionUID = -6839886829560442055L;
        private final Searcher searcher;

        public ChildTraversingQueryNodeWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }

        public Query getQuery() {
            return ChildTraversingQueryNode.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer parentScorer = ChildTraversingQueryNode.this.parentQuery.createWeight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            return new ChildTraversingQueryNodeScorer(this.searcher, parentScorer, reader, scoreDocsInOrder, topScorer);
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }
    }

    private class ChildTraversingQueryNodeScorer
    extends Scorer {
        private Searcher searcher;
        private Scorer parentScorer;
        private IndexReader reader;
        private Scorer childScorer;
        private boolean scoreDocsInOrder;
        private boolean topScorer;

        public ChildTraversingQueryNodeScorer(Searcher searcher, Scorer parentScorer, IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) {
            super(searcher.getSimilarity());
            this.searcher = searcher;
            this.parentScorer = parentScorer;
            this.reader = reader;
            this.scoreDocsInOrder = scoreDocsInOrder;
            this.topScorer = topScorer;
        }

        public int docID() {
            return this.childScorer.docID();
        }

        public int nextDoc() throws IOException {
            if (this.childScorer == null) {
                if (this.parentScorer == null || this.parentScorer.nextDoc() == Integer.MAX_VALUE) {
                    if (log.isDebugEnabled()) {
                        log.debug("Childs not found");
                    }
                    return Integer.MAX_VALUE;
                }
                this.reloadChildScorer();
            }
            return this.childScorer.nextDoc();
        }

        public float score() throws IOException {
            return this.childScorer.score();
        }

        public int advance(int target) throws IOException {
            return this.childScorer.advance(target);
        }

        private Query createOrQuery(Query first, Query second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            BooleanQuery bq = new BooleanQuery();
            bq.add(first, BooleanClause.Occur.SHOULD);
            bq.add(second, BooleanClause.Occur.SHOULD);
            return bq;
        }

        private void reloadChildScorer() throws CorruptIndexException, IOException {
            Query childQuery = null;
            do {
                int parentDoc = this.parentScorer.docID();
                Document parentDocument = this.reader.document(parentDoc, (FieldSelector)new UUIDFieldSelector());
                TermQuery parentTermQuery = new TermQuery(new Term(FieldNames.PARENT, parentDocument.get(FieldNames.UUID)));
                if (ChildTraversingQueryNode.this.isDeep) {
                    childQuery = this.createOrQuery(childQuery, new ChildTraversingQueryNode((Query)parentTermQuery, true, true));
                    if (!ChildTraversingQueryNode.this.isIncludeParent) continue;
                    childQuery = this.createOrQuery(childQuery, (Query)new TermQuery(new Term(FieldNames.UUID, parentDocument.get(FieldNames.UUID))));
                    continue;
                }
                childQuery = this.createOrQuery(childQuery, (Query)parentTermQuery);
            } while (this.parentScorer.nextDoc() < Integer.MAX_VALUE);
            if (log.isDebugEnabled()) {
                log.debug("Sub query " + childQuery);
            }
            this.childScorer = childQuery.createWeight(this.searcher).scorer(this.reader, this.scoreDocsInOrder, this.topScorer);
        }
    }
}

