/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.regex.RegexCapabilities;
import org.apache.lucene.search.regex.RegexQuery;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.Version;
import org.xcmis.search.InvalidQueryException;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.antlr.FullTextLexer;
import org.xcmis.search.antlr.FullTextParser;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.lucene.content.ErrorReporterImpl;
import org.xcmis.search.lucene.index.ExtendedNumberTools;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.search.CaseInsensitiveRangeQuery;
import org.xcmis.search.lucene.search.CaseInsensitiveRegexCapImpl;
import org.xcmis.search.lucene.search.CaseInsensitiveTermQuery;
import org.xcmis.search.lucene.search.ChildTraversingQueryNode;
import org.xcmis.search.lucene.search.DescendantQueryNode;
import org.xcmis.search.model.Limit;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.constraint.And;
import org.xcmis.search.model.constraint.ChildNode;
import org.xcmis.search.model.constraint.Comparison;
import org.xcmis.search.model.constraint.DescendantNode;
import org.xcmis.search.model.constraint.FullTextSearch;
import org.xcmis.search.model.constraint.Not;
import org.xcmis.search.model.constraint.Operator;
import org.xcmis.search.model.constraint.Or;
import org.xcmis.search.model.constraint.PropertyExistence;
import org.xcmis.search.model.constraint.SameNode;
import org.xcmis.search.model.operand.BindVariableName;
import org.xcmis.search.model.operand.FullTextSearchScore;
import org.xcmis.search.model.operand.Length;
import org.xcmis.search.model.operand.Literal;
import org.xcmis.search.model.operand.LowerCase;
import org.xcmis.search.model.operand.NodeDepth;
import org.xcmis.search.model.operand.NodeLocalName;
import org.xcmis.search.model.operand.NodeName;
import org.xcmis.search.model.operand.PropertyValue;
import org.xcmis.search.model.operand.UpperCase;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.model.source.Join;
import org.xcmis.search.model.source.Selector;
import org.xcmis.search.model.source.join.ChildNodeJoinCondition;
import org.xcmis.search.model.source.join.DescendantNodeJoinCondition;
import org.xcmis.search.model.source.join.EquiJoinCondition;
import org.xcmis.search.model.source.join.SameNodeJoinCondition;
import org.xcmis.search.value.NameConverter;
import org.xcmis.search.value.PathSplitter;

public class LuceneQueryBuilder
implements QueryObjectModelVisitor {
    public static final char LIKE_ESCAPE_CHAR = '\\';
    public static final char LIKE_MATCH_ONE_CHAR = '_';
    public static final char LIKE_MATCH_ZERO_OR_MORE_CHAR = '%';
    private Stack<Object> queryBuilderStack;
    private Map<String, Object> bindVariablesValues;
    private final NameConverter nameConverter;
    private final PathSplitter pathSplitter;
    private final Pattern fullTextFieldNamePattern = Pattern.compile("^(.*:FULL|FULL):.*$");
    private IndexReader indexReader;
    private final IndexConfiguration indexConfiguration;

    public LuceneQueryBuilder(IndexReader indexReader, NameConverter<?> nameConverter, PathSplitter<?> pathSplitter, Map<String, Object> bindVariablesValues, IndexConfiguration indexConfiguration) {
        this.indexConfiguration = indexConfiguration;
        Validate.notNull((Object)indexReader, (String)"The indexReader argument may not be null");
        this.indexReader = indexReader;
        this.nameConverter = nameConverter;
        this.pathSplitter = pathSplitter;
        this.bindVariablesValues = bindVariablesValues;
        this.queryBuilderStack = new Stack();
    }

    public org.apache.lucene.search.Query getQuery() {
        org.apache.lucene.search.Query result = (org.apache.lucene.search.Query)this.queryBuilderStack.pop();
        this.queryBuilderStack = new Stack();
        return result;
    }

    public void visit(And node) throws VisitException {
        boolean selectors = true;
        Visitors.visit((QueryElement)node.getLeft(), (QueryObjectModelVisitor)this);
        Visitors.visit((QueryElement)node.getRight(), (QueryObjectModelVisitor)this);
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add((org.apache.lucene.search.Query)this.queryBuilderStack.pop(), BooleanClause.Occur.MUST);
        booleanQuery.add((org.apache.lucene.search.Query)this.queryBuilderStack.pop(), BooleanClause.Occur.MUST);
        this.queryBuilderStack.push(booleanQuery);
    }

    public void visit(BindVariableName node) throws VisitException {
        Object variableValue = this.bindVariablesValues.get(this.nameConverter.convertName(node.getVariableName()));
        if (variableValue == null) {
            throw new VisitException("No value bound for " + node.getVariableName());
        }
        this.queryBuilderStack.push(variableValue);
    }

    public void visit(ChildNode node) throws VisitException {
        String parentPath = node.getParentPath();
        if (parentPath.charAt(0) == '[') {
            TermQuery parentQuery = new TermQuery(new Term(FieldNames.UUID, parentPath.substring(1, parentPath.length() - 1)));
            ChildTraversingQueryNode childNodeQuery = new ChildTraversingQueryNode((org.apache.lucene.search.Query)parentQuery, false);
            this.queryBuilderStack.push((Object)childNodeQuery);
        } else {
            Name[] entries = this.pathSplitter.splitPath(parentPath);
            if (entries.length > 0) {
                org.apache.lucene.search.Query childNodeQuery = null;
                for (int i = 0; i < entries.length; ++i) {
                    if (i == 0) {
                        childNodeQuery = new TermQuery(new Term(FieldNames.UUID, this.indexConfiguration.getRootUuid()));
                        continue;
                    }
                    String stepName = this.nameConverter.convertName(entries[i]);
                    TermQuery nameQuery = new TermQuery(new Term(FieldNames.LABEL, stepName));
                    childNodeQuery = new DescendantQueryNode((org.apache.lucene.search.Query)nameQuery, childNodeQuery);
                }
                childNodeQuery = new ChildTraversingQueryNode(childNodeQuery, false);
                this.queryBuilderStack.push(childNodeQuery);
            } else {
                this.queryBuilderStack.push(new MatchAllDocsQuery());
            }
        }
    }

    public void visit(ChildNodeJoinCondition node) throws VisitException {
    }

    public void visit(Column node) throws VisitException {
    }

    public void visit(Comparison node) throws VisitException {
        Visitors.visit((QueryElement)node.getOperand2(), (QueryObjectModelVisitor)this);
        this.queryBuilderStack.push(node.getOperator());
        this.queryBuilderStack.push(new Boolean(false));
        Visitors.visit((QueryElement)node.getOperand1(), (QueryObjectModelVisitor)this);
    }

    public void visit(DescendantNode node) throws VisitException {
        String parentPath = node.getAncestorPath();
        if (parentPath.charAt(0) == '[') {
            TermQuery parentQuery = new TermQuery(new Term(FieldNames.UUID, parentPath.substring(1, parentPath.length() - 1)));
            ChildTraversingQueryNode childNodeQuery = new ChildTraversingQueryNode((org.apache.lucene.search.Query)parentQuery, true);
            this.queryBuilderStack.push((Object)childNodeQuery);
        } else {
            Name[] entries = this.pathSplitter.splitPath(parentPath);
            Object descendantQuery = new TermQuery(new Term(FieldNames.UUID, this.indexConfiguration.getRootUuid()));
            for (int i = 1; i < entries.length; ++i) {
                String stepName = this.nameConverter.convertName(entries[i]);
                TermQuery nameQuery = new TermQuery(new Term(FieldNames.LABEL, stepName));
                descendantQuery = new DescendantQueryNode((org.apache.lucene.search.Query)nameQuery, (org.apache.lucene.search.Query)descendantQuery);
            }
            descendantQuery = new ChildTraversingQueryNode((org.apache.lucene.search.Query)descendantQuery, true);
            this.queryBuilderStack.push(descendantQuery);
        }
    }

    public void visit(DescendantNodeJoinCondition node) throws VisitException {
    }

    public void visit(EquiJoinCondition node) throws VisitException {
    }

    public void visit(FullTextSearch node) throws VisitException {
        ANTLRStringStream input = new ANTLRStringStream(node.getFullTextSearchExpression().toString());
        FullTextLexer lexer = new FullTextLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FullTextParser parser = new FullTextParser((TokenStream)tokens);
        ErrorReporterImpl reporter = new ErrorReporterImpl();
        lexer.setErrorReporter(reporter);
        parser.setErrorReporter(reporter);
        ArrayList<String> fields = new ArrayList<String>();
        if (node.getPropertyName() != null) {
            fields.add(FieldNames.createFullTextFieldName(node.getPropertyName()));
        } else {
            Set<String> names;
            try {
                names = this.getFieldNames();
            }
            catch (IndexException e) {
                throw new VisitException(e.getLocalizedMessage());
            }
            for (String fieldName : names) {
                Matcher matcher = this.fullTextFieldNamePattern.matcher(fieldName);
                if (!matcher.matches()) continue;
                fields.add(fieldName);
            }
        }
        org.apache.lucene.search.Query query = null;
        try {
            parser.fulltext(fields, (Analyzer)new StandardAnalyzer(Version.LUCENE_35));
            query = parser.getQuery();
            InvalidQueryException ex = reporter.getException();
            if (ex != null) {
                throw new VisitException(ex.getLocalizedMessage());
            }
        }
        catch (RecognitionException e) {
            throw new VisitException(e.getMessage());
        }
        this.queryBuilderStack.push(query);
    }

    public void visit(FullTextSearchScore node) throws VisitException {
        throw new UnsupportedOperationException("FulltextSearchScore is unsupported operation.");
    }

    public void visit(Join node) throws VisitException {
    }

    public void visit(Length node) throws VisitException {
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Boolean), (String)"Stack should contains caseInsensitiveSearch flag");
        boolean caseInsensitiveSearch = (Boolean)this.queryBuilderStack.pop();
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Operator), (String)"Stack should contains comparation operator ");
        Operator operator = (Operator)this.queryBuilderStack.pop();
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Long), (String)("Invalid literal type, should be long. But found " + this.queryBuilderStack.peek().getClass().getCanonicalName()));
        Long staticLongValue = (Long)this.queryBuilderStack.pop();
        String value = NumericUtils.longToPrefixCoded((long)staticLongValue);
        String propertyField = FieldNames.createFieldLengthName(node.getPropertyValue().getPropertyName());
        Term lengthTerm = new Term(propertyField, value);
        switch (operator) {
            case EQUAL_TO: {
                this.queryBuilderStack.push(new TermQuery(lengthTerm));
                break;
            }
            case NOT_EQUAL_TO: {
                BooleanQuery booleanQuery = new BooleanQuery();
                booleanQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term(FieldNames.PROPERTIES_SET, node.getPropertyValue().getPropertyName())), BooleanClause.Occur.SHOULD);
                booleanQuery.add((org.apache.lucene.search.Query)new TermQuery(lengthTerm), BooleanClause.Occur.MUST_NOT);
                this.queryBuilderStack.push(booleanQuery);
                break;
            }
            case GREATER_THAN: {
                this.queryBuilderStack.push(new TermRangeQuery(lengthTerm.field(), lengthTerm.text(), null, false, false));
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                this.queryBuilderStack.push(new TermRangeQuery(lengthTerm.field(), lengthTerm.text(), null, true, true));
                break;
            }
            case LESS_THAN: {
                this.queryBuilderStack.push(new TermRangeQuery(lengthTerm.field(), null, lengthTerm.text(), false, false));
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                this.queryBuilderStack.push(new TermRangeQuery(lengthTerm.field(), null, lengthTerm.text(), true, true));
                break;
            }
            case LIKE: {
                throw new VisitException("Unsupported operation for Length operator");
            }
            default: {
                throw new VisitException("Invalid operator " + operator);
            }
        }
    }

    public void visit(Limit limit) throws VisitException {
    }

    public void visit(Literal node) throws VisitException {
        this.queryBuilderStack.push(node.getValue());
    }

    public void visit(LowerCase node) throws VisitException {
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Boolean), (String)"Stack should contains caseInsensitiveSearch flag");
        boolean caseInsensitiveSearch = (Boolean)this.queryBuilderStack.pop();
        String value = (String)this.queryBuilderStack.peek();
        if (!caseInsensitiveSearch && !StringUtils.isAllLowerCase((String)value)) {
            this.queryBuilderStack.push(new BooleanQuery());
        }
        this.queryBuilderStack.push(new Boolean(true));
        Visitors.visit((QueryElement)node.getOperand(), (QueryObjectModelVisitor)this);
    }

    public void visit(NodeDepth depth) throws VisitException {
    }

    public void visit(NodeLocalName node) throws VisitException {
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Boolean), (String)"Stack should contains caseInsensitiveSearch flag");
        boolean caseInsensitiveSearch = (Boolean)this.queryBuilderStack.pop();
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Operator), (String)"Stack should contains comparation operator ");
        Operator operator = (Operator)this.queryBuilderStack.pop();
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof String), (String)("Stack should contains static value. But found " + this.queryBuilderStack.peek().getClass().getCanonicalName()));
        String staticStingValue = (String)this.queryBuilderStack.pop();
        Term staticValueTerm = new Term(FieldNames.LABEL, staticStingValue);
        switch (operator) {
            case EQUAL_TO: {
                if (caseInsensitiveSearch) {
                    throw new VisitException("Unsupported operation of caseinsensetive search and NodeLocalName");
                }
                BooleanQuery equalToQuery = new BooleanQuery();
                equalToQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term(FieldNames.LABEL, "*?:" + staticStingValue)), BooleanClause.Occur.SHOULD);
                equalToQuery.add((org.apache.lucene.search.Query)new TermQuery(staticValueTerm), BooleanClause.Occur.SHOULD);
                this.queryBuilderStack.push(equalToQuery);
                break;
            }
            case NOT_EQUAL_TO: {
                if (caseInsensitiveSearch) {
                    throw new VisitException("Unsupported operation of caseinsensetive search and NodeLocalName");
                }
                BooleanQuery notEqualToQuery = new BooleanQuery();
                notEqualToQuery.add((org.apache.lucene.search.Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
                BooleanQuery q = new BooleanQuery();
                q.add((org.apache.lucene.search.Query)new WildcardQuery(new Term(FieldNames.LABEL, "*?:" + staticStingValue)), BooleanClause.Occur.SHOULD);
                q.add((org.apache.lucene.search.Query)new TermQuery(new Term(FieldNames.LABEL, staticStingValue)), BooleanClause.Occur.SHOULD);
                notEqualToQuery.add((org.apache.lucene.search.Query)q, BooleanClause.Occur.MUST_NOT);
                this.queryBuilderStack.push(notEqualToQuery);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: {
                throw new VisitException("Unsupported comparation :" + operator.toString() + " and NodeLocalName");
            }
            case LIKE: {
                String likeExpression = staticStingValue;
                MatchAllDocsQuery likeQuery = null;
                if (likeExpression.equals("%")) {
                    likeQuery = new MatchAllDocsQuery();
                } else {
                    String term = "(.+:)?" + this.likePatternToRegex(likeExpression);
                    likeQuery = new RegexQuery(new Term(FieldNames.LABEL, term));
                    if (caseInsensitiveSearch) {
                        ((RegexQuery)likeQuery).setRegexImplementation((RegexCapabilities)new CaseInsensitiveRegexCapImpl());
                    }
                }
                this.queryBuilderStack.push(likeQuery);
                break;
            }
            default: {
                throw new VisitException("Invalid operator " + operator);
            }
        }
    }

    public void visit(NodeName node) throws VisitException {
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Boolean), (String)"Stack should contains caseInsensitiveSearch flag");
        boolean caseInsensitiveSearch = (Boolean)this.queryBuilderStack.pop();
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Operator), (String)"Stack should contains comparation operator ");
        Operator operator = (Operator)this.queryBuilderStack.pop();
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof String), (String)("Stack should contains static value. But found " + this.queryBuilderStack.peek().getClass().getCanonicalName()));
        String staticStingValue = (String)this.queryBuilderStack.pop();
        Term staticValueTerm = new Term(FieldNames.LABEL, staticStingValue);
        switch (operator) {
            case EQUAL_TO: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveTermQuery(new Term(FieldNames.LABEL, staticStingValue.toLowerCase())));
                    break;
                }
                this.queryBuilderStack.push(new TermQuery(staticValueTerm));
                break;
            }
            case NOT_EQUAL_TO: {
                BooleanQuery booleanQuery = new BooleanQuery();
                booleanQuery.add((org.apache.lucene.search.Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
                if (caseInsensitiveSearch) {
                    booleanQuery.add((org.apache.lucene.search.Query)new CaseInsensitiveTermQuery(staticValueTerm), BooleanClause.Occur.MUST_NOT);
                } else {
                    booleanQuery.add((org.apache.lucene.search.Query)new TermQuery(staticValueTerm), BooleanClause.Occur.MUST_NOT);
                }
                this.queryBuilderStack.push(booleanQuery);
                break;
            }
            case GREATER_THAN: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveRangeQuery(staticValueTerm.field(), staticValueTerm.text().toLowerCase(), null, false, false));
                    break;
                }
                this.queryBuilderStack.push(new TermRangeQuery(staticValueTerm.field(), staticValueTerm.text().toLowerCase(), null, false, false));
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveRangeQuery(staticValueTerm.field(), staticValueTerm.text().toLowerCase(), null, true, true));
                    break;
                }
                this.queryBuilderStack.push(new TermRangeQuery(staticValueTerm.field(), staticValueTerm.text().toLowerCase(), null, true, true));
                break;
            }
            case LESS_THAN: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveRangeQuery(staticValueTerm.field(), null, staticValueTerm.text().toUpperCase(), false, false));
                    break;
                }
                this.queryBuilderStack.push(new TermRangeQuery(staticValueTerm.field(), null, staticValueTerm.text().toUpperCase(), false, false));
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveRangeQuery(staticValueTerm.field(), null, staticValueTerm.text().toUpperCase(), true, true));
                    break;
                }
                this.queryBuilderStack.push(new TermRangeQuery(staticValueTerm.field(), null, staticValueTerm.text().toUpperCase(), true, true));
                break;
            }
            case LIKE: {
                String likeExpression = staticStingValue;
                if (likeExpression.equals("%")) {
                    this.queryBuilderStack.push(new MatchAllDocsQuery());
                    break;
                }
                String term = this.likePatternToRegex(likeExpression);
                RegexQuery query = new RegexQuery(new Term(FieldNames.LABEL, term));
                if (caseInsensitiveSearch) {
                    query.setRegexImplementation((RegexCapabilities)new CaseInsensitiveRegexCapImpl());
                }
                this.queryBuilderStack.push(query);
                break;
            }
            default: {
                throw new VisitException("Invalid operator " + operator);
            }
        }
    }

    public void visit(Not node) throws VisitException {
        Visitors.visit((QueryElement)node.getConstraint(), (QueryObjectModelVisitor)this);
        BooleanQuery resultQuery = new BooleanQuery();
        resultQuery.add((org.apache.lucene.search.Query)this.queryBuilderStack.pop(), BooleanClause.Occur.MUST_NOT);
        if (this.queryBuilderStack.size() > 0) {
            resultQuery.add((org.apache.lucene.search.Query)this.queryBuilderStack.pop(), BooleanClause.Occur.MUST);
        } else {
            resultQuery.add((org.apache.lucene.search.Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        }
        this.queryBuilderStack.push(resultQuery);
    }

    public void visit(Or node) throws VisitException {
        Visitors.visit((QueryElement)node.getLeft(), (QueryObjectModelVisitor)this);
        Visitors.visit((QueryElement)node.getRight(), (QueryObjectModelVisitor)this);
        BooleanQuery resultQuery = new BooleanQuery();
        resultQuery.add((org.apache.lucene.search.Query)this.queryBuilderStack.pop(), BooleanClause.Occur.SHOULD);
        resultQuery.add((org.apache.lucene.search.Query)this.queryBuilderStack.pop(), BooleanClause.Occur.SHOULD);
        this.queryBuilderStack.push(resultQuery);
    }

    public void visit(Ordering node) throws VisitException {
    }

    public void visit(PropertyExistence node) throws VisitException {
        this.queryBuilderStack.push(new TermQuery(new Term(FieldNames.PROPERTIES_SET, node.getPropertyName())));
    }

    public void visit(PropertyValue node) throws VisitException {
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Boolean), (String)"Stack should contains caseInsensitiveSearch flag");
        boolean caseInsensitiveSearch = (Boolean)this.queryBuilderStack.pop();
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Operator), (String)"Stack should contains comparation operator ");
        Operator operator = (Operator)this.queryBuilderStack.pop();
        Object staticValue = this.queryBuilderStack.peek();
        Validate.isTrue((staticValue instanceof String || staticValue instanceof Double || staticValue instanceof Long || staticValue instanceof Calendar || staticValue instanceof Boolean ? 1 : 0) != 0, (String)("Stack should contains static value. But found " + this.queryBuilderStack.peek().getClass().getCanonicalName()));
        staticValue = this.queryBuilderStack.pop();
        String staticStingValue = null;
        if (staticValue instanceof String) {
            staticStingValue = (String)staticValue;
        } else if (staticValue instanceof Double) {
            staticStingValue = ExtendedNumberTools.doubleToString((Double)staticValue);
        } else if (staticValue instanceof Long) {
            staticStingValue = NumericUtils.longToPrefixCoded((long)((Long)staticValue));
        } else if (staticValue instanceof Calendar) {
            staticStingValue = DateTools.dateToString((Date)((Calendar)staticValue).getTime(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
        } else if (staticValue instanceof Boolean) {
            staticStingValue = staticValue.toString();
        }
        Term propertyValueTerm = new Term(FieldNames.createPropertyFieldName(node.getPropertyName()), staticStingValue);
        TermQuery propertyValueQuery = new TermQuery(propertyValueTerm);
        Term maxFildValue = new Term(FieldNames.createPropertyFieldName(node.getPropertyName()), "\uffff");
        switch (operator) {
            case EQUAL_TO: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveTermQuery(propertyValueTerm));
                    break;
                }
                this.queryBuilderStack.push(propertyValueQuery);
                break;
            }
            case NOT_EQUAL_TO: {
                BooleanQuery notEqualQuery = new BooleanQuery();
                notEqualQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term(FieldNames.PROPERTIES_SET, node.getPropertyName())), BooleanClause.Occur.SHOULD);
                if (caseInsensitiveSearch) {
                    notEqualQuery.add((org.apache.lucene.search.Query)new CaseInsensitiveTermQuery(propertyValueTerm), BooleanClause.Occur.MUST_NOT);
                } else {
                    notEqualQuery.add((org.apache.lucene.search.Query)propertyValueQuery, BooleanClause.Occur.MUST_NOT);
                }
                this.queryBuilderStack.push(notEqualQuery);
                break;
            }
            case GREATER_THAN: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveRangeQuery(FieldNames.createPropertyFieldName(node.getPropertyName()), propertyValueTerm.text(), maxFildValue.text(), false, false));
                    break;
                }
                this.queryBuilderStack.push(new TermRangeQuery(FieldNames.createPropertyFieldName(node.getPropertyName()), propertyValueTerm.text(), maxFildValue.text(), false, false));
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveRangeQuery(FieldNames.createPropertyFieldName(node.getPropertyName()), propertyValueTerm.text(), maxFildValue.text(), true, true));
                    break;
                }
                this.queryBuilderStack.push(new TermRangeQuery(FieldNames.createPropertyFieldName(node.getPropertyName()), propertyValueTerm.text(), maxFildValue.text(), true, true));
                break;
            }
            case LESS_THAN: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveRangeQuery(FieldNames.createPropertyFieldName(node.getPropertyName()), "", propertyValueTerm.text(), false, false));
                    break;
                }
                this.queryBuilderStack.push(new TermRangeQuery(FieldNames.createPropertyFieldName(node.getPropertyName()), "", propertyValueTerm.text(), false, false));
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                if (caseInsensitiveSearch) {
                    this.queryBuilderStack.push((Object)new CaseInsensitiveRangeQuery(FieldNames.createPropertyFieldName(node.getPropertyName()), "", propertyValueTerm.text(), true, true));
                    break;
                }
                this.queryBuilderStack.push(new TermRangeQuery(FieldNames.createPropertyFieldName(node.getPropertyName()), "", propertyValueTerm.text(), true, true));
                break;
            }
            case LIKE: {
                if (staticStingValue.equals("%")) {
                    this.queryBuilderStack.push(new TermQuery(new Term(FieldNames.PROPERTIES_SET, node.getPropertyName())));
                    break;
                }
                String term = this.likePatternToRegex(staticStingValue);
                RegexQuery likeQuery = new RegexQuery(new Term(FieldNames.createPropertyFieldName(node.getPropertyName()), term));
                if (caseInsensitiveSearch) {
                    likeQuery.setRegexImplementation((RegexCapabilities)new CaseInsensitiveRegexCapImpl());
                }
                this.queryBuilderStack.push(likeQuery);
                break;
            }
            default: {
                throw new VisitException("Invalid operator " + operator);
            }
        }
    }

    public void visit(Query node) throws VisitException {
    }

    public void visit(SameNode node) throws VisitException {
        Name[] entries = this.pathSplitter.splitPath(node.getPath());
        Object descendantQuery = null;
        for (int i = 0; i < entries.length; ++i) {
            if (i == 0) {
                descendantQuery = new TermQuery(new Term(FieldNames.UUID, this.indexConfiguration.getRootUuid()));
                continue;
            }
            String stepName = this.nameConverter.convertName(entries[i]);
            TermQuery nameQuery = new TermQuery(new Term(FieldNames.LABEL, stepName));
            descendantQuery = new DescendantQueryNode((org.apache.lucene.search.Query)nameQuery, (org.apache.lucene.search.Query)descendantQuery);
        }
        this.queryBuilderStack.push(descendantQuery);
    }

    public void visit(SameNodeJoinCondition node) throws VisitException {
    }

    public void visit(Selector selector) throws VisitException {
    }

    public void visit(UpperCase node) throws VisitException {
        Validate.isTrue((boolean)(this.queryBuilderStack.peek() instanceof Boolean), (String)"Stack should contains caseInsensitiveSearch flag");
        boolean caseInsensitiveSearch = (Boolean)this.queryBuilderStack.pop();
        String value = (String)this.queryBuilderStack.peek();
        if (!caseInsensitiveSearch && !StringUtils.isAllUpperCase((String)value)) {
            this.queryBuilderStack.push(new BooleanQuery());
        }
        this.queryBuilderStack.push(new Boolean(true));
        Visitors.visit((QueryElement)node.getOperand(), (QueryObjectModelVisitor)this);
    }

    private Set<String> getFieldNames() throws IndexException {
        HashSet<String> fildsSet = new HashSet<String>();
        Collection fields = this.indexReader.getFieldNames(IndexReader.FieldOption.ALL);
        for (Object field : fields) {
            fildsSet.add((String)field);
        }
        return fildsSet;
    }

    private String likePatternToRegex(String pattern) {
        StringBuffer regexp = new StringBuffer();
        regexp.append("^");
        boolean escaped = false;
        block4: for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '\\') {
                if (escaped) {
                    regexp.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (Character.isLetterOrDigit(pattern.charAt(i))) {
                if (escaped) {
                    regexp.append(pattern.charAt(i));
                    escaped = false;
                    continue;
                }
                regexp.append(pattern.charAt(i));
                continue;
            }
            if (escaped) {
                regexp.append('\\').append(pattern.charAt(i));
                escaped = false;
                continue;
            }
            switch (pattern.charAt(i)) {
                case '_': {
                    regexp.append('.');
                    continue block4;
                }
                case '%': {
                    regexp.append(".*");
                    continue block4;
                }
                default: {
                    regexp.append('\\').append(pattern.charAt(i));
                }
            }
        }
        regexp.append("$");
        return regexp.toString();
    }
}

