/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.IndexTransactionModificationReport;
import org.xcmis.search.lucene.index.IndexTransactionModificationReportImpl;
import org.xcmis.search.lucene.index.LoggedIndexTransaction;
import org.xcmis.search.lucene.index.TransactionLog;
import org.xcmis.search.lucene.index.TransactionableLuceneIndexDataManager;
import org.xcmis.spi.utils.Logger;

public class ReducibleInMemoryIndexDataKeeper
implements TransactionableLuceneIndexDataManager {
    private static final Logger LOG = Logger.getLogger(ReducibleInMemoryIndexDataKeeper.class);
    public final RAMDirectory indexDirectiry;
    public long lastModifedTime;
    boolean isPendingCommited;
    boolean isStarted;
    boolean isStoped;
    private final Map<String, Document> documentsBuffer;
    private IndexReader indexReader;
    private final Map<String, Document> pendingDocumentsBuffer;
    private final TransactionLog transactionLog;

    public ReducibleInMemoryIndexDataKeeper(LoggedIndexTransaction<Document> changes) throws IndexException {
        this.indexDirectiry = new RAMDirectory();
        this.transactionLog = changes.getTransactionLog();
        this.isStarted = false;
        this.isPendingCommited = false;
        this.lastModifedTime = System.currentTimeMillis();
        this.documentsBuffer = new HashMap(changes.getAddedDocuments());
        this.pendingDocumentsBuffer = new HashMap(changes.getAddedDocuments());
        this.initDirectory();
    }

    public ReducibleInMemoryIndexDataKeeper(RAMDirectory indexDirectiry, Map<String, Document> documentsBuffer, Map<String, Document> pendingDocumentsBuffer, TransactionLog transactionLog) {
        this.indexDirectiry = indexDirectiry;
        this.documentsBuffer = documentsBuffer;
        this.pendingDocumentsBuffer = pendingDocumentsBuffer;
        this.transactionLog = transactionLog;
        this.isStarted = false;
        this.isPendingCommited = pendingDocumentsBuffer.size() == 0;
        this.lastModifedTime = System.currentTimeMillis();
    }

    @Override
    public Directory getDirectory() throws IndexException {
        if (!this.isPendingCommited) {
            this.commitPending();
        }
        return this.indexDirectiry;
    }

    @Override
    public long getDirectorySize(boolean includeInherited) {
        return this.indexDirectiry.sizeInBytes();
    }

    @Override
    public Document getDocument(String uuid) throws IndexException {
        return this.documentsBuffer.get(uuid);
    }

    @Override
    public long getDocumentCount() {
        return this.documentsBuffer.size();
    }

    public Map<String, Document> getDocumentsBuffer() {
        return this.documentsBuffer;
    }

    @Override
    public IndexReader getIndexReader() throws IndexException {
        if (this.documentsBuffer.size() < 1) {
            return null;
        }
        if (!this.isPendingCommited) {
            this.commitPending();
        }
        try {
            if (this.indexReader == null) {
                this.indexReader = IndexReader.open((Directory)this.indexDirectiry);
            } else if (!this.indexReader.isCurrent()) {
                this.indexReader = this.indexReader.reopen();
            }
        }
        catch (CorruptIndexException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        return this.indexReader;
    }

    @Override
    public long getLastModifedTime() {
        return this.lastModifedTime;
    }

    public Map<String, Document> getPendingDocumentsBuffer() {
        return this.pendingDocumentsBuffer;
    }

    @Override
    public TransactionLog getTransactionLog() {
        return this.transactionLog;
    }

    public boolean isPendingCommited() {
        return this.isPendingCommited;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public boolean isStoped() {
        return this.isStoped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexTransactionModificationReport save(IndexTransaction<Document> changes) throws IndexException, IndexTransactionException {
        HashSet<String> addedDocuments = new HashSet<String>();
        HashSet<String> removedDocuments = new HashSet<String>();
        HashSet<String> updatedDocuments = new HashSet<String>();
        try {
            RAMDirectory rAMDirectory = this.indexDirectiry;
            synchronized (rAMDirectory) {
                Set<String> removed = changes.getRemovedDocuments();
                IndexWriter writer = null;
                for (String removedUuid : removed) {
                    if (this.documentsBuffer.remove(removedUuid) == null) continue;
                    removedDocuments.add(removedUuid);
                    if (!this.isPendingCommited && this.pendingDocumentsBuffer.remove(removedUuid) != null) continue;
                    if (writer == null) {
                        writer = new IndexWriter((Directory)this.indexDirectiry, (Analyzer)new StandardAnalyzer(Version.LUCENE_35), IndexWriter.MaxFieldLength.UNLIMITED);
                        writer.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                    }
                    writer.deleteDocuments(new Term(FieldNames.UUID, removedUuid));
                }
                if (writer != null) {
                    writer.commit();
                    writer.close();
                    this.lastModifedTime = System.currentTimeMillis();
                }
            }
        }
        catch (CorruptIndexException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        return new IndexTransactionModificationReportImpl(addedDocuments, removedDocuments, updatedDocuments);
    }

    @Override
    public void start() throws IndexException {
        this.isStarted = true;
    }

    @Override
    public void stop() throws IndexException {
        this.indexDirectiry.close();
        this.isStoped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPending() throws IndexException {
        block18: {
            IndexWriter writer = null;
            try {
                if (this.pendingDocumentsBuffer.size() <= 0) break block18;
                RAMDirectory rAMDirectory = this.indexDirectiry;
                synchronized (rAMDirectory) {
                    writer = new IndexWriter((Directory)this.indexDirectiry, (Analyzer)new StandardAnalyzer(Version.LUCENE_35), IndexWriter.MaxFieldLength.UNLIMITED);
                    for (Map.Entry<String, Document> addedDocument : this.pendingDocumentsBuffer.entrySet()) {
                        writer.addDocument(addedDocument.getValue());
                    }
                    this.pendingDocumentsBuffer.clear();
                    writer.commit();
                    this.isPendingCommited = true;
                    writer.close();
                }
            }
            catch (CorruptIndexException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
            catch (LockObtainFailedException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (CorruptIndexException e) {
                        throw new IndexException(e.getLocalizedMessage(), e);
                    }
                    catch (IOException e) {
                        throw new IndexException(e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    private void initDirectory() throws IndexException {
        try {
            IndexWriter.MaxFieldLength fieldLength = new IndexWriter.MaxFieldLength(IndexWriter.DEFAULT_MAX_FIELD_LENGTH);
            IndexWriter iw = new IndexWriter((Directory)this.indexDirectiry, (Analyzer)new SimpleAnalyzer(), true, fieldLength);
            iw.close();
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
    }
}

