/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.content;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xcmis.search.content.InMemoryColumn;
import org.xcmis.search.content.Schema;
import org.xcmis.search.model.constraint.Operator;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.value.PropertyType;

public class InMemoryTable
implements Schema.Table {
    private final SelectorName name;
    private final Map<String, Schema.Column> columnsByName;
    private final List<Schema.Column> columns;

    public InMemoryTable(SelectorName name, Iterable<Schema.Column> columns) {
        this(name, columns, (Iterable[])null);
    }

    public InMemoryTable(SelectorName name, Iterable<Schema.Column> columns, Iterable<Schema.Column> ... keyColumns) {
        this.name = name;
        LinkedList<Schema.Column> columnList = new LinkedList<Schema.Column>();
        HashMap<String, Schema.Column> columnMap = new HashMap<String, Schema.Column>();
        for (Schema.Column column : columns) {
            Schema.Column old = columnMap.put(column.getName(), column);
            if (old != null) {
                columnList.set(columnList.indexOf(old), column);
                continue;
            }
            columnList.add(column);
        }
        this.columnsByName = Collections.unmodifiableMap(columnMap);
        this.columns = Collections.unmodifiableList(columnList);
    }

    public InMemoryTable(SelectorName name, Map<String, Schema.Column> columnsByName, List<Schema.Column> columns) {
        this.name = name;
        this.columns = columns;
        this.columnsByName = columnsByName;
    }

    @Override
    public Schema.Column getColumn(String name) {
        return this.columnsByName.get(name);
    }

    @Override
    public List<Schema.Column> getColumns() {
        return this.columns;
    }

    @Override
    public Map<String, Schema.Column> getColumnsByName() {
        return this.columnsByName;
    }

    @Override
    public SelectorName getName() {
        return this.name;
    }

    public InMemoryTable withColumn(String name, PropertyType type) {
        LinkedList<Schema.Column> newColumns = new LinkedList<Schema.Column>(this.columns);
        newColumns.add(new InMemoryColumn(name, type));
        return new InMemoryTable(this.getName(), newColumns);
    }

    public InMemoryTable withColumn(String name, PropertyType type, boolean fullTextSearchable, Operator[] availableQueryOperators) {
        LinkedList<Schema.Column> newColumns = new LinkedList<Schema.Column>(this.columns);
        newColumns.add(new InMemoryColumn(name, type, fullTextSearchable, availableQueryOperators));
        return new InMemoryTable(this.getName(), newColumns);
    }

    public InMemoryTable withColumns(Iterable<Schema.Column> columns) {
        LinkedList<Schema.Column> newColumns = new LinkedList<Schema.Column>(this.getColumns());
        for (Schema.Column column : columns) {
            newColumns.add(new InMemoryColumn(column.getName(), column.getPropertyType(), column.isFullTextSearchable(), column.getAvailableQueryOperators()));
        }
        return new InMemoryTable(this.getName(), newColumns);
    }

    public InMemoryTable with(SelectorName name) {
        return new InMemoryTable(name, this.columnsByName, this.columns);
    }
}

