/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.model.AccessControlEntry;

public final class CmisUtils {
    public static final Comparator<ObjectData> versionComparator = new Comparator<ObjectData>(){

        @Override
        public int compare(ObjectData object1, ObjectData object2) {
            Calendar c1 = object1.getLastModificationDate();
            Calendar c2 = object2.getLastModificationDate();
            return c2.compareTo(c1);
        }
    };
    public static ItemsIterator<Object> EMPTY_ITEMS_ITERATOR = new EmptyItemsIterator();
    private static final Pattern Z_FORMAT = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})[Tt](\\d{2}):(\\d{2}):(\\d{2})(\\.(\\d{1,3}))?[zZ]");
    private static final Pattern TD_FORMAT = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})[Tt](\\d{2}):(\\d{2}):(\\d{2})(\\.(\\d{1,3}))?([+-])((\\d{2}):(\\d{2}))");
    public static final DateFormat ISO_8601_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ");

    public static <T> ItemsIterator<T> emptyItemsIterator() {
        return EMPTY_ITEMS_ITERATOR;
    }

    public static List<AccessControlEntry> createAclFromPermissionMap(Map<String, Set<String>> permissions) {
        ArrayList<AccessControlEntry> acl = new ArrayList<AccessControlEntry>();
        if (permissions != null) {
            for (Map.Entry<String, Set<String>> e : permissions.entrySet()) {
                AccessControlEntry ace = new AccessControlEntry(e.getKey(), e.getValue());
                acl.add(ace);
            }
        }
        return acl;
    }

    public static List<AccessControlEntry> mergeACLs(List<AccessControlEntry> existedAcl, List<AccessControlEntry> addAcl, List<AccessControlEntry> removeAcl) {
        HashMap<String, Set<String>> cache = new HashMap<String, Set<String>>();
        CmisUtils.addAclToPermissionMap(cache, existedAcl);
        CmisUtils.addAclToPermissionMap(cache, addAcl);
        CmisUtils.removeAclFromPermissionMap(cache, removeAcl);
        return CmisUtils.createAclFromPermissionMap(cache);
    }

    public static void addAclToPermissionMap(Map<String, Set<String>> map, List<AccessControlEntry> acl) {
        if (acl != null) {
            for (AccessControlEntry ace : acl) {
                String principal = ace.getPrincipal();
                if (principal == null) continue;
                Set<String> permissions = map.get(principal);
                if (permissions == null) {
                    permissions = new HashSet<String>();
                    map.put(principal, permissions);
                }
                permissions.addAll(ace.getPermissions());
            }
        }
    }

    public static void removeAclFromPermissionMap(Map<String, Set<String>> map, List<AccessControlEntry> acl) {
        if (acl != null) {
            for (AccessControlEntry ace : acl) {
                Set<String> permissions;
                String principal = ace.getPrincipal();
                if (principal == null || (permissions = map.get(principal)) == null) continue;
                permissions.removeAll(ace.getPermissions());
                if (permissions.size() != 0) continue;
                map.remove(principal);
            }
        }
    }

    public static XMLGregorianCalendar fromCalendar(Calendar calendar) {
        XMLGregorianCalendar xmlCalendar;
        try {
            xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
        }
        catch (DatatypeConfigurationException e) {
            String msg = "Unable get XMLGregorianCalendar.";
            throw new RuntimeException(msg, e);
        }
        xmlCalendar.setYear(calendar.get(1));
        xmlCalendar.setMonth(calendar.get(2) + 1);
        xmlCalendar.setDay(calendar.get(5));
        int zoneOffsetInMinutes = (calendar.get(15) + calendar.get(16)) / 60000;
        xmlCalendar.setTimezone(zoneOffsetInMinutes);
        xmlCalendar.setTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        return xmlCalendar;
    }

    public static String convertToString(Calendar c) {
        int zoneOffsetInMinutes = (c.get(15) + c.get(16)) / 60000;
        String signOffset = zoneOffsetInMinutes < 0 ? "-" : "+";
        zoneOffsetInMinutes = zoneOffsetInMinutes < 0 ? -zoneOffsetInMinutes : zoneOffsetInMinutes;
        int hoursOffset = zoneOffsetInMinutes / 60;
        int minutesOffset = zoneOffsetInMinutes % 60;
        String result = String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d" + signOffset + "%02d:%02d", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14), hoursOffset, minutesOffset);
        return result;
    }

    public static Calendar parseCalendar(String date) {
        Matcher m = Z_FORMAT.matcher(date);
        if (m.matches()) {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.set(1, Integer.parseInt(m.group(1)));
            c.set(2, Integer.parseInt(m.group(2)) - 1);
            c.set(5, Integer.parseInt(m.group(3)));
            c.set(11, Integer.parseInt(m.group(4)));
            c.set(12, Integer.parseInt(m.group(5)));
            c.set(13, Integer.parseInt(m.group(6)));
            c.set(14, m.group(7) == null ? 0 : Integer.parseInt(m.group(8)));
            return c;
        }
        m = TD_FORMAT.matcher(date);
        if (m.matches()) {
            int t = m.group(9).equals("+") ? 1 : -1;
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.set(1, Integer.parseInt(m.group(1)));
            c.set(2, Integer.parseInt(m.group(2)) - 1);
            c.set(5, Integer.parseInt(m.group(3)));
            c.set(11, Integer.parseInt(m.group(4)));
            c.set(12, Integer.parseInt(m.group(5)));
            c.set(13, Integer.parseInt(m.group(6)));
            c.set(14, m.group(7) == null ? 0 : Integer.parseInt(m.group(8)));
            int zoneOffset = t * (Integer.parseInt(m.group(11)) * 60 * 60 * 1000 + Integer.parseInt(m.group(12)) * 60 * 1000);
            c.set(15, zoneOffset);
            return c;
        }
        throw new IllegalArgumentException("Unsupported date format " + date);
    }

    public static XMLGregorianCalendar parseXMLCalendar(String date) {
        return CmisUtils.fromCalendar(CmisUtils.parseCalendar(date));
    }

    private CmisUtils() {
    }

    private static class EmptyItemsIterator
    implements ItemsIterator<Object> {
        private EmptyItemsIterator() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void skip(int skip) throws NoSuchElementException {
            throw new NoSuchElementException("skip");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException("next");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

