/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index.merge;

import java.util.Collection;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.merge.AggregatePolicy;
import org.xcmis.search.lucene.index.merge.InheritanceAggregationPolicy;
import org.xcmis.spi.utils.Logger;

public class MaxCandidatsCountAggrigatePolicy
extends InheritanceAggregationPolicy {
    private static final Logger LOG = Logger.getLogger(MaxCandidatsCountAggrigatePolicy.class);
    public static final int DEFAULT_MAX_CHAINS_COUNT = 40;

    public MaxCandidatsCountAggrigatePolicy(AggregatePolicy superAggregatePolicy) {
        super(superAggregatePolicy);
    }

    @Override
    public Collection<LuceneIndexDataManager> findIndexDataManagerToAggrigate(Collection<LuceneIndexDataManager> aggregateCandidat, long requiredCandidatCount, long reguiredTotalCandidatSize) {
        long required = Math.max(requiredCandidatCount, (long)(aggregateCandidat.size() - 40));
        if (required > 0L) {
            required = Math.max(required, Math.round((double)aggregateCandidat.size() * 0.3));
        }
        return super.findIndexDataManagerToAggrigate(aggregateCandidat, required, reguiredTotalCandidatSize);
    }
}

