/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.query;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public class Statistics
implements Comparable<Statistics>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Statistics EMPTY_STATISTICS = new Statistics();
    private final long planningMillis;
    private final long optimizationMillis;
    private final long resultFormulationMillis;
    private final long executionMillis;
    static ThreadLocal<DecimalFormat> FORMATTER = new ThreadLocal<DecimalFormat>(){

        @Override
        protected synchronized DecimalFormat initialValue() {
            return new DecimalFormat("###,###,##0.0##");
        }
    };

    public Statistics() {
        this(0L, 0L, 0L, 0L);
    }

    public Statistics(long planningMillis) {
        this(planningMillis, 0L, 0L, 0L);
    }

    public Statistics(long planningMillis, long optimizationMillis, long resultFormulationMillis, long executionMillis) {
        this.planningMillis = planningMillis;
        this.optimizationMillis = optimizationMillis;
        this.resultFormulationMillis = resultFormulationMillis;
        this.executionMillis = executionMillis;
    }

    public long getPlanningTime(TimeUnit unit) {
        return unit.convert(this.planningMillis, TimeUnit.MILLISECONDS);
    }

    public long getOptimizationTime(TimeUnit unit) {
        return unit.convert(this.optimizationMillis, TimeUnit.MILLISECONDS);
    }

    public long getResultFormulationTime(TimeUnit unit) {
        return unit.convert(this.resultFormulationMillis, TimeUnit.MILLISECONDS);
    }

    public long getExecutionTime(TimeUnit unit) {
        return unit.convert(this.executionMillis, TimeUnit.MILLISECONDS);
    }

    public long getTotalTime(TimeUnit unit) {
        return unit.convert(this.totalTime(), TimeUnit.MILLISECONDS);
    }

    protected long totalTime() {
        return this.planningMillis + this.optimizationMillis + this.resultFormulationMillis + this.executionMillis;
    }

    public Statistics withPlanningTime(long planningMillis) {
        return new Statistics(planningMillis, this.optimizationMillis, this.resultFormulationMillis, this.executionMillis);
    }

    public Statistics withOptimizationTime(long optimizationMillis) {
        return new Statistics(this.planningMillis, optimizationMillis, this.resultFormulationMillis, this.executionMillis);
    }

    public Statistics withResultsFormulationTime(long resultFormulationMillis) {
        return new Statistics(this.planningMillis, this.optimizationMillis, resultFormulationMillis, this.executionMillis);
    }

    public Statistics withExecutionTime(long executionMillis) {
        return new Statistics(this.planningMillis, this.optimizationMillis, this.resultFormulationMillis, executionMillis);
    }

    public Statistics withPlanningTime(long planning, TimeUnit unit) {
        long planningMillis = TimeUnit.NANOSECONDS.convert(planning, unit);
        return new Statistics(planningMillis, this.optimizationMillis, this.resultFormulationMillis, this.executionMillis);
    }

    public Statistics withOptimizationTime(long optimization, TimeUnit unit) {
        long optimizationMillis = TimeUnit.NANOSECONDS.convert(optimization, unit);
        return new Statistics(this.planningMillis, optimizationMillis, this.resultFormulationMillis, this.executionMillis);
    }

    public Statistics withResultsFormulationTime(long resultFormulation, TimeUnit unit) {
        long resultFormulationMillis = TimeUnit.MILLISECONDS.convert(resultFormulation, unit);
        return new Statistics(this.planningMillis, this.optimizationMillis, resultFormulationMillis, this.executionMillis);
    }

    public Statistics withExecutionTime(long execution, TimeUnit unit) {
        long executionMillis = TimeUnit.MILLISECONDS.convert(execution, unit);
        return new Statistics(this.planningMillis, this.optimizationMillis, this.resultFormulationMillis, executionMillis);
    }

    @Override
    public int compareTo(Statistics that) {
        if (that == this) {
            return 0;
        }
        long diff = this.totalTime() - that.totalTime();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.readable(this.totalTime(), sb);
        boolean first = false;
        if (this.planningMillis != 0L) {
            sb.append(" (plan=");
            this.readable(this.planningMillis, sb);
            first = false;
        }
        if (this.optimizationMillis != 0L) {
            if (first) {
                first = false;
                sb.append(" (");
            } else {
                sb.append(" ,");
            }
            sb.append("opt=");
            this.readable(this.optimizationMillis, sb);
        }
        if (this.resultFormulationMillis != 0L) {
            if (first) {
                first = false;
                sb.append(" (");
            } else {
                sb.append(" ,");
            }
            sb.append("res=");
            this.readable(this.resultFormulationMillis, sb);
        }
        if (this.executionMillis != 0L) {
            if (first) {
                first = false;
                sb.append(" (");
            } else {
                sb.append(" ,");
            }
            sb.append("exec=");
            this.readable(this.executionMillis, sb);
        }
        if (!first) {
            sb.append(')');
        }
        return sb.toString();
    }

    protected void readable(long millis, StringBuilder sb) {
        if (millis < 1000L) {
            sb.append(millis).append(" ns");
        } else if (millis < 1000000L) {
            double value = (double)millis / 1000.0;
            sb.append(FORMATTER.get().format(value)).append(" usec");
        } else if (millis < 1000000000L) {
            double value = (double)millis / 1000000.0;
            sb.append(FORMATTER.get().format(value)).append(" ms");
        } else {
            double value = (double)millis / 1.0E9;
            sb.append(FORMATTER.get().format(value)).append(" sec");
        }
    }
}

