/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.utils.MimeType;

public class RenditionFilter {
    public static final String ANY = "*";
    public static final String NONE = "cmis:none";
    public static final String THUMBNAIL = "cmis:thumbnail";
    public static final RenditionFilter THUMBNAIL_FILTER = new RenditionFilter();
    public static final RenditionFilter ANY_FILTER;
    public static final RenditionFilter NONE_FILTER;
    private static final Pattern SPLITTER;
    private boolean anyRenditions = false;
    private Set<String> kinds;
    private Set<MimeType> mediaTypes;

    public RenditionFilter(String filterString) throws FilterNotValidException {
        if (filterString == null || filterString.length() == 0 || NONE.equals(filterString.trim())) {
            this.kinds = Collections.emptySet();
            this.mediaTypes = Collections.emptySet();
        } else if (ANY.equals(filterString.trim())) {
            this.anyRenditions = true;
        } else {
            filterString = filterString.trim();
            this.kinds = new HashSet<String>();
            this.mediaTypes = new HashSet<MimeType>();
            for (String token : SPLITTER.split(filterString)) {
                if (token.length() > 0 && !token.equals(ANY)) {
                    for (char ch : token.toCharArray()) {
                        if (!Character.isWhitespace(ch)) continue;
                        String msg = "Invalid filter \"" + filterString + "\". Filter's tokens must not have whitespace.";
                        throw new FilterNotValidException(msg);
                    }
                    if (token.indexOf(47) > 0) {
                        this.mediaTypes.add(MimeType.fromString(token));
                        continue;
                    }
                    this.kinds.add(token);
                    continue;
                }
                String msg = "Invalid filter \"" + filterString + "\". Filter must contains either '*' OR comma-separated list mime-types or kinds of renditions.";
                throw new FilterNotValidException(msg);
            }
        }
    }

    protected RenditionFilter() {
    }

    public boolean accept(Rendition rendition) {
        if (this.anyRenditions) {
            return true;
        }
        if (this.kinds.contains(rendition.getKind())) {
            return true;
        }
        MimeType toCheck = MimeType.fromString(rendition.getMimeType());
        for (MimeType mediaType : this.mediaTypes) {
            if (!mediaType.match(toCheck)) continue;
            return true;
        }
        return false;
    }

    public boolean isNone() {
        return !this.anyRenditions && this.mediaTypes.size() == 0 && this.kinds.size() == 0;
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add(THUMBNAIL);
        RenditionFilter.THUMBNAIL_FILTER.kinds = Collections.unmodifiableSet(tmp);
        RenditionFilter.THUMBNAIL_FILTER.mediaTypes = Collections.emptySet();
        ANY_FILTER = new RenditionFilter();
        RenditionFilter.ANY_FILTER.anyRenditions = true;
        NONE_FILTER = new RenditionFilter();
        RenditionFilter.NONE_FILTER.kinds = Collections.emptySet();
        RenditionFilter.NONE_FILTER.mediaTypes = Collections.emptySet();
        SPLITTER = Pattern.compile("\\s*,\\s*");
    }
}

