/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.ToStringUtils;

public class CaseInsensitiveTermQuery
extends MultiTermQuery {
    private static final long serialVersionUID = 8733959357848332771L;
    protected Term term;

    public CaseInsensitiveTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new CaseInsensitiveTermEnum(reader, this.term);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (this.term != null) {
            if (!this.term.field().equals(field)) {
                buffer.append(this.term.field());
                buffer.append(":");
            }
            buffer.append(this.term.text());
        } else {
            buffer.append("termPattern:unknown");
        }
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    private class CaseInsensitiveTermEnum
    extends FilteredTermEnum {
        private String field;
        private String text;
        private boolean endEnum;

        public CaseInsensitiveTermEnum(IndexReader reader, Term term) throws IOException {
            this.field = term.field();
            this.text = term.text().toLowerCase();
            this.setEnum(reader.terms(new Term(term.field(), term.text().toUpperCase())));
        }

        public void close() throws IOException {
            super.close();
            this.field = null;
            this.text = null;
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            return this.endEnum;
        }

        protected boolean termCompare(Term termCompare) {
            if (this.field == termCompare.field()) {
                String searchText = termCompare.text();
                return this.text.equals(searchText.toLowerCase());
            }
            this.endEnum = true;
            return false;
        }
    }
}

