/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.abdera;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.abdera.ACLCapabilityTypeElement;
import org.xcmis.restatom.abdera.RepositoryCapabilitiesTypeElement;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.RepositoryInfo;

public class RepositoryInfoTypeElement
extends ExtensibleElementWrapper {
    public RepositoryInfoTypeElement(Element internal) {
        super(internal);
    }

    public RepositoryInfoTypeElement(Factory factory, QName qname) {
        super(factory, qname);
    }

    public void build(RepositoryInfo repoInfo) {
        if (repoInfo != null) {
            this.addSimpleExtension(AtomCMIS.REPOSITORY_ID, repoInfo.getRepositoryId());
            this.addSimpleExtension(AtomCMIS.REPOSITORY_NAME, repoInfo.getRepositoryName());
            this.addSimpleExtension(AtomCMIS.REPOSITORY_DESCRIPTION, repoInfo.getRepositoryDescription());
            this.addSimpleExtension(AtomCMIS.VENDOR_NAME, repoInfo.getVendorName());
            this.addSimpleExtension(AtomCMIS.PRODUCT_NAME, repoInfo.getProductName());
            this.addSimpleExtension(AtomCMIS.PRODUCT_VERSION, repoInfo.getProductVersion());
            this.addSimpleExtension(AtomCMIS.ROOT_FOLDER_ID, repoInfo.getRootFolderId());
            this.addSimpleExtension(AtomCMIS.LATEST_CHANGE_LOG_TOKEN, repoInfo.getLatestChangeLogToken());
            this.addSimpleExtension(AtomCMIS.CMIS_VERSION_SUPPORTED, repoInfo.getCmisVersionSupported());
            this.addSimpleExtension(AtomCMIS.THIN_CLIENT_URI, repoInfo.getThinClientURI());
            this.addSimpleExtension(AtomCMIS.CHANGES_INCOMPLETE, Boolean.toString(repoInfo.isChangesIncomplete()));
            Collection listChangesOnType = repoInfo.getChangesOnType();
            if (listChangesOnType != null && listChangesOnType.size() > 0) {
                for (BaseType baseType : listChangesOnType) {
                    this.addSimpleExtension(AtomCMIS.CHANGES_ON_TYPE, baseType.value());
                }
            }
            this.addSimpleExtension(AtomCMIS.PRINCIPAL_ANONYMOUS, repoInfo.getPrincipalAnonymous());
            this.addSimpleExtension(AtomCMIS.PRINCIPAL_ANYONE, repoInfo.getPrincipalAnyone());
            RepositoryCapabilitiesTypeElement repoCb = (RepositoryCapabilitiesTypeElement)this.addExtension(AtomCMIS.CAPABILITIES);
            repoCb.build(repoInfo.getCapabilities());
            ACLCapabilityTypeElement aclCb = (ACLCapabilityTypeElement)this.addExtension(AtomCMIS.ACL_CAPABILITY);
            aclCb.build(repoInfo.getAclCapability());
        }
    }
}

