/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.xcmis.search.result.ScoredRow;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.Storage;
import org.xcmis.spi.model.BaseType;

public class DocumentOrderResultSorter
implements Comparator<ScoredRow> {
    private final String selectorName;
    private final Map<String, ObjectData> itemCache;
    private final Storage storage;

    public DocumentOrderResultSorter(String selectorName, Storage storage) {
        this.selectorName = selectorName;
        this.storage = storage;
        this.itemCache = new HashMap<String, ObjectData>();
    }

    @Override
    public int compare(ScoredRow o1, ScoredRow o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        String path1 = this.getPath(o1.getNodeIdentifer(this.selectorName));
        String path2 = this.getPath(o2.getNodeIdentifer(this.selectorName));
        if (path1 == null || path2 == null) {
            return 0;
        }
        return path1.compareTo(path2);
    }

    public String getPath(String identifer) {
        ObjectData obj = this.itemCache.get(identifer);
        if (obj == null) {
            try {
                obj = this.storage.getObjectById(identifer);
            }
            catch (ObjectNotFoundException e) {
                return null;
            }
            this.itemCache.put(identifer, obj);
        }
        if (obj.getBaseType() == BaseType.FOLDER && ((FolderData)obj).isRoot()) {
            return obj.getName();
        }
        Collection parents = obj.getParents();
        if (parents.size() == 0) {
            return obj.getName();
        }
        return ((FolderData)parents.iterator().next()).getPath() + "/" + obj.getName();
    }
}

