package org.exoplatform.addons.contactus;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.web.security.csrf.CSRFTokenUtil;

import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path("/contactus")
@Tag(name = "/contactus", description = "Contact Us Service")
public class ContactUsRESTService implements ResourceContainer {
  private static final Log LOG = ExoLogger.getLogger(ContactUsRESTService.class);

  private String recipient="";
  private MailService mailService;

  public ContactUsRESTService(InitParams initParams, MailService mailService) {
    this.mailService = mailService;
    if (initParams.getValueParam("recipient") != null) {
      recipient = initParams.getValueParam("recipient").getValue();
    }
  }

  @POST
  @Path("/send")
  @Operation(summary = "Send email with data provided", method = "POST", description = "Send email with data provided")
  @ApiResponses(value = {
      @ApiResponse(responseCode = "200", description = "Request fulfilled"),
      @ApiResponse(responseCode = "403", description = "Forbidden") })
  public Response send(@Context HttpServletRequest request, @FormParam("portal:csrf") String reqToken, @FormParam("body") String body, @FormParam("subject") String subject) {
    String sessionToken = CSRFTokenUtil.getToken(request);
    if (reqToken != null && reqToken.equals(sessionToken)) {
      if (!recipient.isEmpty()) {
        try {
          Message message = new Message();
          message.setBody(body);
          message.setTo(recipient);
          message.setSubject(subject);
          message.setFrom(MailUtils.getSenderEmail());
          mailService.sendMessage(message);
        } catch (Exception e) {
          LOG.error("Error sending email: ", e);
          return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
      } else {
        LOG.warn("Recipient email address is not configured.");
        return Response.status(Response.Status.BAD_REQUEST).entity("Recipient email address is not configured.").build();

      }
      return Response.ok().build();
    } else {
      return Response.status(Response.Status.FORBIDDEN).build();
    }

  }
}
