package org.exoplatform.copyfolder.services;

import org.exoplatform.container.ExoContainerContext;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class CopyFolderJob implements Job {
  @Override
  public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
    CopyFolderService copyFolderService = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CopyFolderService.class);
    copyFolderService.importFromDisk();
  }
}
