package org.exoplatform.copyfolder.services;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.picocontainer.Startable;

@Managed
@ManagedDescription("eXo Platform - Copy Folder")
@NameTemplate({@Property(
    key = "service",
    value = "copy-folder"
), @Property(
    key = "name",
    value = "CopyFolderService"
)})
@RESTEndpoint(
    path = "copyfolderservice"
)
public class CopyFolderServiceManagedBean implements Startable {

  private CopyFolderService copyFolderService;

  @Managed
  @ManagedDescription("Launch import")
  @Impact(ImpactType.READ)
  public void importFromDisk() throws Exception {
    new Thread(() -> {
      this.getCopyFolderService().importFromDisk();
    }).start();
  }

  @Override
  public void start() {

  }

  @Override
  public void stop() {

  }

  private CopyFolderService getCopyFolderService() {
    if (this.copyFolderService == null) {
      this.copyFolderService = getService(CopyFolderService.class);
    }

    return this.copyFolderService;
  }

  private static <T> T getService(Class<T> clazz) {
    return clazz.cast(getContainer().getComponentInstanceOfType(clazz));
  }

  private static ExoContainer getContainer() {
    ExoContainer container = ExoContainerContext.getCurrentContainer();
    if (container instanceof RootContainer) {
      container = PortalContainer.getInstance();
    }

    return container;
  }


}
