/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.crowdin;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

public class LoginCrowdinJIPTListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(LoginCrowdinJIPTListener.class);
    public static final String CROWDIN_JIPT_SYSTEM_PROPERTY_NAME = "crowdin.jipt";

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        String userId = ((ConversationState)event.getData()).getIdentity().getUserId();
        try {
            OrganizationService svc = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
            UserProfileHandler userProfileHandler = svc.getUserProfileHandler();
            UserProfile userProfile = userProfileHandler.findUserProfileByName(userId);
            if (userProfile == null) {
                UserProfile userProfileInstance = userProfileHandler.createUserProfileInstance(userId);
                userProfileInstance.getUserInfoMap().put("user.name.given", userId);
                userProfileHandler.saveUserProfile(userProfileInstance, true);
                userProfile = userProfileHandler.findUserProfileByName(userId);
            }
            if (userProfile != null && userProfile.getUserInfoMap() != null) {
                String currLocale = (String)userProfile.getUserInfoMap().get("user.language");
                String crowdinJiptLanguage = System.getProperty(CROWDIN_JIPT_SYSTEM_PROPERTY_NAME);
                if (currLocale == null || currLocale.trim().equals("") || !currLocale.equals(crowdinJiptLanguage)) {
                    userProfile.getUserInfoMap().put("user.language", crowdinJiptLanguage);
                    userProfileHandler.saveUserProfile(userProfile, false);
                    LOG.info((Object)("Set Crowdin JIPT user to " + crowdinJiptLanguage));
                }
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Error while logging the login of user '" + userId + "': " + e.getMessage()), (Throwable)e);
        }
    }
}

