/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.ItemExistsException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.cs.dao.EnvironmentDAO;
import org.exoplatform.cs.dao.SpaceDAO;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.EnvironmentEntity;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.BaseService;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.BufferAttachment;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.filter.model.ForumFilter;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.ProjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(TicketService.class);
    private TaskService taskService;
    private ForumService forumService;
    private ProjectService projectService;
    private StatusService statusService;
    private static final String DATE_FORMAT_DISPLAYED_IN_TICKETS_LIST = "yyyy-MM-dd HH:mm:ss";
    private static final String TOPIC_DEFAULT_DATE_FORMAT = "EE MMM dd HH:mm:ss z yyyy";
    private static final String TASK_DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateFormat DATE_FORMAT_TO_CONVERT_USED_FOR_TICKETS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat DEFAULT_DATE_FORMAT_USED_FOR_TOPICS = new SimpleDateFormat("EE MMM dd HH:mm:ss z yyyy");
    private static final DateFormat DEFAULT_DATE_FORMAT_USED_FOR_TASKS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public TicketService(ForumService forumService, ProjectService projectService, StatusService statusService, TaskService taskService, EnvironmentDAO environmentDAO, SpaceDAO spaceDAO, TopicDAO topicDAO) {
        super(environmentDAO, spaceDAO, topicDAO, null);
        this.taskService = taskService;
        this.forumService = forumService;
        this.statusService = statusService;
        this.projectService = projectService;
    }

    public EnvironmentDTO getTopicEnvironment(String topicId) {
        if (StringUtils.isBlank((String)topicId)) {
            throw new IllegalStateException("Parameter 'topicId' is null");
        }
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)topicId));
        if (topicEntity.getEnvironment() == null) {
            return null;
        }
        return this.convert(topicEntity.getEnvironment());
    }

    public List<TicketDTO> getTicketsOfSpace(String id) {
        List<TopicEntity> entities = this.topicDAO.getTopicsBySpace(id);
        ArrayList<TicketDTO> tickets = new ArrayList<TicketDTO>();
        for (TopicEntity topicEntity : entities) {
            tickets.add(this.convertToDTO(topicEntity, id));
        }
        return tickets;
    }

    public List<TicketDTO> getTickets() {
        List entities = this.topicDAO.findAll();
        ArrayList<TicketDTO> tickets = new ArrayList<TicketDTO>();
        for (TopicEntity topicEntity : entities) {
            SpaceEntity space = topicEntity.getSpace();
            String id = space.getGroupId();
            tickets.add(this.convertToDTO(topicEntity, id));
        }
        return tickets;
    }

    public List<TicketDTO> getEngSupportTickets(User user) {
        List<TicketDTO> ticketDTOs = this.getTickets();
        ArrayList<TicketDTO> tickets = new ArrayList<TicketDTO>();
        for (TicketDTO ticketDTO : ticketDTOs) {
            String username;
            String assignee = ticketDTO.getAssignee();
            if (assignee == null || !assignee.equals(username = user.getUserName())) continue;
            tickets.add(ticketDTO);
        }
        return tickets;
    }

    public String getManagersGroupId(String spaceGroupId) throws Exception {
        SpaceEntity space = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)spaceGroupId));
        String managersGroupId = space.getManagersGroupId();
        return managersGroupId;
    }

    public SpaceEntity getSpaceByGroupId(String groupID) {
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)groupID));
        return spaceEntity;
    }

    public TicketDTO UpdateTicketDTO(TicketDTO ticketDTO, SpaceEntity spaceEntity) {
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketDTO.getId()));
        EnvironmentEntity environmentEntity = null;
        environmentEntity = ticketDTO.getType().equals((Object)IssueType.INCIDENT) ? (EnvironmentEntity)this.environmentDAO.find(ticketDTO.getEnvironmentId()) : null;
        this.convertToEntity(ticketDTO, topicEntity, environmentEntity, spaceEntity);
        TopicEntity entity = (TopicEntity)this.topicDAO.update(topicEntity);
        TicketDTO ticketDTOUpdated = this.convertToDTO(entity, spaceEntity.getGroupId());
        return ticketDTOUpdated;
    }

    @ExoTransactional
    public void saveTicket(TicketDTO ticketDTO, User user) throws Exception {
        if (user == null) {
            throw new IllegalArgumentException("Method saveUser - argument user is null");
        }
        String email = user.getEmail();
        if (StringUtils.isBlank((String)email) || !ForumUtils.isValidEmailAddresses(email)) {
            throw new IllegalArgumentException("Method saveUser - argument user.email is null");
        }
        if (ticketDTO == null) {
            throw new IllegalArgumentException("Method saveUser - argument ticketDTO is null");
        }
        if (!ticketDTO.verifySaveConditions()) {
            throw new IllegalArgumentException("Method saveUser - argument ticketDTO is not conform: " + ticketDTO);
        }
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)ticketDTO.getSpaceGroupId()));
        if (spaceEntity == null) {
            throw new IllegalStateException("Method saveUser - Space is not found");
        }
        Date currentDate = CommonUtils.getGreenwichMeanTime().getTime();
        long tagIndex = spaceEntity.getTagIndex();
        if (IssueType.PRODUCT.equals((Object)ticketDTO.getType())) {
            Task task = new Task();
            task.setDescription(ticketDTO.getDescription());
            task.setTitle(ticketDTO.getTitle());
            task.setAssignee(spaceEntity.getTaskDefaultAssignee());
            ticketDTO.setAssignee(spaceEntity.getTaskDefaultAssignee());
            task.setCreatedBy(user.getUserName());
            task.setPriority(spaceEntity.getTaskPriority());
            task.setCreatedTime(currentDate);
            Date startDate = ticketDTO.retrieveFormattedStartDate();
            task.setStartDate(startDate);
            Date endDate = ticketDTO.retrieveFormattedEndDate();
            task.setEndDate(endDate);
            task.setDueDate(endDate);
            Status status = this.getSpaceProjectStatus(ticketDTO.getSpaceGroupId(), user.getUserName());
            task.setStatus(status);
            task = this.taskService.createTask(task);
            ticketDTO.setId("" + task.getId());
            String space = this.getSpaceForum(spaceEntity.getGroupId()).getForumName();
            String SpaceName = SpaceUtils.cleanString((String)space);
            String taskLink = "/portal/g/:spaces:" + SpaceName + "/" + SpaceName + "/tasks" + "/taskDetail/" + task.getId();
            ticketDTO.setLink(taskLink);
            this.save(ticketDTO, spaceEntity);
        } else if (IssueType.INCIDENT.equals((Object)ticketDTO.getType()) || IssueType.INFORMATION.equals((Object)ticketDTO.getType())) {
            Topic newTopic = new Topic();
            if (IssueType.INCIDENT.equals((Object)ticketDTO.getType())) {
                newTopic.setTopicName(HTMLSanitizer.sanitize((String)("[" + spaceEntity.getTagPrefix() + "-" + tagIndex + "] " + ticketDTO.getTitle())));
                List<FileItem> files = ticketDTO.getFiles();
                if (files != null && !files.isEmpty()) {
                    ArrayList<1> forumAttachments = new ArrayList<1>();
                    for (final FileItem fileItem : files) {
                        BufferAttachment attachment = new BufferAttachment(){
                            private static final long serialVersionUID = 1221108176051647731L;

                            public InputStream getInputStream() throws Exception {
                                return fileItem.getInputStream();
                            }
                        };
                        attachment.setName(fileItem.getName());
                        attachment.setMimeType(fileItem.getContentType());
                        forumAttachments.add(attachment);
                    }
                    newTopic.setAttachments(forumAttachments);
                }
            } else if (IssueType.INFORMATION.equals((Object)ticketDTO.getType())) {
                newTopic.setTopicName(HTMLSanitizer.sanitize((String)("[" + spaceEntity.getTagPrefix() + "-" + tagIndex + "] " + ticketDTO.getTitle())));
            } else {
                LOG.warn("Unrecognized ticket type {}, set default title without prefixes.", (Object)ticketDTO.getType());
                newTopic.setTopicName("[" + spaceEntity.getTagPrefix() + "-" + tagIndex + "] " + ticketDTO.getTitle());
            }
            Category spaceCategory = this.forumService.getCategoryIncludedSpace();
            if (spaceCategory == null) {
                throw new IllegalStateException("Cannot find Forum Spaces category.");
            }
            String groupId = spaceEntity.getGroupId();
            Forum spaceForum = this.getSpaceForum(groupId);
            String link = ForumUtils.createdForumLink(ForumUtils.TOPIC, newTopic.getId(), false);
            link = link.replace("/ticket", "/forum");
            ticketDTO.setLink(link);
            newTopic.setModifiedBy(user.getUserName());
            newTopic.setModifiedDate(currentDate);
            String message = HTMLSanitizer.sanitize((String)ticketDTO.getDescription());
            newTopic.setDescription(message);
            newTopic.setLink(link);
            newTopic.setIsNotifyWhenAddPost(email);
            newTopic.setIsWaiting(false);
            newTopic.setIsClosed(false);
            newTopic.setIsLock(false);
            newTopic.setIsModeratePost(false);
            newTopic.setIsSticky(false);
            newTopic.setIcon("");
            newTopic.setOwner(user.getUserName());
            this.forumService.saveTopic(spaceCategory.getId(), spaceForum.getId(), newTopic, true, false, new MessageBuilder());
            String[] moderators = spaceForum.getModerators();
            if (moderators == null || moderators.length == 0) {
                LOG.error("Space '{}' moderators is null, can't add tag to topic '{}'", (Object)groupId, (Object)newTopic.getId());
            } else {
                List userIds = ForumServiceUtils.getUserPermission((String[])new String[]{"*:" + groupId});
                if (userIds != null && !userIds.isEmpty()) {
                    Tag tagType;
                    Tag tagSeverity = this.forumService.getTag(Utils.TAG + ticketDTO.getSeverity().name());
                    if (tagSeverity == null) {
                        tagSeverity = new Tag();
                        tagSeverity.setUserTag(userIds.toArray(new String[0]));
                        tagSeverity.setName(ticketDTO.getSeverity().name());
                        tagSeverity.setId(Utils.TAG + ticketDTO.getSeverity().name());
                    }
                    if ((tagType = this.forumService.getTag(Utils.TAG + ticketDTO.getType().name())) == null) {
                        tagType = new Tag();
                        tagType.setUserTag(userIds.toArray(new String[0]));
                        tagType.setName(ticketDTO.getType().name());
                        tagType.setId(Utils.TAG + ticketDTO.getType().name());
                    }
                    ArrayList<Tag> tags = new ArrayList<Tag>();
                    tags.add(tagSeverity);
                    tags.add(tagType);
                    boolean notSaved = false;
                    do {
                        try {
                            for (String userId : userIds) {
                                this.forumService.addTag(tags, userId, newTopic.getPath());
                            }
                            notSaved = false;
                        }
                        catch (ItemExistsException e) {
                            ++tagIndex;
                            notSaved = true;
                        }
                    } while (notSaved);
                    spaceEntity.setTagIndex(tagIndex + 1L);
                    this.spaceDAO.update(spaceEntity);
                } else {
                    LOG.warn("Can't Save new Tag, no moderator found for space");
                }
            }
            ticketDTO.setId(newTopic.getId());
            ticketDTO.setLink(newTopic.getLink());
            this.save(ticketDTO, spaceEntity);
        } else {
            throw new UnsupportedOperationException("Method saveUser - argument ticketDTO.type is not recognized");
        }
    }

    private Forum getSpaceForum(String groupId) {
        Category spaceCategory = this.forumService.getCategoryIncludedSpace();
        ForumFilter forumFilter = new ForumFilter();
        forumFilter.categoryId(spaceCategory.getId());
        String spacePrettyName = groupId.replace("/spaces/", "");
        String forumId = Utils.FORUM_SPACE_ID_PREFIX + spacePrettyName;
        forumFilter.setForumId(forumId);
        Forum spaceForum = null;
        List forums = this.forumService.getForums(forumFilter);
        for (Forum forum : forums) {
            if (!forum.getId().equalsIgnoreCase(forumId)) continue;
            spaceForum = forum;
        }
        if (spaceForum == null) {
            throw new IllegalStateException("Space Forum was not found: " + spacePrettyName);
        }
        return spaceForum;
    }

    private Status getSpaceProjectStatus(String spaceGroupId, String username) {
        Long spaceProjectId = null;
        if (spaceGroupId != null) {
            List projects = ProjectUtil.flattenTree((List)ProjectUtil.getProjectTree((String)spaceGroupId, (ProjectService)this.projectService), (ProjectService)this.projectService);
            for (Project p : projects) {
                if (!p.canView(new Identity(username))) continue;
                spaceProjectId = p.getId();
            }
        }
        if (spaceProjectId == null) {
            throw new IllegalStateException("Can't fin adequate tasks project for space: " + spaceGroupId);
        }
        Status status = this.statusService.getDefaultStatus(spaceProjectId.longValue());
        return status;
    }

    protected void save(TicketDTO ticketDTO, SpaceEntity spaceEntity) {
        TopicEntity topicEntity;
        if (ticketDTO == null) {
            throw new IllegalArgumentException("Method save - Parameter 'ticketDTO' is null");
        }
        if (StringUtils.isBlank((String)ticketDTO.getId())) {
            throw new IllegalArgumentException("Method save - Parameter 'ticketDTO.id' is null");
        }
        EnvironmentEntity environmentEntity = null;
        if (ticketDTO.getType().equals((Object)IssueType.INCIDENT)) {
            environmentEntity = (EnvironmentEntity)this.environmentDAO.find(ticketDTO.getEnvironmentId());
            if (environmentEntity == null) {
                throw new IllegalStateException("Environment with id '" + ticketDTO.getEnvironmentId() + "' is null");
            }
            if (environmentEntity.getSpace() == null) {
                throw new IllegalStateException("Environment's space is null");
            }
        }
        if ((topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketDTO.getId()))) == null) {
            topicEntity = new TopicEntity();
            this.convertToEntity(ticketDTO, topicEntity, environmentEntity, spaceEntity);
            this.topicDAO.create(topicEntity);
        } else {
            this.convertToEntity(ticketDTO, topicEntity, environmentEntity, spaceEntity);
            this.topicDAO.update(topicEntity);
        }
    }

    private void convertToEntity(TicketDTO ticketDTO, TopicEntity topicEntity, EnvironmentEntity environmentEntity, SpaceEntity spaceEntity) {
        topicEntity.setId(ticketDTO.getId());
        topicEntity.setEnvironment(environmentEntity);
        topicEntity.setSpace(spaceEntity);
        topicEntity.setType(ticketDTO.getType());
        topicEntity.setSeverity(ticketDTO.getSeverity());
        topicEntity.setInfoType(ticketDTO.getInfoType());
        topicEntity.setLink(ticketDTO.getLink());
        topicEntity.setAssignee(ticketDTO.getAssignee());
    }

    private TicketDTO convertToDTO(TopicEntity topicEntity, String groupId) {
        TicketDTO ticketDTO = new TicketDTO();
        ticketDTO.setEnvironmentName(topicEntity.getEnvironment() == null ? null : topicEntity.getEnvironment().getName());
        ticketDTO.setSeverity(topicEntity.getSeverity());
        ticketDTO.setInfoType(topicEntity.getInfoType());
        ticketDTO.setLink(topicEntity.getLink());
        ticketDTO.setType(topicEntity.getType());
        ticketDTO.setAssignee(topicEntity.getAssignee());
        ticketDTO.setSpaceGroupId(groupId);
        switch (topicEntity.getType()) {
            case INCIDENT: {
                ticketDTO.setEnvironmentId(topicEntity.getEnvironment().getId());
            }
            case INFORMATION: {
                String topicId = topicEntity.getId();
                Category spaceCategory = this.forumService.getCategoryIncludedSpace();
                Forum forum = this.getSpaceForum(groupId);
                if (spaceCategory == null || forum == null) break;
                try {
                    Topic topic = this.forumService.getTopic(spaceCategory.getId(), forum.getId(), topicId, null);
                    ticketDTO.setDescription(topic.getDescription());
                    ticketDTO.setId(topicId);
                    String startDate = topic.getCreatedDate().toString();
                    String ticketDate = this.convertDate(DEFAULT_DATE_FORMAT_USED_FOR_TOPICS, startDate);
                    ticketDTO.setStartDate(ticketDate);
                    ticketDTO.setLink(topic.getLink());
                    ticketDTO.setTitle(CommonUtils.decodeSpecialCharToHTMLnumber((String)topic.getTopicName()));
                    ticketDTO.setStatus(topic.getIsClosed() ? "Closed" : (topic.getIsWaiting() ? "Waiting for Support" : (topic.getIsActive() ? "Waiting for Customer" : "inprogress")));
                    if (topic.getTagId() == null || topic.getTagId().length <= 0) break;
                    String tagId = topic.getTagId()[0];
                    Tag tag = this.forumService.getTag(tagId);
                    if (tag != null) {
                        ticketDTO.setTagName(tag.getName());
                        break;
                    }
                    if (!tagId.contains(":tag")) break;
                    ticketDTO.setTagName(tagId.split(":tag")[1]);
                }
                catch (Exception e) {
                    LOG.warn("An error occured while getting data of Topic '" + topicId + "'", (Throwable)e);
                }
                break;
            }
            case PRODUCT: {
                long taskId = Long.parseLong(topicEntity.getId());
                Task task = null;
                try {
                    task = this.taskService.getTask(taskId);
                }
                catch (EntityNotFoundException e) {
                    LOG.warn("Task with id '{}' was not found", (Object)topicEntity.getId());
                }
                if (task == null) break;
                ticketDTO.setId(String.valueOf(task.getId()));
                ticketDTO.setDescription(task.getDescription());
                if (task.getStartDate() != null) {
                    String startDateTask = task.getStartDate().toString();
                    String ticketDateTask = this.convertDate(DEFAULT_DATE_FORMAT_USED_FOR_TASKS, startDateTask);
                    ticketDTO.setStartDate(ticketDateTask);
                }
                ticketDTO.setTitle(task.getTitle());
                ticketDTO.setStatus(task.getStatus() == null ? "inprogress" : task.getStatus().getName());
                break;
            }
        }
        return ticketDTO;
    }

    private String convertDate(DateFormat dateFormat, String startDate) {
        Date date = null;
        try {
            date = dateFormat.parse(startDate);
        }
        catch (ParseException e) {
            LOG.error("Error when parsing date" + e);
        }
        if (date != null) {
            return DATE_FORMAT_TO_CONVERT_USED_FOR_TICKETS.format(date);
        }
        return null;
    }
}

