package org.exoplatform.cs.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;

@Data
@JsonIgnoreProperties({"simpleDateFormat"})
public class TicketDTO {

  @JsonIgnore
  public SimpleDateFormat simpleDateFormat = new SimpleDateFormat();

  /**
   * Can be Forum Topic id or Task id
   */
  private String                    id;

  private String                    title;

  private String                    status;

  private String                    description;

  private String                    link;

  private String                    assignee;

  private String                    tagName;

  private IssueType                 type;

  private IssueSeverity             severity;

  private InfoType                  infoType;

  private String                    spaceGroupId;

  private String                    environmentName;

  private Long                      environmentId;

  private String                    startDate;

  private String                    endDate;

  private String updateDate;

  private transient String          dateFormat;
  
  private List<FileItem>            files;

  public boolean verifySaveConditions() {
    if (StringUtils.isEmpty(title) || StringUtils.isEmpty(description) || type == null || spaceGroupId == null
        || (IssueType.INCIDENT.equals(type) && (environmentId == null || severity == null))
        || (IssueType.INFORMATION.equals(type) && infoType == null)) {
      return false;
    }
    return true;
  }

  public Date retrieveFormattedStartDate() throws ParseException {
    return retrieveFormattedDate(startDate);
  }

  public Date retrieveFormattedEndDate() throws ParseException {
    return retrieveFormattedDate(endDate);
  }


  private Date retrieveFormattedDate(String dateValue) throws ParseException {
    if (StringUtils.isEmpty(dateValue) || StringUtils.isEmpty(dateFormat)) {
      return null;
    }
    simpleDateFormat.applyPattern(dateFormat);
    return simpleDateFormat.parse(dateValue);
  }

}
