package org.exoplatform.cs.service.util;

import java.util.Arrays;
import java.util.List;


import javax.sound.sampled.Port;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

/**
 * Created by IntelliJ IDEA.
 * User: ali
 * Date: 30/01/17
 * Time: 17:55
 */
public class CSUtils {
  private static final String SUPPORT_TEAM_NAME_DEFAULT = "support-team";
  private static final String SUPPORT_GROUP_NAME_CONFIGURATION = "exo.addon.cs.support.group.name";

  public static String getSupportTeamGroupID(){
    String groupId = PropertyManager.getProperty(SUPPORT_GROUP_NAME_CONFIGURATION);
    if(groupId == null || groupId.isEmpty()){
      groupId = SUPPORT_TEAM_NAME_DEFAULT;
    }
    return groupId;
  }
  public static List<User> getSupportMembers() throws Exception {
    PortalContainer container = PortalContainer.getInstance();
    OrganizationService organizationService = container.getComponentInstanceOfType(OrganizationService.class);
    String groupId = CSUtils.getSupportTeamGroupID();
    ListAccess<User> engSupportList = organizationService.getUserHandler().findUsersByGroupId(groupId);
    User[] users = engSupportList.load(0, engSupportList.getSize());
    return Arrays.asList(users);
  }
}
