package org.exoplatform.cs.dao;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.StatLogEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

import java.util.Calendar;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: ali
 * Date: 06/01/17
 * Time: 12:15
 */
public class StatLogDAO extends GenericDAOJPAImpl<StatLogEntity, Long> {
private static final Logger LOG = LoggerFactory.getLogger(StatLogDAO.class);


    public List<StatLogEntity> getAllStatsByType(String type) throws Exception{
        return getEntityManager().createNamedQuery("statLogEntity.getAllStatsByType", StatLogEntity.class)
                .setParameter("statType", type)
                .getResultList();
    }
    public List<StatLogEntity> getWeeklyStatsByType(String type) throws Exception{
        return getEntityManager().createNamedQuery("statLogEntity.getWeeklyStatsByType", StatLogEntity.class)
                .setParameter("statType", type)
                .getResultList();
    }
    public List<StatLogEntity> getMonthlyStatsByType(String type) throws Exception{
        return getEntityManager().createNamedQuery("statLogEntity.getMonthlyStatsByType", StatLogEntity.class)
                .setParameter("statType", type)
                .getResultList();
    }

    public List<StatLogEntity> getAllStatsByTypeAndDates(String type,Calendar from, Calendar to) throws Exception{
        return getEntityManager().createNamedQuery("statLogEntity.getAllStatsByTypeAndDates", StatLogEntity.class)
                .setParameter("statType", type)
                .setParameter("spaceGroupID", from)
                .setParameter("spaceGroupID", to)
                .getResultList();
    }
    public List<StatLogEntity> getWeeklyStatsByTypeAndDates(String type,Calendar from, Calendar to) throws Exception{
        return getEntityManager().createNamedQuery("statLogEntity.getWeeklyStatsByTypeAndDates", StatLogEntity.class)
                .setParameter("statType", type)
                .setParameter("spaceGroupID", from)
                .setParameter("spaceGroupID", to)
                .getResultList();
    }
    public List<StatLogEntity> getMonthlyStatsByTypeAndDates(String type,Calendar from, Calendar to) throws Exception{
        return getEntityManager().createNamedQuery("statLogEntity.getMonthlyStatsByTypeAndDates", StatLogEntity.class)
                .setParameter("statType", type)
                .setParameter("spaceGroupID", from)
                .setParameter("spaceGroupID", to)
                .getResultList();
    }
    public List<StatLogEntity> getStatsByTypeAndDate(String type, Calendar statDate) throws Exception{
        return getEntityManager().createNamedQuery("statLogEntity.getStatsByTypeAndDate", StatLogEntity.class)
                .setParameter("statType", type)
                .setParameter("statDate", statDate)
                .getResultList();
    }
}
