/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.dao;

import java.util.Calendar;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.entity.SpaceEntity;

import javax.persistence.TemporalType;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
public class SpaceDAO extends GenericDAOJPAImpl<SpaceEntity, String> {
  private static final Logger LOG = LoggerFactory.getLogger(SpaceDAO.class);

  public List<SpaceEntity> getSpaces(int offset, int limit) {
    try {
      if (offset >= 0 && limit > 0) {
        return getEntityManager().createNamedQuery("spaceEntity.findAllOrderBy", SpaceEntity.class)
                                 .setFirstResult(offset)
                                 .setMaxResults(limit)
                                 .getResultList();
      } else {
        return findAll();
      }
    } catch (Exception e) {
      LOG.warn("Exception while attempting to get spaces with offset = '" + offset + "' and limit = '" + limit + "'.", e);
      throw e;
    }
  }

  public List<SpaceEntity> getSpacesByType(boolean internal, int offset, int limit) {
    try {
      if (offset >= 0 && limit > 0) {
        return getEntityManager().createNamedQuery("spaceEntity.findByTypeOrderBy", SpaceEntity.class)
                                 .setParameter("internal", internal)
                                 .setFirstResult(offset)
                                 .setMaxResults(limit)
                                 .getResultList();
      } else {
        return findAll();
      }
    } catch (Exception e) {
      LOG.warn("Exception while attempting to get spaces with offset = '" + offset + "' and limit = '" + limit + "'.", e);
      throw e;
    }
  }

  public long getSpacesCount() {
    try {
      return getEntityManager().createNamedQuery("spaceEntity.count", Long.class).getSingleResult();
    } catch (Exception e) {
      LOG.warn("Exception while attempting to get spaces count.", e);
      throw e;
    }
  }

  public List<SpaceEntity> getActiveSpaces(int offset, int limit) {
    try {
      if (offset >= 0 && limit > 0) {
        return getEntityManager().createNamedQuery("spaceEntity.findActiveOrderBy", SpaceEntity.class)
                                 .setFirstResult(offset)
                                 .setMaxResults(limit)
                                 .getResultList();
      } else {
        return getEntityManager().createNamedQuery("spaceEntity.findActiveOrderBy", SpaceEntity.class)
                .getResultList();
      }
    } catch (Exception e) {
      LOG.warn("Exception while attempting to get spaces with offset = '" + offset + "' and limit = '" + limit + "'.", e);
      throw e;
    }
  }

  public long getActiveSpacesCount() {
    try {
      return getEntityManager().createNamedQuery("spaceEntity.countActive", Long.class).getSingleResult();
    } catch (Exception e) {
      LOG.warn("Exception while attempting to get spaces count.", e);
      throw e;
    }
  }

  public List<SpaceEntity> getDeactvatedSpaces(int offset, int limit) {
    try {
      if (offset >= 0 && limit > 0) {
        return getEntityManager().createNamedQuery("spaceEntity.findDeactvatedOrderBy", SpaceEntity.class)
                                 .setFirstResult(offset)
                                 .setMaxResults(limit)
                                 .getResultList();
      } else {
        return getEntityManager().createNamedQuery("spaceEntity.findDeactvatedOrderBy", SpaceEntity.class)
                .getResultList();
      }
    } catch (Exception e) {
      LOG.warn("Exception while attempting to get spaces with offset = '" + offset + "' and limit = '" + limit + "'.", e);
      throw e;
    }
  }
  public List<SpaceEntity> getActiveByEndSubscriptionDate(Calendar fromDate, Calendar toDate) {
    try {
        return getEntityManager().createNamedQuery("spaceEntity.getActiveByEndSubscriptionDate", SpaceEntity.class)
                .setParameter("from", fromDate, TemporalType.TIMESTAMP).
                  setParameter("to", toDate, TemporalType.TIMESTAMP).getResultList();


    } catch (Exception e) {
      LOG.warn("Exception while attempting to get spaces.", e);
      throw e;
    }
  }

  public long getDeactvatedSpacesCount() {
    try {
      return getEntityManager().createNamedQuery("spaceEntity.countDeactvated", Long.class).getSingleResult();
    } catch (Exception e) {
      LOG.warn("Exception while attempting to get spaces count.", e);
      throw e;
    }
  }

}
