/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.entity;

import java.beans.ConstructorProperties;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="CSTypeEntity")
@ExoEntity
@Table(name="CS_ADDON_TYPES")
@DiscriminatorColumn(name="TYPE_NAME", discriminatorType=DiscriminatorType.STRING, length=20)
@NamedQueries(value={@NamedQuery(name="typeEntity.getTypeByName", query="SELECT a FROM CSTypeEntity a where a.label = :name"), @NamedQuery(name="typeEntity.getTypeObjects", query="SELECT a FROM CSTypeEntity a where a.class = :className")})
public class TypeEntity {
    @Id
    @Column(name="TYPE_ID")
    @SequenceGenerator(name="SEQ_CS_TYPE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CS_TYPE_ID")
    private Long id;
    @Column(name="TYPE_LABEL", nullable=false)
    private String label;
    @Column(name="TYPE_OTHER", nullable=false)
    private Boolean other = false;

    @ConstructorProperties(value={"id", "label", "other"})
    public TypeEntity(Long id, String label, Boolean other) {
        this.id = id;
        this.label = label;
        this.other = other;
    }

    public TypeEntity() {
    }

    public Long getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getOther() {
        return this.other;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setOther(Boolean other) {
        this.other = other;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeEntity)) {
            return false;
        }
        TypeEntity other = (TypeEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        Boolean this$other = this.getOther();
        Boolean other$other = other.getOther();
        return !(this$other == null ? other$other != null : !((Object)this$other).equals(other$other));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TypeEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        Boolean $other = this.getOther();
        result = result * 59 + ($other == null ? 43 : ((Object)$other).hashCode());
        return result;
    }

    public String toString() {
        return "TypeEntity(id=" + this.getId() + ", label=" + this.getLabel() + ", other=" + this.getOther() + ")";
    }
}

