/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.listener;

import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.integration.notification.CSSpaceEditionPlugin;
import org.exoplatform.cs.integration.notification.NotificationUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;

@Asynchronous
public class CSSpaceUpdatedLogListener
extends Listener<SpaceDTO, Map<String, String>> {
    public void onEvent(Event<SpaceDTO, Map<String, String>> event) throws Exception {
        SpaceDTO spaceDTO = (SpaceDTO)event.getSource();
        Map changes = (Map)event.getData();
        String actioName = (String)changes.get("action.name");
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(CSSpaceEditionPlugin.SPACE, (Object)spaceDTO).append(NotificationUtils.ACTION_NAME, (Object)actioName);
        String creator = ConversationState.getCurrent().getIdentity().getUserId();
        ctx.append(NotificationUtils.CREATOR_NAME, (Object)creator);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CSSpaceEditionPlugin"))).execute(ctx);
    }
}

