/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.tickets;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.cs.service.tickets.Flow;
import org.exoplatform.cs.service.tickets.FlowConfig;
import org.exoplatform.cs.service.tickets.FlowPlugin;
import org.exoplatform.cs.service.tickets.FlowState;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picocontainer.Startable;

public class TicketStatusFlowService
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(TicketStatusFlowService.class);
    public static final String STATUS_CHANGED = "ticket.status.changed";
    private Map<String, Flow> flows = new HashMap<String, Flow>();
    public static String INITIAL_STATE = "open";

    public void addFlow(ComponentPlugin flowPlugin) {
        FlowConfig config;
        if (flowPlugin instanceof FlowPlugin && (config = ((FlowPlugin)flowPlugin).getFlowConfig()) != null) {
            this.flows.put(config.getFlow().getName(), config.getFlow());
        }
    }

    public List<String> getSuccessors(String status, String flowName) {
        Flow flow = this.flows.get(flowName);
        for (FlowState state : flow.getStates()) {
            if (!status.equalsIgnoreCase(state.getState())) continue;
            return state.getSuccessors();
        }
        return null;
    }

    public Map<String, List<FlowState>> getAllStatuses() {
        HashMap<String, List<FlowState>> allStates = new HashMap<String, List<FlowState>>();
        for (Flow flow : this.flows.values()) {
            allStates.put(flow.getName(), flow.getStates());
        }
        return allStates;
    }

    public Flow getFlowbyName(String name) {
        for (Flow flow : this.flows.values()) {
            if (!flow.getName().equals(name)) continue;
            return flow;
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Map<String, Flow> getFlows() {
        return this.flows;
    }
}

