/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.job;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.integration.notification.CSReminderPlugin;
import org.exoplatform.cs.service.TicketService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReminderNotificationJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(ReminderNotificationJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        ExoContainer containerContext = ExoContainerContext.getCurrentContainer();
        TicketService ticketService = (TicketService)containerContext.getComponentInstanceOfType(TicketService.class);
        Calendar c = Calendar.getInstance();
        c.add(5, -2);
        List<TopicEntity> tickets = ticketService.findTicketsForReminder(c);
        for (TopicEntity ticket : tickets) {
            NotificationContext ctx;
            String period = "";
            Calendar c1 = Calendar.getInstance();
            c1.add(5, -7);
            Calendar c2 = Calendar.getInstance();
            c2.add(5, -8);
            if (ticket.getUpdateDate().before(c1) && ticket.getUpdateDate().after(c2)) {
                period = "7";
                ctx = NotificationContextImpl.cloneInstance().append(CSReminderPlugin.TICKET, (Object)ticket).append(CSReminderPlugin.PERIOD, (Object)period);
                ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CSReminderPlugin"))).execute(ctx);
            }
            c1 = Calendar.getInstance();
            c1.add(5, -3);
            c2 = Calendar.getInstance();
            c2.add(5, -4);
            if (ticket.getUpdateDate().before(c1) && ticket.getUpdateDate().after(c2)) {
                period = "3";
                ctx = NotificationContextImpl.cloneInstance().append(CSReminderPlugin.TICKET, (Object)ticket).append(CSReminderPlugin.PERIOD, (Object)period);
                ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CSReminderPlugin"))).execute(ctx);
            }
            c1 = Calendar.getInstance();
            c1.add(5, -2);
            c2 = Calendar.getInstance();
            c2.add(5, -3);
            if (!ticket.getUpdateDate().before(c1) || !ticket.getUpdateDate().after(c2)) continue;
            period = "2";
            ctx = NotificationContextImpl.cloneInstance().append(CSReminderPlugin.TICKET, (Object)ticket).append(CSReminderPlugin.PERIOD, (Object)period);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CSReminderPlugin"))).execute(ctx);
        }
        LOG.info("Reminder Notification Job finished");
    }
}

