/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portal.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;

public class CustomerSpaceHandler
extends WebRequestHandler {
    protected static Log log = ExoLogger.getLogger(CustomerSpaceHandler.class);
    public static final QualifiedName REQUEST_TICKET_ID = QualifiedName.create((String)"gtn", (String)"ticketID");

    public String getHandlerName() {
        return "customerspace";
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpServletRequest req = controllerContext.getRequest();
        HttpServletResponse res = controllerContext.getResponse();
        SpaceService spaceService = (SpaceService)PortalContainer.getComponent(SpaceService.class);
        String requestTicketId = controllerContext.getParameter(REQUEST_TICKET_ID);
        TicketService ticketService = (TicketService)PortalContainer.getComponent(TicketService.class);
        try {
            TicketDTO ticket = ticketService.findByTicketId(requestTicketId);
            String spacePrettyName = spaceService.getSpaceByGroupId(ticket.getSpaceGroupId()).getPrettyName();
            if (ticket != null) {
                String redirectLink = "/portal/g/" + ticket.getSpaceGroupId().replaceAll("/", ":") + "/" + spacePrettyName + "/forum/topic/" + ticket.getId();
                log.debug("Redirecting to {}", new Object[]{redirectLink});
                res.sendRedirect(redirectLink);
                return true;
            }
        }
        catch (Exception e) {
            log.error("Exception getting ticket for ticket ID {}", new Object[]{requestTicketId, e});
            return false;
        }
        return false;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }
}

