package org.exoplatform.cs.rest.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.exoplatform.cs.dto.BrowserDTO;

import java.util.HashMap;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class CSEnvironment implements  Cloneable {

    private Long id;
    private String name;
    private String spaceGroupId;
    private boolean defaultEnvironment;
    private long typeId = 0;
    private String typeName;
    private long typeOtherId = -1;
    private String typeOtherName;
    private String productVersion;
    private long osId = 0;
    private String osName;
    private long osOtherId = -1;
    private String osOtherName;
    private String osVersion;
    private long jvmVendorId = 0;
    private String jvmVendorName;
    private long jvmVendorOtherId = -1;
    private String jvmVendorOtherName;
    private String jvmVersion;
    private long asId = 0;
    private String asName;
    private long asOtherId = -1;
    private String asOtherName;
    private String asVersion;
    private long dbId = 0;
    private String dbName;
    private long dbOtherId = -1;
    private String dbOtherName;
    private String dbVersion;
    private String dbEncoding;
    private long ssoId = 0;
    private String ssoName;
    private long ssoOtherId = -1;
    private String ssoOtherName;
    private String ssoVersion;
    private String moreInformation;
    private Map<String, BrowserDTO> browsers = new HashMap<String, BrowserDTO>();
    private String updateDate;
    private String customerExtensionVersion;
    private String installedPatchVersion;

    public CSEnvironment clone() {
        return new CSEnvironment(id, name, spaceGroupId, defaultEnvironment, typeId, typeName, typeOtherId, typeOtherName,
                productVersion, osId, osName, osOtherId, osOtherName, osVersion,jvmVendorId, jvmVendorName,
                jvmVendorOtherId, jvmVendorOtherName, jvmVersion, asId, asName, asOtherId, asOtherName, asVersion,
                dbId, dbName, dbOtherId, dbOtherName, dbVersion, dbEncoding, ssoId, ssoName, ssoOtherId, ssoOtherName,
                ssoVersion, moreInformation, browsers, updateDate, customerExtensionVersion, installedPatchVersion);
    }
}
