/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.exoplatform.commons.api.persistence.ExoEntity;

import javax.persistence.*;
import java.util.Calendar;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
@Entity(name = "CSStatLogEntity")
@ExoEntity
@Table(name = "CS_ADDON_STAT_LOG")
@NamedQueries({
 @NamedQuery(name = "statLogEntity.getAllStatsByType", query = "SELECT a FROM CSStatLogEntity a where a.statType = :statType group by a.statDate"),
 @NamedQuery(name = "statLogEntity.getWeeklyStatsByType", query = "SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.weekly = true group by a.statDate"),
 @NamedQuery(name = "statLogEntity.getMonthlyStatsByType", query = "SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.monthly = true group by a.statDate"),
 @NamedQuery(name = "statLogEntity.getStatsByTypeAndDate", query = "SELECT a FROM CSStatLogEntity a where a.statType = :statType  AND a.statDate = :statDate"),
 @NamedQuery(name = "statLogEntity.getAllStatsByTypeAndDates", query = "SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.statDate >= :from AND a.statDate <= :to"),
 @NamedQuery(name = "statLogEntity.getWeeklyStatsByTypeAndDates", query = "SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.weekly = true AND a.statDate >= :from AND a.statDate <= :to"),
 @NamedQuery(name = "statLogEntity.getMonthlyStatsByTypeAndDates", query = "SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.monthly = true AND a.statDate >= :from AND a.statDate <= :to")
})
@AllArgsConstructor
@NoArgsConstructor
@Data
public class StatLogEntity {
  @Id
  @Column(name = "STAT_LOG_ID")
  @SequenceGenerator(name = "SEQ_CS_STAT_LOG_ID", sequenceName = "SEQ_CS_STAT_LOG_ID", allocationSize = 1)
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "SEQ_CS_STAT_LOG_ID")
  private Long    id;

  @Column(name = "STAT_DATE")
  @Temporal(TemporalType.TIMESTAMP)
  private Calendar statDate;

  @Column(name = "STAT_TYPE")
  private String  statType;

  @Column(name = "STATUS")
  private String  status;

  @Column(name = "TICKETS_NUMBER")
  private Long  ticketsNumber;

  @Column(name = "WEEKLY")
  private Boolean  weekly;

  @Column(name = "MONTHLY")
  private Boolean  monthly;


  @Column(name = "SPACE_ID")
  private String  spaceId;

}
