/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.util;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ForumUtils {
    protected static Log log = ExoLogger.getLogger(ForumUtils.class);
    public static final String FIELD_EXOFORUM_LABEL = "eXoForum".intern();
    public static final String FIELD_SEARCHFORUM_LABEL = "SearchForum".intern();
    public static final String UPLOAD_FILE_SIZE = "uploadFileSizeLimitMB".intern();
    public static final String UPLOAD_AVATAR_SIZE = "uploadAvatarSizeLimitMB".intern();
    public static final String SEARCHFORM_ID = "SearchForm".intern();
    public static final String GOPAGE_ID_T = "goPageTop".intern();
    public static final String GOPAGE_ID_B = "goPageBottom".intern();
    public static final String CATEGORIES = "Categories".intern();
    public static final String CATEGORY = "category".intern();
    public static final String FORUM = "forum".intern();
    public static final String TOPIC = "topic".intern();
    public static final String POST = "post".intern();
    public static final String TAG = "Tag".intern();
    public static final String POLL = "Poll".intern();
    public static final String COMMA = ",".intern();
    public static final String SLASH = "/".intern();
    public static final String EMPTY_STR = "".intern();
    public static final String SPACE_GROUP_ID = "/spaces".replace(SLASH, EMPTY_STR);
    public static final int MAXSIGNATURE = 300;
    public static final int MAXTITLE = 100;
    public static final int DEFAULT_VALUE_UPLOAD_PORTAL = -1;
    public static final long MAXMESSAGE = 10000L;
    public static final String HAS_CREATE_TOPIC = "hasCreateTopic";
    public static final String HAS_CREATE_POLL = "hasCreatePoll";
    public static final String VIEW_LAST_POST = "lastpost";
    public static final String EMAIL_VALIDATION_REGEX = "gatein.validators.email.regexp";

    public static String createdForumLink(String type, String id, boolean isPrivate) {
        try {
            String containerName = ((ExoContainerContext)CommonsUtils.getService(ExoContainerContext.class)).getPortalContainerName();
            String pageNodeSelected = Util.getUIPortal().getSelectedUserNode().getURI();
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            return ForumUtils.buildLink(portalContext.getPortalURI(), containerName, pageNodeSelected, type, id, isPrivate);
        }
        catch (Exception e) {
            return id;
        }
    }

    public static String buildLink(String portalURI, String containerName, String selectedNode, String type, String id, boolean isPrivate) {
        StringBuilder sb = new StringBuilder();
        portalURI = portalURI.concat(selectedNode).concat(SLASH);
        if (!isPrivate) {
            sb.append(ForumUtils.buildForumLink(portalURI, type, id));
        } else {
            String host = portalURI.substring(0, portalURI.indexOf(containerName) - 1);
            sb.append(host).append(SLASH).append(containerName).append(SLASH).append("login?&initialURI=").append(ForumUtils.buildForumLink(portalURI.replaceFirst(host, EMPTY_STR), type, id)).toString();
        }
        return sb.toString();
    }

    public static boolean isValidEmailAddresses(String addressList) {
        if (StringUtils.isBlank((String)addressList)) {
            return false;
        }
        addressList = StringUtils.remove((String)addressList, (String)" ");
        addressList = StringUtils.replace((String)addressList, (String)";", (String)COMMA);
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            String emailRegex = System.getProperty(EMAIL_VALIDATION_REGEX, "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
            for (int i = 0; i < iAdds.length; ++i) {
                if (iAdds[i].getAddress().matches(emailRegex)) continue;
                return false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }

    private static String buildForumLink(String url, String type, String id) {
        StringBuilder link = new StringBuilder(url);
        if (!StringUtils.isBlank((String)type) && !StringUtils.isBlank((String)id)) {
            if (link.lastIndexOf(SLASH) == link.length() - 1) {
                link.append(type);
            } else {
                link.append(SLASH).append(type);
            }
            if (!id.equals(Utils.FORUM_SERVICE)) {
                link.append(SLASH).append(id);
            }
        }
        return link.toString();
    }
}

